/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class SetPublishingModeRequest
extends ExtensionObjectDefinition
implements Message {
    protected final ExtensionObjectDefinition requestHeader;
    protected final boolean publishingEnabled;
    protected final int noOfSubscriptionIds;
    protected final List<Long> subscriptionIds;

    @Override
    public String getIdentifier() {
        return "799";
    }

    public SetPublishingModeRequest(ExtensionObjectDefinition requestHeader, boolean publishingEnabled, int noOfSubscriptionIds, List<Long> subscriptionIds) {
        this.requestHeader = requestHeader;
        this.publishingEnabled = publishingEnabled;
        this.noOfSubscriptionIds = noOfSubscriptionIds;
        this.subscriptionIds = subscriptionIds;
    }

    public ExtensionObjectDefinition getRequestHeader() {
        return this.requestHeader;
    }

    public boolean getPublishingEnabled() {
        return this.publishingEnabled;
    }

    public int getNoOfSubscriptionIds() {
        return this.noOfSubscriptionIds;
    }

    public List<Long> getSubscriptionIds() {
        return this.subscriptionIds;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("SetPublishingModeRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("requestHeader", this.requestHeader, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField("reserved", (byte)0, DataWriterFactory.writeUnsignedByte(writeBuffer, 7), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("publishingEnabled", this.publishingEnabled, DataWriterFactory.writeBoolean(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("noOfSubscriptionIds", this.noOfSubscriptionIds, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleTypeArrayField("subscriptionIds", this.subscriptionIds, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        writeBuffer.popContext("SetPublishingModeRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        SetPublishingModeRequest _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.requestHeader.getLengthInBits();
        lengthInBits += 7;
        ++lengthInBits;
        lengthInBits += 32;
        if (this.subscriptionIds != null) {
            lengthInBits += 32 * this.subscriptionIds.size();
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("SetPublishingModeRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        ExtensionObjectDefinition requestHeader = FieldReaderFactory.readSimpleField("requestHeader", new DataReaderComplexDefault<ExtensionObjectDefinition>(() -> ExtensionObjectDefinition.staticParse(readBuffer, "391"), readBuffer), new WithReaderArgs[0]);
        Byte reservedField0 = FieldReaderFactory.readReservedField("reserved", DataReaderFactory.readUnsignedByte(readBuffer, 7), (byte)0, new WithReaderArgs[0]);
        boolean publishingEnabled = FieldReaderFactory.readSimpleField("publishingEnabled", DataReaderFactory.readBoolean(readBuffer), new WithReaderArgs[0]);
        int noOfSubscriptionIds = FieldReaderFactory.readSimpleField("noOfSubscriptionIds", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        List<Long> subscriptionIds = FieldReaderFactory.readCountArrayField("subscriptionIds", DataReaderFactory.readUnsignedLong(readBuffer, 32), noOfSubscriptionIds, new WithReaderArgs[0]);
        readBuffer.closeContext("SetPublishingModeRequest", new WithReaderArgs[0]);
        return new SetPublishingModeRequestBuilderImpl(requestHeader, publishingEnabled, noOfSubscriptionIds, subscriptionIds);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SetPublishingModeRequest)) {
            return false;
        }
        SetPublishingModeRequest that = (SetPublishingModeRequest)o;
        return this.getRequestHeader() == that.getRequestHeader() && this.getPublishingEnabled() == that.getPublishingEnabled() && this.getNoOfSubscriptionIds() == that.getNoOfSubscriptionIds() && this.getSubscriptionIds() == that.getSubscriptionIds() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getRequestHeader(), this.getPublishingEnabled(), this.getNoOfSubscriptionIds(), this.getSubscriptionIds());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class SetPublishingModeRequestBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final ExtensionObjectDefinition requestHeader;
        private final boolean publishingEnabled;
        private final int noOfSubscriptionIds;
        private final List<Long> subscriptionIds;

        public SetPublishingModeRequestBuilderImpl(ExtensionObjectDefinition requestHeader, boolean publishingEnabled, int noOfSubscriptionIds, List<Long> subscriptionIds) {
            this.requestHeader = requestHeader;
            this.publishingEnabled = publishingEnabled;
            this.noOfSubscriptionIds = noOfSubscriptionIds;
            this.subscriptionIds = subscriptionIds;
        }

        @Override
        public SetPublishingModeRequest build() {
            SetPublishingModeRequest setPublishingModeRequest = new SetPublishingModeRequest(this.requestHeader, this.publishingEnabled, this.noOfSubscriptionIds, this.subscriptionIds);
            return setPublishingModeRequest;
        }
    }
}

