/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class SetTriggeringRequest
extends ExtensionObjectDefinition
implements Message {
    protected final ExtensionObjectDefinition requestHeader;
    protected final long subscriptionId;
    protected final long triggeringItemId;
    protected final int noOfLinksToAdd;
    protected final List<Long> linksToAdd;
    protected final int noOfLinksToRemove;
    protected final List<Long> linksToRemove;

    @Override
    public String getIdentifier() {
        return "775";
    }

    public SetTriggeringRequest(ExtensionObjectDefinition requestHeader, long subscriptionId, long triggeringItemId, int noOfLinksToAdd, List<Long> linksToAdd, int noOfLinksToRemove, List<Long> linksToRemove) {
        this.requestHeader = requestHeader;
        this.subscriptionId = subscriptionId;
        this.triggeringItemId = triggeringItemId;
        this.noOfLinksToAdd = noOfLinksToAdd;
        this.linksToAdd = linksToAdd;
        this.noOfLinksToRemove = noOfLinksToRemove;
        this.linksToRemove = linksToRemove;
    }

    public ExtensionObjectDefinition getRequestHeader() {
        return this.requestHeader;
    }

    public long getSubscriptionId() {
        return this.subscriptionId;
    }

    public long getTriggeringItemId() {
        return this.triggeringItemId;
    }

    public int getNoOfLinksToAdd() {
        return this.noOfLinksToAdd;
    }

    public List<Long> getLinksToAdd() {
        return this.linksToAdd;
    }

    public int getNoOfLinksToRemove() {
        return this.noOfLinksToRemove;
    }

    public List<Long> getLinksToRemove() {
        return this.linksToRemove;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("SetTriggeringRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("requestHeader", this.requestHeader, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("subscriptionId", this.subscriptionId, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("triggeringItemId", this.triggeringItemId, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("noOfLinksToAdd", this.noOfLinksToAdd, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleTypeArrayField("linksToAdd", this.linksToAdd, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("noOfLinksToRemove", this.noOfLinksToRemove, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleTypeArrayField("linksToRemove", this.linksToRemove, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        writeBuffer.popContext("SetTriggeringRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        SetTriggeringRequest _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.requestHeader.getLengthInBits();
        lengthInBits += 32;
        lengthInBits += 32;
        lengthInBits += 32;
        if (this.linksToAdd != null) {
            lengthInBits += 32 * this.linksToAdd.size();
        }
        lengthInBits += 32;
        if (this.linksToRemove != null) {
            lengthInBits += 32 * this.linksToRemove.size();
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("SetTriggeringRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        ExtensionObjectDefinition requestHeader = FieldReaderFactory.readSimpleField("requestHeader", new DataReaderComplexDefault<ExtensionObjectDefinition>(() -> ExtensionObjectDefinition.staticParse(readBuffer, "391"), readBuffer), new WithReaderArgs[0]);
        long subscriptionId = FieldReaderFactory.readSimpleField("subscriptionId", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
        long triggeringItemId = FieldReaderFactory.readSimpleField("triggeringItemId", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
        int noOfLinksToAdd = FieldReaderFactory.readSimpleField("noOfLinksToAdd", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        List<Long> linksToAdd = FieldReaderFactory.readCountArrayField("linksToAdd", DataReaderFactory.readUnsignedLong(readBuffer, 32), noOfLinksToAdd, new WithReaderArgs[0]);
        int noOfLinksToRemove = FieldReaderFactory.readSimpleField("noOfLinksToRemove", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        List<Long> linksToRemove = FieldReaderFactory.readCountArrayField("linksToRemove", DataReaderFactory.readUnsignedLong(readBuffer, 32), noOfLinksToRemove, new WithReaderArgs[0]);
        readBuffer.closeContext("SetTriggeringRequest", new WithReaderArgs[0]);
        return new SetTriggeringRequestBuilderImpl(requestHeader, subscriptionId, triggeringItemId, noOfLinksToAdd, linksToAdd, noOfLinksToRemove, linksToRemove);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SetTriggeringRequest)) {
            return false;
        }
        SetTriggeringRequest that = (SetTriggeringRequest)o;
        return this.getRequestHeader() == that.getRequestHeader() && this.getSubscriptionId() == that.getSubscriptionId() && this.getTriggeringItemId() == that.getTriggeringItemId() && this.getNoOfLinksToAdd() == that.getNoOfLinksToAdd() && this.getLinksToAdd() == that.getLinksToAdd() && this.getNoOfLinksToRemove() == that.getNoOfLinksToRemove() && this.getLinksToRemove() == that.getLinksToRemove() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getRequestHeader(), this.getSubscriptionId(), this.getTriggeringItemId(), this.getNoOfLinksToAdd(), this.getLinksToAdd(), this.getNoOfLinksToRemove(), this.getLinksToRemove());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class SetTriggeringRequestBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final ExtensionObjectDefinition requestHeader;
        private final long subscriptionId;
        private final long triggeringItemId;
        private final int noOfLinksToAdd;
        private final List<Long> linksToAdd;
        private final int noOfLinksToRemove;
        private final List<Long> linksToRemove;

        public SetTriggeringRequestBuilderImpl(ExtensionObjectDefinition requestHeader, long subscriptionId, long triggeringItemId, int noOfLinksToAdd, List<Long> linksToAdd, int noOfLinksToRemove, List<Long> linksToRemove) {
            this.requestHeader = requestHeader;
            this.subscriptionId = subscriptionId;
            this.triggeringItemId = triggeringItemId;
            this.noOfLinksToAdd = noOfLinksToAdd;
            this.linksToAdd = linksToAdd;
            this.noOfLinksToRemove = noOfLinksToRemove;
            this.linksToRemove = linksToRemove;
        }

        @Override
        public SetTriggeringRequest build() {
            SetTriggeringRequest setTriggeringRequest = new SetTriggeringRequest(this.requestHeader, this.subscriptionId, this.triggeringItemId, this.noOfLinksToAdd, this.linksToAdd, this.noOfLinksToRemove, this.linksToRemove);
            return setTriggeringRequest;
        }
    }
}

