/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class TranslateBrowsePathsToNodeIdsRequest
extends ExtensionObjectDefinition
implements Message {
    protected final ExtensionObjectDefinition requestHeader;
    protected final int noOfBrowsePaths;
    protected final List<ExtensionObjectDefinition> browsePaths;

    @Override
    public String getIdentifier() {
        return "554";
    }

    public TranslateBrowsePathsToNodeIdsRequest(ExtensionObjectDefinition requestHeader, int noOfBrowsePaths, List<ExtensionObjectDefinition> browsePaths) {
        this.requestHeader = requestHeader;
        this.noOfBrowsePaths = noOfBrowsePaths;
        this.browsePaths = browsePaths;
    }

    public ExtensionObjectDefinition getRequestHeader() {
        return this.requestHeader;
    }

    public int getNoOfBrowsePaths() {
        return this.noOfBrowsePaths;
    }

    public List<ExtensionObjectDefinition> getBrowsePaths() {
        return this.browsePaths;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("TranslateBrowsePathsToNodeIdsRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("requestHeader", this.requestHeader, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("noOfBrowsePaths", this.noOfBrowsePaths, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField("browsePaths", this.browsePaths, writeBuffer, new WithWriterArgs[0]);
        writeBuffer.popContext("TranslateBrowsePathsToNodeIdsRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        TranslateBrowsePathsToNodeIdsRequest _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.requestHeader.getLengthInBits();
        lengthInBits += 32;
        if (this.browsePaths != null) {
            int i = 0;
            for (ExtensionObjectDefinition element : this.browsePaths) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.browsePaths.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("TranslateBrowsePathsToNodeIdsRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        ExtensionObjectDefinition requestHeader = FieldReaderFactory.readSimpleField("requestHeader", new DataReaderComplexDefault<ExtensionObjectDefinition>(() -> ExtensionObjectDefinition.staticParse(readBuffer, "391"), readBuffer), new WithReaderArgs[0]);
        int noOfBrowsePaths = FieldReaderFactory.readSimpleField("noOfBrowsePaths", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        List<ExtensionObjectDefinition> browsePaths = FieldReaderFactory.readCountArrayField("browsePaths", new DataReaderComplexDefault<ExtensionObjectDefinition>(() -> ExtensionObjectDefinition.staticParse(readBuffer, "545"), readBuffer), noOfBrowsePaths, new WithReaderArgs[0]);
        readBuffer.closeContext("TranslateBrowsePathsToNodeIdsRequest", new WithReaderArgs[0]);
        return new TranslateBrowsePathsToNodeIdsRequestBuilderImpl(requestHeader, noOfBrowsePaths, browsePaths);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TranslateBrowsePathsToNodeIdsRequest)) {
            return false;
        }
        TranslateBrowsePathsToNodeIdsRequest that = (TranslateBrowsePathsToNodeIdsRequest)o;
        return this.getRequestHeader() == that.getRequestHeader() && this.getNoOfBrowsePaths() == that.getNoOfBrowsePaths() && this.getBrowsePaths() == that.getBrowsePaths() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getRequestHeader(), this.getNoOfBrowsePaths(), this.getBrowsePaths());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class TranslateBrowsePathsToNodeIdsRequestBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final ExtensionObjectDefinition requestHeader;
        private final int noOfBrowsePaths;
        private final List<ExtensionObjectDefinition> browsePaths;

        public TranslateBrowsePathsToNodeIdsRequestBuilderImpl(ExtensionObjectDefinition requestHeader, int noOfBrowsePaths, List<ExtensionObjectDefinition> browsePaths) {
            this.requestHeader = requestHeader;
            this.noOfBrowsePaths = noOfBrowsePaths;
            this.browsePaths = browsePaths;
        }

        @Override
        public TranslateBrowsePathsToNodeIdsRequest build() {
            TranslateBrowsePathsToNodeIdsRequest translateBrowsePathsToNodeIdsRequest = new TranslateBrowsePathsToNodeIdsRequest(this.requestHeader, this.noOfBrowsePaths, this.browsePaths);
            return translateBrowsePathsToNodeIdsRequest;
        }
    }
}

