/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.PascalByteString;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.opcua.readwrite.UserIdentityTokenDefinition;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class UserNameIdentityToken
extends UserIdentityTokenDefinition
implements Message {
    protected final PascalString userName;
    protected final PascalByteString password;
    protected final PascalString encryptionAlgorithm;

    @Override
    public String getIdentifier() {
        return "username";
    }

    public UserNameIdentityToken(PascalString userName, PascalByteString password, PascalString encryptionAlgorithm) {
        this.userName = userName;
        this.password = password;
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    public PascalString getUserName() {
        return this.userName;
    }

    public PascalByteString getPassword() {
        return this.password;
    }

    public PascalString getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    @Override
    protected void serializeUserIdentityTokenDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("UserNameIdentityToken", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("userName", this.userName, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("password", this.password, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("encryptionAlgorithm", this.encryptionAlgorithm, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        writeBuffer.popContext("UserNameIdentityToken", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        UserNameIdentityToken _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.userName.getLengthInBits();
        lengthInBits += this.password.getLengthInBits();
        return lengthInBits += this.encryptionAlgorithm.getLengthInBits();
    }

    public static UserIdentityTokenDefinition.UserIdentityTokenDefinitionBuilder staticParseUserIdentityTokenDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("UserNameIdentityToken", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        PascalString userName = FieldReaderFactory.readSimpleField("userName", new DataReaderComplexDefault<PascalString>(() -> PascalString.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        PascalByteString password = FieldReaderFactory.readSimpleField("password", new DataReaderComplexDefault<PascalByteString>(() -> PascalByteString.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        PascalString encryptionAlgorithm = FieldReaderFactory.readSimpleField("encryptionAlgorithm", new DataReaderComplexDefault<PascalString>(() -> PascalString.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        readBuffer.closeContext("UserNameIdentityToken", new WithReaderArgs[0]);
        return new UserNameIdentityTokenBuilderImpl(userName, password, encryptionAlgorithm);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserNameIdentityToken)) {
            return false;
        }
        UserNameIdentityToken that = (UserNameIdentityToken)o;
        return this.getUserName() == that.getUserName() && this.getPassword() == that.getPassword() && this.getEncryptionAlgorithm() == that.getEncryptionAlgorithm() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getUserName(), this.getPassword(), this.getEncryptionAlgorithm());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class UserNameIdentityTokenBuilderImpl
    implements UserIdentityTokenDefinition.UserIdentityTokenDefinitionBuilder {
        private final PascalString userName;
        private final PascalByteString password;
        private final PascalString encryptionAlgorithm;

        public UserNameIdentityTokenBuilderImpl(PascalString userName, PascalByteString password, PascalString encryptionAlgorithm) {
            this.userName = userName;
            this.password = password;
            this.encryptionAlgorithm = encryptionAlgorithm;
        }

        @Override
        public UserNameIdentityToken build() {
            UserNameIdentityToken userNameIdentityToken = new UserNameIdentityToken(this.userName, this.password, this.encryptionAlgorithm);
            return userNameIdentityToken;
        }
    }
}

