/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.Variant;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class VariantUInt32
extends Variant
implements Message {
    protected final Integer arrayLength;
    protected final List<Long> value;

    @Override
    public Byte getVariantType() {
        return (byte)7;
    }

    public VariantUInt32(boolean arrayLengthSpecified, boolean arrayDimensionsSpecified, Integer noOfArrayDimensions, List<Boolean> arrayDimensions, Integer arrayLength, List<Long> value) {
        super(arrayLengthSpecified, arrayDimensionsSpecified, noOfArrayDimensions, arrayDimensions);
        this.arrayLength = arrayLength;
        this.value = value;
    }

    public Integer getArrayLength() {
        return this.arrayLength;
    }

    public List<Long> getValue() {
        return this.value;
    }

    @Override
    protected void serializeVariantChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("VariantUInt32", new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField("arrayLength", this.arrayLength, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleTypeArrayField("value", this.value, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        writeBuffer.popContext("VariantUInt32", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        VariantUInt32 _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        if (this.arrayLength != null) {
            lengthInBits += 32;
        }
        if (this.value != null) {
            lengthInBits += 32 * this.value.size();
        }
        return lengthInBits;
    }

    public static Variant.VariantBuilder staticParseVariantBuilder(ReadBuffer readBuffer, Boolean arrayLengthSpecified) throws ParseException {
        readBuffer.pullContext("VariantUInt32", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        Integer arrayLength = FieldReaderFactory.readOptionalField("arrayLength", DataReaderFactory.readSignedInt(readBuffer, 32), arrayLengthSpecified, new WithReaderArgs[0]);
        List<Long> value = FieldReaderFactory.readCountArrayField("value", DataReaderFactory.readUnsignedLong(readBuffer, 32), arrayLength == null ? 1 : arrayLength, new WithReaderArgs[0]);
        readBuffer.closeContext("VariantUInt32", new WithReaderArgs[0]);
        return new VariantUInt32BuilderImpl(arrayLength, value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VariantUInt32)) {
            return false;
        }
        VariantUInt32 that = (VariantUInt32)o;
        return this.getArrayLength() == that.getArrayLength() && this.getValue() == that.getValue() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getArrayLength(), this.getValue());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class VariantUInt32BuilderImpl
    implements Variant.VariantBuilder {
        private final Integer arrayLength;
        private final List<Long> value;

        public VariantUInt32BuilderImpl(Integer arrayLength, List<Long> value) {
            this.arrayLength = arrayLength;
            this.value = value;
        }

        @Override
        public VariantUInt32 build(boolean arrayLengthSpecified, boolean arrayDimensionsSpecified, Integer noOfArrayDimensions, List<Boolean> arrayDimensions) {
            VariantUInt32 variantUInt32 = new VariantUInt32(arrayLengthSpecified, arrayDimensionsSpecified, noOfArrayDimensions, arrayDimensions, this.arrayLength, this.value);
            return variantUInt32;
        }
    }
}

