/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.Variant;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class VariantVariant
extends Variant
implements Message {
    protected final Integer arrayLength;
    protected final List<Variant> value;

    @Override
    public Byte getVariantType() {
        return (byte)24;
    }

    public VariantVariant(boolean arrayLengthSpecified, boolean arrayDimensionsSpecified, Integer noOfArrayDimensions, List<Boolean> arrayDimensions, Integer arrayLength, List<Variant> value) {
        super(arrayLengthSpecified, arrayDimensionsSpecified, noOfArrayDimensions, arrayDimensions);
        this.arrayLength = arrayLength;
        this.value = value;
    }

    public Integer getArrayLength() {
        return this.arrayLength;
    }

    public List<Variant> getValue() {
        return this.value;
    }

    @Override
    protected void serializeVariantChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("VariantVariant", new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField("arrayLength", this.arrayLength, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField("value", this.value, writeBuffer, new WithWriterArgs[0]);
        writeBuffer.popContext("VariantVariant", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        VariantVariant _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        if (this.arrayLength != null) {
            lengthInBits += 32;
        }
        if (this.value != null) {
            int i = 0;
            for (Variant element : this.value) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.value.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static Variant.VariantBuilder staticParseVariantBuilder(ReadBuffer readBuffer, Boolean arrayLengthSpecified) throws ParseException {
        readBuffer.pullContext("VariantVariant", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        Integer arrayLength = FieldReaderFactory.readOptionalField("arrayLength", DataReaderFactory.readSignedInt(readBuffer, 32), arrayLengthSpecified, new WithReaderArgs[0]);
        List<Variant> value = FieldReaderFactory.readCountArrayField("value", new DataReaderComplexDefault<Variant>(() -> Variant.staticParse(readBuffer), readBuffer), arrayLength == null ? 1 : arrayLength, new WithReaderArgs[0]);
        readBuffer.closeContext("VariantVariant", new WithReaderArgs[0]);
        return new VariantVariantBuilderImpl(arrayLength, value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VariantVariant)) {
            return false;
        }
        VariantVariant that = (VariantVariant)o;
        return this.getArrayLength() == that.getArrayLength() && this.getValue() == that.getValue() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getArrayLength(), this.getValue());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class VariantVariantBuilderImpl
    implements Variant.VariantBuilder {
        private final Integer arrayLength;
        private final List<Variant> value;

        public VariantVariantBuilderImpl(Integer arrayLength, List<Variant> value) {
            this.arrayLength = arrayLength;
            this.value = value;
        }

        @Override
        public VariantVariant build(boolean arrayLengthSpecified, boolean arrayDimensionsSpecified, Integer noOfArrayDimensions, List<Boolean> arrayDimensions) {
            VariantVariant variantVariant = new VariantVariant(arrayLengthSpecified, arrayDimensionsSpecified, noOfArrayDimensions, arrayDimensions, this.arrayLength, this.value);
            return variantVariant;
        }
    }
}

