/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class WriteRequest
extends ExtensionObjectDefinition
implements Message {
    protected final ExtensionObjectDefinition requestHeader;
    protected final int noOfNodesToWrite;
    protected final List<ExtensionObjectDefinition> nodesToWrite;

    @Override
    public String getIdentifier() {
        return "673";
    }

    public WriteRequest(ExtensionObjectDefinition requestHeader, int noOfNodesToWrite, List<ExtensionObjectDefinition> nodesToWrite) {
        this.requestHeader = requestHeader;
        this.noOfNodesToWrite = noOfNodesToWrite;
        this.nodesToWrite = nodesToWrite;
    }

    public ExtensionObjectDefinition getRequestHeader() {
        return this.requestHeader;
    }

    public int getNoOfNodesToWrite() {
        return this.noOfNodesToWrite;
    }

    public List<ExtensionObjectDefinition> getNodesToWrite() {
        return this.nodesToWrite;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("WriteRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("requestHeader", this.requestHeader, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("noOfNodesToWrite", this.noOfNodesToWrite, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField("nodesToWrite", this.nodesToWrite, writeBuffer, new WithWriterArgs[0]);
        writeBuffer.popContext("WriteRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        WriteRequest _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.requestHeader.getLengthInBits();
        lengthInBits += 32;
        if (this.nodesToWrite != null) {
            int i = 0;
            for (ExtensionObjectDefinition element : this.nodesToWrite) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.nodesToWrite.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("WriteRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        ExtensionObjectDefinition requestHeader = FieldReaderFactory.readSimpleField("requestHeader", new DataReaderComplexDefault<ExtensionObjectDefinition>(() -> ExtensionObjectDefinition.staticParse(readBuffer, "391"), readBuffer), new WithReaderArgs[0]);
        int noOfNodesToWrite = FieldReaderFactory.readSimpleField("noOfNodesToWrite", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        List<ExtensionObjectDefinition> nodesToWrite = FieldReaderFactory.readCountArrayField("nodesToWrite", new DataReaderComplexDefault<ExtensionObjectDefinition>(() -> ExtensionObjectDefinition.staticParse(readBuffer, "670"), readBuffer), noOfNodesToWrite, new WithReaderArgs[0]);
        readBuffer.closeContext("WriteRequest", new WithReaderArgs[0]);
        return new WriteRequestBuilderImpl(requestHeader, noOfNodesToWrite, nodesToWrite);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WriteRequest)) {
            return false;
        }
        WriteRequest that = (WriteRequest)o;
        return this.getRequestHeader() == that.getRequestHeader() && this.getNoOfNodesToWrite() == that.getNoOfNodesToWrite() && this.getNodesToWrite() == that.getNodesToWrite() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getRequestHeader(), this.getNoOfNodesToWrite(), this.getNodesToWrite());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class WriteRequestBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final ExtensionObjectDefinition requestHeader;
        private final int noOfNodesToWrite;
        private final List<ExtensionObjectDefinition> nodesToWrite;

        public WriteRequestBuilderImpl(ExtensionObjectDefinition requestHeader, int noOfNodesToWrite, List<ExtensionObjectDefinition> nodesToWrite) {
            this.requestHeader = requestHeader;
            this.noOfNodesToWrite = noOfNodesToWrite;
            this.nodesToWrite = nodesToWrite;
        }

        @Override
        public WriteRequest build() {
            WriteRequest writeRequest = new WriteRequest(this.requestHeader, this.noOfNodesToWrite, this.nodesToWrite);
            return writeRequest;
        }
    }
}

