/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.DataValue;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.NodeId;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class WriteValue
extends ExtensionObjectDefinition
implements Message {
    protected final NodeId nodeId;
    protected final long attributeId;
    protected final PascalString indexRange;
    protected final DataValue value;

    @Override
    public String getIdentifier() {
        return "670";
    }

    public WriteValue(NodeId nodeId, long attributeId, PascalString indexRange, DataValue value) {
        this.nodeId = nodeId;
        this.attributeId = attributeId;
        this.indexRange = indexRange;
        this.value = value;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public long getAttributeId() {
        return this.attributeId;
    }

    public PascalString getIndexRange() {
        return this.indexRange;
    }

    public DataValue getValue() {
        return this.value;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("WriteValue", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("nodeId", this.nodeId, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("attributeId", this.attributeId, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("indexRange", this.indexRange, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("value", this.value, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        writeBuffer.popContext("WriteValue", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        WriteValue _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.nodeId.getLengthInBits();
        lengthInBits += 32;
        lengthInBits += this.indexRange.getLengthInBits();
        return lengthInBits += this.value.getLengthInBits();
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("WriteValue", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        NodeId nodeId = FieldReaderFactory.readSimpleField("nodeId", new DataReaderComplexDefault<NodeId>(() -> NodeId.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        long attributeId = FieldReaderFactory.readSimpleField("attributeId", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
        PascalString indexRange = FieldReaderFactory.readSimpleField("indexRange", new DataReaderComplexDefault<PascalString>(() -> PascalString.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        DataValue value = FieldReaderFactory.readSimpleField("value", new DataReaderComplexDefault<DataValue>(() -> DataValue.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        readBuffer.closeContext("WriteValue", new WithReaderArgs[0]);
        return new WriteValueBuilderImpl(nodeId, attributeId, indexRange, value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WriteValue)) {
            return false;
        }
        WriteValue that = (WriteValue)o;
        return this.getNodeId() == that.getNodeId() && this.getAttributeId() == that.getAttributeId() && this.getIndexRange() == that.getIndexRange() && this.getValue() == that.getValue() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getNodeId(), this.getAttributeId(), this.getIndexRange(), this.getValue());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class WriteValueBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final NodeId nodeId;
        private final long attributeId;
        private final PascalString indexRange;
        private final DataValue value;

        public WriteValueBuilderImpl(NodeId nodeId, long attributeId, PascalString indexRange, DataValue value) {
            this.nodeId = nodeId;
            this.attributeId = attributeId;
            this.indexRange = indexRange;
            this.value = value;
        }

        @Override
        public WriteValue build() {
            WriteValue writeValue = new WriteValue(this.nodeId, this.attributeId, this.indexRange, this.value);
            return writeValue;
        }
    }
}

