/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.PascalByteString;
import org.apache.plc4x.java.opcua.readwrite.UserIdentityTokenDefinition;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class X509IdentityToken
extends UserIdentityTokenDefinition
implements Message {
    protected final PascalByteString certificateData;

    @Override
    public String getIdentifier() {
        return "certificate";
    }

    public X509IdentityToken(PascalByteString certificateData) {
        this.certificateData = certificateData;
    }

    public PascalByteString getCertificateData() {
        return this.certificateData;
    }

    @Override
    protected void serializeUserIdentityTokenDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("X509IdentityToken", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("certificateData", this.certificateData, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        writeBuffer.popContext("X509IdentityToken", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        X509IdentityToken _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        return lengthInBits += this.certificateData.getLengthInBits();
    }

    public static UserIdentityTokenDefinition.UserIdentityTokenDefinitionBuilder staticParseUserIdentityTokenDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("X509IdentityToken", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        PascalByteString certificateData = FieldReaderFactory.readSimpleField("certificateData", new DataReaderComplexDefault<PascalByteString>(() -> PascalByteString.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        readBuffer.closeContext("X509IdentityToken", new WithReaderArgs[0]);
        return new X509IdentityTokenBuilderImpl(certificateData);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof X509IdentityToken)) {
            return false;
        }
        X509IdentityToken that = (X509IdentityToken)o;
        return this.getCertificateData() == that.getCertificateData() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getCertificateData());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class X509IdentityTokenBuilderImpl
    implements UserIdentityTokenDefinition.UserIdentityTokenDefinitionBuilder {
        private final PascalByteString certificateData;

        public X509IdentityTokenBuilderImpl(PascalByteString certificateData) {
            this.certificateData = certificateData;
        }

        @Override
        public X509IdentityToken build() {
            X509IdentityToken x509IdentityToken = new X509IdentityToken(this.certificateData);
            return x509IdentityToken;
        }
    }
}

