/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class XmlElement
implements Message {
    protected final int length;
    protected final List<String> value;

    public XmlElement(int length, List<String> value) {
        this.length = length;
        this.value = value;
    }

    public int getLength() {
        return this.length;
    }

    public List<String> getValue() {
        return this.value;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("XmlElement", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("length", this.length, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleTypeArrayField("value", this.value, DataWriterFactory.writeString(writeBuffer, 8), new WithWriterArgs[0]);
        writeBuffer.popContext("XmlElement", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = 0;
        XmlElement _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        if (this.value != null) {
            lengthInBits += 8 * this.value.size();
        }
        return lengthInBits;
    }

    public static XmlElement staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return XmlElement.staticParse(readBuffer);
    }

    public static XmlElement staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("XmlElement", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        int length = FieldReaderFactory.readSimpleField("length", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        List<String> value = FieldReaderFactory.readCountArrayField("value", DataReaderFactory.readString(readBuffer, 8), length, new WithReaderArgs[0]);
        readBuffer.closeContext("XmlElement", new WithReaderArgs[0]);
        XmlElement _xmlElement = new XmlElement(length, value);
        return _xmlElement;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof XmlElement)) {
            return false;
        }
        XmlElement that = (XmlElement)o;
        return this.getLength() == that.getLength() && this.getValue() == that.getValue();
    }

    public int hashCode() {
        return Objects.hash(this.getLength(), this.getValue());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

