/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.s7.readwrite.COTPPacketConnectionRequest;
import org.apache.plc4x.java.s7.readwrite.COTPPacketConnectionResponse;
import org.apache.plc4x.java.s7.readwrite.COTPPacketData;
import org.apache.plc4x.java.s7.readwrite.COTPPacketDisconnectRequest;
import org.apache.plc4x.java.s7.readwrite.COTPPacketDisconnectResponse;
import org.apache.plc4x.java.s7.readwrite.COTPPacketTpduError;
import org.apache.plc4x.java.s7.readwrite.COTPParameter;
import org.apache.plc4x.java.s7.readwrite.S7Message;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public abstract class COTPPacket
implements Message {
    protected final List<COTPParameter> parameters;
    protected final S7Message payload;

    public abstract Short getTpduCode();

    public COTPPacket(List<COTPParameter> parameters, S7Message payload) {
        this.parameters = parameters;
        this.payload = payload;
    }

    public List<COTPParameter> getParameters() {
        return this.parameters;
    }

    public S7Message getPayload() {
        return this.payload;
    }

    protected abstract void serializeCOTPPacketChild(WriteBuffer var1) throws SerializationException;

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("COTPPacket", new WithWriterArgs[0]);
        short headerLength = (short)(this.getLengthInBytes() - ((this.getPayload() != null ? this.getPayload().getLengthInBytes() : 0) + 1));
        FieldWriterFactory.writeImplicitField("headerLength", headerLength, DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
        FieldWriterFactory.writeDiscriminatorField("tpduCode", this.getTpduCode(), DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
        this.serializeCOTPPacketChild(writeBuffer);
        FieldWriterFactory.writeComplexTypeArrayField("parameters", this.parameters, writeBuffer, new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField("payload", this.payload, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        writeBuffer.popContext("COTPPacket", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = 0;
        COTPPacket _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 8;
        lengthInBits += 8;
        if (this.parameters != null) {
            for (Message message : this.parameters) {
                lengthInBits += message.getLengthInBits();
            }
        }
        if (this.payload != null) {
            lengthInBits += this.payload.getLengthInBits();
        }
        return lengthInBits;
    }

    public static COTPPacket staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        Integer cotpLen;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 1) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 1, but got " + args.length);
        }
        if (args[0] instanceof Integer) {
            cotpLen = (Integer)args[0];
        } else if (args[0] instanceof String) {
            cotpLen = Integer.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type Integer or a string which is parseable but was " + args[0].getClass().getName());
        }
        return COTPPacket.staticParse(readBuffer, cotpLen);
    }

    public static COTPPacket staticParse(ReadBuffer readBuffer, Integer cotpLen) throws ParseException {
        readBuffer.pullContext("COTPPacket", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        short headerLength = FieldReaderFactory.readImplicitField("headerLength", DataReaderFactory.readUnsignedShort(readBuffer, 8), new WithReaderArgs[0]);
        short tpduCode = FieldReaderFactory.readDiscriminatorField("tpduCode", DataReaderFactory.readUnsignedShort(readBuffer, 8), new WithReaderArgs[0]);
        COTPPacketBuilder builder = null;
        if (EvaluationHelper.equals(tpduCode, (short)240)) {
            builder = COTPPacketData.staticParseCOTPPacketBuilder(readBuffer, cotpLen);
        } else if (EvaluationHelper.equals(tpduCode, (short)224)) {
            builder = COTPPacketConnectionRequest.staticParseCOTPPacketBuilder(readBuffer, cotpLen);
        } else if (EvaluationHelper.equals(tpduCode, (short)208)) {
            builder = COTPPacketConnectionResponse.staticParseCOTPPacketBuilder(readBuffer, cotpLen);
        } else if (EvaluationHelper.equals(tpduCode, (short)128)) {
            builder = COTPPacketDisconnectRequest.staticParseCOTPPacketBuilder(readBuffer, cotpLen);
        } else if (EvaluationHelper.equals(tpduCode, (short)192)) {
            builder = COTPPacketDisconnectResponse.staticParseCOTPPacketBuilder(readBuffer, cotpLen);
        } else if (EvaluationHelper.equals(tpduCode, (short)112)) {
            builder = COTPPacketTpduError.staticParseCOTPPacketBuilder(readBuffer, cotpLen);
        }
        if (builder == null) {
            throw new ParseException("Unsupported case for discriminated type parameters [tpduCode=" + tpduCode + "]");
        }
        List<COTPParameter> parameters = FieldReaderFactory.readLengthArrayField("parameters", new DataReaderComplexDefault<COTPParameter>(() -> COTPParameter.staticParse(readBuffer, (short)(headerLength + 1 - (positionAware.getPos() - startPos))), readBuffer), headerLength + 1 - (positionAware.getPos() - startPos), new WithReaderArgs[0]);
        S7Message payload = FieldReaderFactory.readOptionalField("payload", new DataReaderComplexDefault<S7Message>(() -> S7Message.staticParse(readBuffer), readBuffer), positionAware.getPos() - startPos < cotpLen, new WithReaderArgs[0]);
        readBuffer.closeContext("COTPPacket", new WithReaderArgs[0]);
        COTPPacket _cOTPPacket = builder.build(parameters, payload);
        return _cOTPPacket;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof COTPPacket)) {
            return false;
        }
        COTPPacket that = (COTPPacket)o;
        return this.getParameters() == that.getParameters() && this.getPayload() == that.getPayload();
    }

    public int hashCode() {
        return Objects.hash(this.getParameters(), this.getPayload());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static interface COTPPacketBuilder {
        public COTPPacket build(List<COTPParameter> var1, S7Message var2);
    }
}

