/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.s7.readwrite.COTPPacket;
import org.apache.plc4x.java.s7.readwrite.COTPParameter;
import org.apache.plc4x.java.s7.readwrite.COTPProtocolClass;
import org.apache.plc4x.java.s7.readwrite.S7Message;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class COTPPacketDisconnectRequest
extends COTPPacket
implements Message {
    protected final int destinationReference;
    protected final int sourceReference;
    protected final COTPProtocolClass protocolClass;

    @Override
    public Short getTpduCode() {
        return (short)128;
    }

    public COTPPacketDisconnectRequest(List<COTPParameter> parameters, S7Message payload, int destinationReference, int sourceReference, COTPProtocolClass protocolClass) {
        super(parameters, payload);
        this.destinationReference = destinationReference;
        this.sourceReference = sourceReference;
        this.protocolClass = protocolClass;
    }

    public int getDestinationReference() {
        return this.destinationReference;
    }

    public int getSourceReference() {
        return this.sourceReference;
    }

    public COTPProtocolClass getProtocolClass() {
        return this.protocolClass;
    }

    @Override
    protected void serializeCOTPPacketChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("COTPPacketDisconnectRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("destinationReference", this.destinationReference, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("sourceReference", this.sourceReference, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField("protocolClass", "COTPProtocolClass", this.protocolClass, new DataWriterEnumDefault<COTPProtocolClass, Short>(COTPProtocolClass::getValue, Enum::name, DataWriterFactory.writeUnsignedShort(writeBuffer, 8)), new WithWriterArgs[0]);
        writeBuffer.popContext("COTPPacketDisconnectRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        COTPPacketDisconnectRequest _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 16;
        lengthInBits += 16;
        return lengthInBits += 8;
    }

    public static COTPPacket.COTPPacketBuilder staticParseCOTPPacketBuilder(ReadBuffer readBuffer, Integer cotpLen) throws ParseException {
        readBuffer.pullContext("COTPPacketDisconnectRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        int destinationReference = FieldReaderFactory.readSimpleField("destinationReference", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
        int sourceReference = FieldReaderFactory.readSimpleField("sourceReference", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
        COTPProtocolClass protocolClass = (COTPProtocolClass)((Object)FieldReaderFactory.readEnumField("protocolClass", "COTPProtocolClass", new DataReaderEnumDefault<COTPProtocolClass, Short>(COTPProtocolClass::enumForValue, DataReaderFactory.readUnsignedShort(readBuffer, 8)), new WithReaderArgs[0]));
        readBuffer.closeContext("COTPPacketDisconnectRequest", new WithReaderArgs[0]);
        return new COTPPacketDisconnectRequestBuilderImpl(destinationReference, sourceReference, protocolClass);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof COTPPacketDisconnectRequest)) {
            return false;
        }
        COTPPacketDisconnectRequest that = (COTPPacketDisconnectRequest)o;
        return this.getDestinationReference() == that.getDestinationReference() && this.getSourceReference() == that.getSourceReference() && this.getProtocolClass() == that.getProtocolClass() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getDestinationReference(), this.getSourceReference(), this.getProtocolClass()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class COTPPacketDisconnectRequestBuilderImpl
    implements COTPPacket.COTPPacketBuilder {
        private final int destinationReference;
        private final int sourceReference;
        private final COTPProtocolClass protocolClass;

        public COTPPacketDisconnectRequestBuilderImpl(int destinationReference, int sourceReference, COTPProtocolClass protocolClass) {
            this.destinationReference = destinationReference;
            this.sourceReference = sourceReference;
            this.protocolClass = protocolClass;
        }

        @Override
        public COTPPacketDisconnectRequest build(List<COTPParameter> parameters, S7Message payload) {
            COTPPacketDisconnectRequest cOTPPacketDisconnectRequest = new COTPPacketDisconnectRequest(parameters, payload, this.destinationReference, this.sourceReference, this.protocolClass);
            return cOTPPacketDisconnectRequest;
        }
    }
}

