/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite;

import java.math.BigInteger;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.s7.readwrite.ControllerType;
import org.apache.plc4x.java.s7.readwrite.utils.StaticHelper;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcBOOL;
import org.apache.plc4x.java.spi.values.PlcBYTE;
import org.apache.plc4x.java.spi.values.PlcCHAR;
import org.apache.plc4x.java.spi.values.PlcDATE;
import org.apache.plc4x.java.spi.values.PlcDATE_AND_LTIME;
import org.apache.plc4x.java.spi.values.PlcDATE_AND_TIME;
import org.apache.plc4x.java.spi.values.PlcDINT;
import org.apache.plc4x.java.spi.values.PlcDWORD;
import org.apache.plc4x.java.spi.values.PlcINT;
import org.apache.plc4x.java.spi.values.PlcLINT;
import org.apache.plc4x.java.spi.values.PlcLREAL;
import org.apache.plc4x.java.spi.values.PlcLTIME;
import org.apache.plc4x.java.spi.values.PlcLTIME_OF_DAY;
import org.apache.plc4x.java.spi.values.PlcLWORD;
import org.apache.plc4x.java.spi.values.PlcREAL;
import org.apache.plc4x.java.spi.values.PlcSINT;
import org.apache.plc4x.java.spi.values.PlcSTRING;
import org.apache.plc4x.java.spi.values.PlcTIME;
import org.apache.plc4x.java.spi.values.PlcTIME_OF_DAY;
import org.apache.plc4x.java.spi.values.PlcUDINT;
import org.apache.plc4x.java.spi.values.PlcUINT;
import org.apache.plc4x.java.spi.values.PlcULINT;
import org.apache.plc4x.java.spi.values.PlcUSINT;
import org.apache.plc4x.java.spi.values.PlcWORD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataItem.class);

    public static PlcValue staticParse(ReadBuffer readBuffer, String dataProtocolId, ControllerType controllerType, Integer stringLength) throws ParseException {
        if (EvaluationHelper.equals(dataProtocolId, "IEC61131_BOOL")) {
            Byte reservedField0 = FieldReaderFactory.readReservedField("reserved", DataReaderFactory.readUnsignedByte(readBuffer, 7), (byte)0, new WithReaderArgs[0]);
            boolean value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readBoolean(readBuffer), new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals(dataProtocolId, "IEC61131_BYTE")) {
            short value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedShort(readBuffer, 8), new WithReaderArgs[0]);
            return new PlcBYTE(value);
        }
        if (EvaluationHelper.equals(dataProtocolId, "IEC61131_WORD")) {
            int value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
            return new PlcWORD(value);
        }
        if (EvaluationHelper.equals(dataProtocolId, "IEC61131_DWORD")) {
            long value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
            return new PlcDWORD(value);
        }
        if (EvaluationHelper.equals(dataProtocolId, "IEC61131_LWORD")) {
            BigInteger value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedBigInteger(readBuffer, 64), new WithReaderArgs[0]);
            return new PlcLWORD(value);
        }
        if (EvaluationHelper.equals(dataProtocolId, "IEC61131_SINT")) {
            byte value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readSignedByte(readBuffer, 8), new WithReaderArgs[0]);
            return new PlcSINT(value);
        }
        if (EvaluationHelper.equals(dataProtocolId, "IEC61131_USINT")) {
            short value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedShort(readBuffer, 8), new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals(dataProtocolId, "IEC61131_INT")) {
            short value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readSignedShort(readBuffer, 16), new WithReaderArgs[0]);
            return new PlcINT(value);
        }
        if (EvaluationHelper.equals(dataProtocolId, "IEC61131_UINT")) {
            int value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
            return new PlcUINT(value);
        }
        if (EvaluationHelper.equals(dataProtocolId, "IEC61131_DINT")) {
            int value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals(dataProtocolId, "IEC61131_UDINT")) {
            long value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
            return new PlcUDINT(value);
        }
        if (EvaluationHelper.equals(dataProtocolId, "IEC61131_LINT")) {
            long value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readSignedLong(readBuffer, 64), new WithReaderArgs[0]);
            return new PlcLINT(value);
        }
        if (EvaluationHelper.equals(dataProtocolId, "IEC61131_ULINT")) {
            BigInteger value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedBigInteger(readBuffer, 64), new WithReaderArgs[0]);
            return new PlcULINT(value);
        }
        if (EvaluationHelper.equals(dataProtocolId, "IEC61131_REAL")) {
            float value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readFloat(readBuffer, 32), new WithReaderArgs[0]).floatValue();
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals(dataProtocolId, "IEC61131_LREAL")) {
            double value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readDouble(readBuffer, 64), new WithReaderArgs[0]);
            return new PlcLREAL(value);
        }
        if (EvaluationHelper.equals(dataProtocolId, "IEC61131_CHAR")) {
            String value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readString(readBuffer, 8), WithOption.WithEncoding("UTF-8"));
            return new PlcCHAR(value);
        }
        if (EvaluationHelper.equals(dataProtocolId, "IEC61131_WCHAR")) {
            String value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readString(readBuffer, 16), WithOption.WithEncoding("UTF-16"));
            return new PlcCHAR(value);
        }
        if (EvaluationHelper.equals(dataProtocolId, "IEC61131_STRING")) {
            String value = FieldReaderFactory.readManualField("value", readBuffer, () -> StaticHelper.parseS7String(readBuffer, stringLength, "UTF-8"), WithOption.WithEncoding("UTF-8"));
            return new PlcSTRING(value);
        }
        if (EvaluationHelper.equals(dataProtocolId, "IEC61131_WSTRING")) {
            String value = FieldReaderFactory.readManualField("value", readBuffer, () -> StaticHelper.parseS7String(readBuffer, stringLength, "UTF-16"), WithOption.WithEncoding("UTF-16"));
            return new PlcSTRING(value);
        }
        if (EvaluationHelper.equals(dataProtocolId, "IEC61131_TIME")) {
            long milliseconds = FieldReaderFactory.readSimpleField("milliseconds", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
            return PlcTIME.ofMilliseconds(milliseconds);
        }
        if (EvaluationHelper.equals(dataProtocolId, "S7_S5TIME")) {
            long milliseconds = FieldReaderFactory.readManualField("milliseconds", readBuffer, () -> (long)StaticHelper.parseS5Time(readBuffer), new WithReaderArgs[0]);
            return PlcTIME.ofMilliseconds(milliseconds);
        }
        if (EvaluationHelper.equals(dataProtocolId, "IEC61131_LTIME")) {
            BigInteger nanoseconds = FieldReaderFactory.readSimpleField("nanoseconds", DataReaderFactory.readUnsignedBigInteger(readBuffer, 64), new WithReaderArgs[0]);
            return PlcLTIME.ofNanoseconds(nanoseconds);
        }
        if (EvaluationHelper.equals(dataProtocolId, "IEC61131_DATE")) {
            int daysSinceEpoch = FieldReaderFactory.readManualField("daysSinceEpoch", readBuffer, () -> (int)StaticHelper.parseTiaDate(readBuffer), new WithReaderArgs[0]);
            return PlcDATE.ofDaysSinceEpoch(daysSinceEpoch);
        }
        if (EvaluationHelper.equals(dataProtocolId, "IEC61131_TIME_OF_DAY")) {
            long millisecondsSinceMidnight = FieldReaderFactory.readSimpleField("millisecondsSinceMidnight", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
            return PlcTIME_OF_DAY.ofMillisecondsSinceMidnight(millisecondsSinceMidnight);
        }
        if (EvaluationHelper.equals(dataProtocolId, "IEC61131_LTIME_OF_DAY")) {
            BigInteger nanosecondsSinceMidnight = FieldReaderFactory.readSimpleField("nanosecondsSinceMidnight", DataReaderFactory.readUnsignedBigInteger(readBuffer, 64), new WithReaderArgs[0]);
            return PlcLTIME_OF_DAY.ofNanosecondsSinceMidnight(nanosecondsSinceMidnight);
        }
        if (EvaluationHelper.equals(dataProtocolId, "IEC61131_DATE_AND_TIME")) {
            short year = FieldReaderFactory.readManualField("year", readBuffer, () -> StaticHelper.parseSiemensYear(readBuffer), WithOption.WithEncoding("BCD"));
            short month = FieldReaderFactory.readSimpleField("month", DataReaderFactory.readUnsignedShort(readBuffer, 8), WithOption.WithEncoding("BCD"));
            short day = FieldReaderFactory.readSimpleField("day", DataReaderFactory.readUnsignedShort(readBuffer, 8), WithOption.WithEncoding("BCD"));
            short hour = FieldReaderFactory.readSimpleField("hour", DataReaderFactory.readUnsignedShort(readBuffer, 8), WithOption.WithEncoding("BCD"));
            short minutes = FieldReaderFactory.readSimpleField("minutes", DataReaderFactory.readUnsignedShort(readBuffer, 8), WithOption.WithEncoding("BCD"));
            short seconds = FieldReaderFactory.readSimpleField("seconds", DataReaderFactory.readUnsignedShort(readBuffer, 8), WithOption.WithEncoding("BCD"));
            short millisecondsOfSecond = FieldReaderFactory.readSimpleField("millisecondsOfSecond", DataReaderFactory.readUnsignedShort(readBuffer, 12), WithOption.WithEncoding("BCD"));
            byte dayOfWeek = FieldReaderFactory.readSimpleField("dayOfWeek", DataReaderFactory.readUnsignedByte(readBuffer, 4), WithOption.WithEncoding("BCD"));
            return PlcDATE_AND_TIME.ofSegments(year, month == 0 ? (short)1 : month, day == 0 ? (short)1 : day, hour, minutes, seconds, millisecondsOfSecond * 1000000);
        }
        if (EvaluationHelper.equals(dataProtocolId, "IEC61131_DATE_AND_LTIME")) {
            BigInteger nanosecondsSinceEpoch = FieldReaderFactory.readSimpleField("nanosecondsSinceEpoch", DataReaderFactory.readUnsignedBigInteger(readBuffer, 64), new WithReaderArgs[0]);
            return PlcDATE_AND_LTIME.ofNanosecondsSinceEpoch(nanosecondsSinceEpoch);
        }
        if (EvaluationHelper.equals(dataProtocolId, "IEC61131_DTL")) {
            int year = FieldReaderFactory.readSimpleField("year", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
            short month = FieldReaderFactory.readSimpleField("month", DataReaderFactory.readUnsignedShort(readBuffer, 8), new WithReaderArgs[0]);
            short day = FieldReaderFactory.readSimpleField("day", DataReaderFactory.readUnsignedShort(readBuffer, 8), new WithReaderArgs[0]);
            short dayOfWeek = FieldReaderFactory.readSimpleField("dayOfWeek", DataReaderFactory.readUnsignedShort(readBuffer, 8), new WithReaderArgs[0]);
            short hour = FieldReaderFactory.readSimpleField("hour", DataReaderFactory.readUnsignedShort(readBuffer, 8), new WithReaderArgs[0]);
            short minutes = FieldReaderFactory.readSimpleField("minutes", DataReaderFactory.readUnsignedShort(readBuffer, 8), new WithReaderArgs[0]);
            short seconds = FieldReaderFactory.readSimpleField("seconds", DataReaderFactory.readUnsignedShort(readBuffer, 8), new WithReaderArgs[0]);
            long nannosecondsOfSecond = FieldReaderFactory.readSimpleField("nannosecondsOfSecond", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
            return PlcDATE_AND_LTIME.ofSegments(year, month == 0 ? (short)1 : month, day == 0 ? (short)1 : day, hour, minutes, seconds, nannosecondsOfSecond);
        }
        return null;
    }

    public static int getLengthInBytes(PlcValue _value, String dataProtocolId, ControllerType controllerType, Integer stringLength) {
        return (int)Math.ceil((double)DataItem.getLengthInBits(_value, dataProtocolId, controllerType, stringLength) / 8.0);
    }

    public static int getLengthInBits(PlcValue _value, String dataProtocolId, ControllerType controllerType, Integer stringLength) {
        int lengthInBits = 0;
        if (EvaluationHelper.equals(dataProtocolId, "IEC61131_BOOL")) {
            lengthInBits += 7;
            ++lengthInBits;
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_BYTE")) {
            lengthInBits += 8;
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_WORD")) {
            lengthInBits += 16;
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_DWORD")) {
            lengthInBits += 32;
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_LWORD")) {
            lengthInBits += 64;
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_SINT")) {
            lengthInBits += 8;
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_USINT")) {
            lengthInBits += 8;
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_INT")) {
            lengthInBits += 16;
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_UINT")) {
            lengthInBits += 16;
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_DINT")) {
            lengthInBits += 32;
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_UDINT")) {
            lengthInBits += 32;
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_LINT")) {
            lengthInBits += 64;
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_ULINT")) {
            lengthInBits += 64;
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_REAL")) {
            lengthInBits += 32;
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_LREAL")) {
            lengthInBits += 64;
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_CHAR")) {
            lengthInBits += 8;
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_WCHAR")) {
            lengthInBits += 16;
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_STRING")) {
            lengthInBits += stringLength * 8 + 16;
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_WSTRING")) {
            lengthInBits += stringLength * 16 + 32;
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_TIME")) {
            lengthInBits += 32;
        } else if (EvaluationHelper.equals(dataProtocolId, "S7_S5TIME")) {
            lengthInBits += 2;
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_LTIME")) {
            lengthInBits += 64;
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_DATE")) {
            lengthInBits += 16;
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_TIME_OF_DAY")) {
            lengthInBits += 32;
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_LTIME_OF_DAY")) {
            lengthInBits += 64;
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_DATE_AND_TIME")) {
            lengthInBits += 8;
            lengthInBits += 8;
            lengthInBits += 8;
            lengthInBits += 8;
            lengthInBits += 8;
            lengthInBits += 8;
            lengthInBits += 12;
            lengthInBits += 4;
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_DATE_AND_LTIME")) {
            lengthInBits += 64;
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_DTL")) {
            lengthInBits += 16;
            lengthInBits += 8;
            lengthInBits += 8;
            lengthInBits += 8;
            lengthInBits += 8;
            lengthInBits += 8;
            lengthInBits += 8;
            lengthInBits += 32;
        }
        return lengthInBits;
    }

    public static void staticSerialize(WriteBuffer writeBuffer, PlcValue _value, String dataProtocolId, ControllerType controllerType, Integer stringLength) throws SerializationException {
        DataItem.staticSerialize(writeBuffer, _value, dataProtocolId, controllerType, stringLength, ByteOrder.BIG_ENDIAN);
    }

    public static void staticSerialize(WriteBuffer writeBuffer, PlcValue _value, String dataProtocolId, ControllerType controllerType, Integer stringLength, ByteOrder byteOrder) throws SerializationException {
        if (EvaluationHelper.equals(dataProtocolId, "IEC61131_BOOL")) {
            FieldWriterFactory.writeReservedField("reserved", (byte)0, DataWriterFactory.writeUnsignedByte(writeBuffer, 7), new WithWriterArgs[0]);
            FieldWriterFactory.writeSimpleField("value", _value.getBoolean(), DataWriterFactory.writeBoolean(writeBuffer), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_BYTE")) {
            FieldWriterFactory.writeSimpleField("value", _value.getShort(), DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_WORD")) {
            FieldWriterFactory.writeSimpleField("value", _value.getInteger(), DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_DWORD")) {
            FieldWriterFactory.writeSimpleField("value", _value.getLong(), DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_LWORD")) {
            FieldWriterFactory.writeSimpleField("value", _value.getBigInteger(), DataWriterFactory.writeUnsignedBigInteger(writeBuffer, 64), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_SINT")) {
            FieldWriterFactory.writeSimpleField("value", _value.getByte(), DataWriterFactory.writeSignedByte(writeBuffer, 8), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_USINT")) {
            FieldWriterFactory.writeSimpleField("value", _value.getShort(), DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_INT")) {
            FieldWriterFactory.writeSimpleField("value", _value.getShort(), DataWriterFactory.writeSignedShort(writeBuffer, 16), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_UINT")) {
            FieldWriterFactory.writeSimpleField("value", _value.getInteger(), DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_DINT")) {
            FieldWriterFactory.writeSimpleField("value", _value.getInteger(), DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_UDINT")) {
            FieldWriterFactory.writeSimpleField("value", _value.getLong(), DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_LINT")) {
            FieldWriterFactory.writeSimpleField("value", _value.getLong(), DataWriterFactory.writeSignedLong(writeBuffer, 64), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_ULINT")) {
            FieldWriterFactory.writeSimpleField("value", _value.getBigInteger(), DataWriterFactory.writeUnsignedBigInteger(writeBuffer, 64), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_REAL")) {
            FieldWriterFactory.writeSimpleField("value", Float.valueOf(_value.getFloat()), DataWriterFactory.writeFloat(writeBuffer, 32), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_LREAL")) {
            FieldWriterFactory.writeSimpleField("value", _value.getDouble(), DataWriterFactory.writeDouble(writeBuffer, 64), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_CHAR")) {
            FieldWriterFactory.writeSimpleField("value", _value.getString(), DataWriterFactory.writeString(writeBuffer, 8), WithOption.WithEncoding("UTF-8"));
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_WCHAR")) {
            FieldWriterFactory.writeSimpleField("value", _value.getString(), DataWriterFactory.writeString(writeBuffer, 16), WithOption.WithEncoding("UTF-16"));
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_STRING")) {
            FieldWriterFactory.writeManualField("value", () -> StaticHelper.serializeS7String(writeBuffer, _value, stringLength, "UTF-8"), writeBuffer, WithOption.WithEncoding("UTF-8"));
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_WSTRING")) {
            FieldWriterFactory.writeManualField("value", () -> StaticHelper.serializeS7String(writeBuffer, _value, stringLength, "UTF-16"), writeBuffer, WithOption.WithEncoding("UTF-16"));
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_TIME")) {
            FieldWriterFactory.writeSimpleField("milliseconds", _value.getDuration().toMillis(), DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals(dataProtocolId, "S7_S5TIME")) {
            FieldWriterFactory.writeManualField("milliseconds", () -> StaticHelper.serializeS5Time(writeBuffer, _value), writeBuffer, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_LTIME")) {
            FieldWriterFactory.writeSimpleField("nanoseconds", BigInteger.valueOf(_value.getDuration().toNanos()), DataWriterFactory.writeUnsignedBigInteger(writeBuffer, 64), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_DATE")) {
            FieldWriterFactory.writeManualField("daysSinceEpoch", () -> StaticHelper.serializeTiaDate(writeBuffer, _value), writeBuffer, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_TIME_OF_DAY")) {
            FieldWriterFactory.writeSimpleField("millisecondsSinceMidnight", _value.getTime().getLong(ChronoField.MILLI_OF_DAY), DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_LTIME_OF_DAY")) {
            FieldWriterFactory.writeSimpleField("nanosecondsSinceMidnight", BigInteger.valueOf(_value.getTime().getLong(ChronoField.NANO_OF_DAY)), DataWriterFactory.writeUnsignedBigInteger(writeBuffer, 64), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_DATE_AND_TIME")) {
            FieldWriterFactory.writeManualField("year", () -> StaticHelper.serializeSiemensYear(writeBuffer, _value), writeBuffer, WithOption.WithEncoding("BCD"));
            FieldWriterFactory.writeSimpleField("month", (short)_value.getDate().getMonthValue(), DataWriterFactory.writeUnsignedShort(writeBuffer, 8), WithOption.WithEncoding("BCD"));
            FieldWriterFactory.writeSimpleField("day", (short)_value.getDate().getDayOfMonth(), DataWriterFactory.writeUnsignedShort(writeBuffer, 8), WithOption.WithEncoding("BCD"));
            FieldWriterFactory.writeSimpleField("hour", (short)_value.getTime().getHour(), DataWriterFactory.writeUnsignedShort(writeBuffer, 8), WithOption.WithEncoding("BCD"));
            FieldWriterFactory.writeSimpleField("minutes", (short)_value.getTime().getMinute(), DataWriterFactory.writeUnsignedShort(writeBuffer, 8), WithOption.WithEncoding("BCD"));
            FieldWriterFactory.writeSimpleField("seconds", (short)_value.getTime().getSecond(), DataWriterFactory.writeUnsignedShort(writeBuffer, 8), WithOption.WithEncoding("BCD"));
            FieldWriterFactory.writeSimpleField("millisecondsOfSecond", (short)_value.getTime().get(ChronoField.MILLI_OF_SECOND), DataWriterFactory.writeUnsignedShort(writeBuffer, 12), WithOption.WithEncoding("BCD"));
            FieldWriterFactory.writeSimpleField("dayOfWeek", (byte)_value.getDate().getDayOfWeek().getValue(), DataWriterFactory.writeUnsignedByte(writeBuffer, 4), WithOption.WithEncoding("BCD"));
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_DATE_AND_LTIME")) {
            FieldWriterFactory.writeSimpleField("nanosecondsSinceEpoch", BigInteger.valueOf(_value.getDateTime().toEpochSecond(ZoneOffset.UTC)).multiply(BigInteger.valueOf(1000000000L)).add(BigInteger.valueOf(_value.getDateTime().getNano())), DataWriterFactory.writeUnsignedBigInteger(writeBuffer, 64), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals(dataProtocolId, "IEC61131_DTL")) {
            FieldWriterFactory.writeSimpleField("year", _value.getDate().getYear(), DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
            FieldWriterFactory.writeSimpleField("month", (short)_value.getDate().getMonthValue(), DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
            FieldWriterFactory.writeSimpleField("day", (short)_value.getDate().getDayOfMonth(), DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
            FieldWriterFactory.writeSimpleField("dayOfWeek", (short)_value.getDate().getDayOfWeek().getValue(), DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
            FieldWriterFactory.writeSimpleField("hour", (short)_value.getTime().getHour(), DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
            FieldWriterFactory.writeSimpleField("minutes", (short)_value.getTime().getMinute(), DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
            FieldWriterFactory.writeSimpleField("seconds", (short)_value.getTime().getSecond(), DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
            FieldWriterFactory.writeSimpleField("nannosecondsOfSecond", _value.getTime().getLong(ChronoField.NANO_OF_SECOND), DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        }
    }
}

