/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.s7.readwrite.S7Parameter;
import org.apache.plc4x.java.s7.readwrite.S7VarRequestParameterItem;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class S7ParameterReadVarRequest
extends S7Parameter
implements Message {
    protected final List<S7VarRequestParameterItem> items;

    @Override
    public Short getParameterType() {
        return (short)4;
    }

    @Override
    public Short getMessageType() {
        return (short)1;
    }

    public S7ParameterReadVarRequest(List<S7VarRequestParameterItem> items) {
        this.items = items;
    }

    public List<S7VarRequestParameterItem> getItems() {
        return this.items;
    }

    @Override
    protected void serializeS7ParameterChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("S7ParameterReadVarRequest", new WithWriterArgs[0]);
        short numItems = (short)StaticHelper.COUNT(this.getItems());
        FieldWriterFactory.writeImplicitField("numItems", numItems, DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField("items", this.items, writeBuffer, new WithWriterArgs[0]);
        writeBuffer.popContext("S7ParameterReadVarRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        S7ParameterReadVarRequest _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 8;
        if (this.items != null) {
            int i = 0;
            for (S7VarRequestParameterItem element : this.items) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.items.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static S7Parameter.S7ParameterBuilder staticParseS7ParameterBuilder(ReadBuffer readBuffer, Short messageType) throws ParseException {
        readBuffer.pullContext("S7ParameterReadVarRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        short numItems = FieldReaderFactory.readImplicitField("numItems", DataReaderFactory.readUnsignedShort(readBuffer, 8), new WithReaderArgs[0]);
        List<S7VarRequestParameterItem> items = FieldReaderFactory.readCountArrayField("items", new DataReaderComplexDefault<S7VarRequestParameterItem>(() -> S7VarRequestParameterItem.staticParse(readBuffer), readBuffer), numItems, new WithReaderArgs[0]);
        readBuffer.closeContext("S7ParameterReadVarRequest", new WithReaderArgs[0]);
        return new S7ParameterReadVarRequestBuilderImpl(items);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof S7ParameterReadVarRequest)) {
            return false;
        }
        S7ParameterReadVarRequest that = (S7ParameterReadVarRequest)o;
        return this.getItems() == that.getItems() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getItems());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class S7ParameterReadVarRequestBuilderImpl
    implements S7Parameter.S7ParameterBuilder {
        private final List<S7VarRequestParameterItem> items;

        public S7ParameterReadVarRequestBuilderImpl(List<S7VarRequestParameterItem> items) {
            this.items = items;
        }

        @Override
        public S7ParameterReadVarRequest build() {
            S7ParameterReadVarRequest s7ParameterReadVarRequest = new S7ParameterReadVarRequest(this.items);
            return s7ParameterReadVarRequest;
        }
    }
}

