/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.s7.readwrite.DataTransportErrorCode;
import org.apache.plc4x.java.s7.readwrite.DataTransportSize;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class S7VarPayloadDataItem
implements Message {
    protected final DataTransportErrorCode returnCode;
    protected final DataTransportSize transportSize;
    protected final byte[] data;

    public S7VarPayloadDataItem(DataTransportErrorCode returnCode, DataTransportSize transportSize, byte[] data) {
        this.returnCode = returnCode;
        this.transportSize = transportSize;
        this.data = data;
    }

    public DataTransportErrorCode getReturnCode() {
        return this.returnCode;
    }

    public DataTransportSize getTransportSize() {
        return this.transportSize;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("S7VarPayloadDataItem", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField("returnCode", "DataTransportErrorCode", this.returnCode, new DataWriterEnumDefault<DataTransportErrorCode, Short>(DataTransportErrorCode::getValue, Enum::name, DataWriterFactory.writeUnsignedShort(writeBuffer, 8)), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField("transportSize", "DataTransportSize", this.transportSize, new DataWriterEnumDefault<DataTransportSize, Short>(DataTransportSize::getValue, Enum::name, DataWriterFactory.writeUnsignedShort(writeBuffer, 8)), new WithWriterArgs[0]);
        int dataLength = StaticHelper.COUNT(this.getData()) * (this.getTransportSize() == DataTransportSize.BIT ? 1 : (this.getTransportSize().getSizeInBits() ? 8 : 1));
        FieldWriterFactory.writeImplicitField("dataLength", dataLength, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField("data", this.data, DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
        FieldWriterFactory.writePaddingField("padding", !_lastItem ? StaticHelper.COUNT(this.data) % 2 : 0, (short)0, DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
        writeBuffer.popContext("S7VarPayloadDataItem", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = 0;
        S7VarPayloadDataItem _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 8;
        lengthInBits += 8;
        lengthInBits += 16;
        if (this.data != null) {
            lengthInBits += 8 * this.data.length;
        }
        int _timesPadding = !_lastItem ? StaticHelper.COUNT(this.data) % 2 : 0;
        while (_timesPadding-- > 0) {
            lengthInBits += 8;
        }
        return lengthInBits;
    }

    public static S7VarPayloadDataItem staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return S7VarPayloadDataItem.staticParse(readBuffer);
    }

    public static S7VarPayloadDataItem staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("S7VarPayloadDataItem", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        DataTransportErrorCode returnCode = (DataTransportErrorCode)((Object)FieldReaderFactory.readEnumField("returnCode", "DataTransportErrorCode", new DataReaderEnumDefault<DataTransportErrorCode, Short>(DataTransportErrorCode::enumForValue, DataReaderFactory.readUnsignedShort(readBuffer, 8)), new WithReaderArgs[0]));
        DataTransportSize transportSize = (DataTransportSize)((Object)FieldReaderFactory.readEnumField("transportSize", "DataTransportSize", new DataReaderEnumDefault<DataTransportSize, Short>(DataTransportSize::enumForValue, DataReaderFactory.readUnsignedShort(readBuffer, 8)), new WithReaderArgs[0]));
        int dataLength = FieldReaderFactory.readImplicitField("dataLength", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
        byte[] data = readBuffer.readByteArray("data", Math.toIntExact(transportSize.getSizeInBits() ? StaticHelper.CEIL((double)dataLength / 8.0) : dataLength), new WithReaderArgs[0]);
        FieldReaderFactory.readPaddingField(DataReaderFactory.readUnsignedShort(readBuffer, 8), !_lastItem ? StaticHelper.COUNT(data) % 2 : 0, new WithReaderArgs[0]);
        readBuffer.closeContext("S7VarPayloadDataItem", new WithReaderArgs[0]);
        S7VarPayloadDataItem _s7VarPayloadDataItem = new S7VarPayloadDataItem(returnCode, transportSize, data);
        return _s7VarPayloadDataItem;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof S7VarPayloadDataItem)) {
            return false;
        }
        S7VarPayloadDataItem that = (S7VarPayloadDataItem)o;
        return this.getReturnCode() == that.getReturnCode() && this.getTransportSize() == that.getTransportSize() && this.getData() == that.getData();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getReturnCode(), this.getTransportSize(), this.getData()});
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

