/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite.optimizer;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.s7.readwrite.MemoryArea;
import org.apache.plc4x.java.s7.readwrite.S7AddressAny;
import org.apache.plc4x.java.s7.readwrite.S7MessageRequest;
import org.apache.plc4x.java.s7.readwrite.S7MessageResponseData;
import org.apache.plc4x.java.s7.readwrite.S7ParameterReadVarRequest;
import org.apache.plc4x.java.s7.readwrite.S7ParameterReadVarResponse;
import org.apache.plc4x.java.s7.readwrite.S7ParameterWriteVarRequest;
import org.apache.plc4x.java.s7.readwrite.S7ParameterWriteVarResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadReadVarResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadWriteVarRequest;
import org.apache.plc4x.java.s7.readwrite.S7PayloadWriteVarResponse;
import org.apache.plc4x.java.s7.readwrite.TransportSize;
import org.apache.plc4x.java.s7.readwrite.context.S7DriverContext;
import org.apache.plc4x.java.s7.readwrite.tag.S7ClkTag;
import org.apache.plc4x.java.s7.readwrite.tag.S7StringVarLengthTag;
import org.apache.plc4x.java.s7.readwrite.tag.S7SzlTag;
import org.apache.plc4x.java.s7.readwrite.tag.S7Tag;
import org.apache.plc4x.java.spi.context.DriverContext;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteRequest;
import org.apache.plc4x.java.spi.messages.utils.TagValueItem;
import org.apache.plc4x.java.spi.optimizer.BaseOptimizer;

public class S7Optimizer
extends BaseOptimizer {
    public static final int EMPTY_READ_REQUEST_SIZE = new S7MessageRequest(0, new S7ParameterReadVarRequest(Collections.emptyList()), null).getLengthInBytes();
    public static final int EMPTY_READ_RESPONSE_SIZE = new S7MessageResponseData(0, new S7ParameterReadVarResponse(0), new S7PayloadReadVarResponse(Collections.emptyList()), 0, 0).getLengthInBytes();
    public static final int EMPTY_WRITE_REQUEST_SIZE = new S7MessageRequest(0, new S7ParameterWriteVarRequest(Collections.emptyList()), new S7PayloadWriteVarRequest(Collections.emptyList())).getLengthInBytes();
    public static final int EMPTY_WRITE_RESPONSE_SIZE = new S7MessageResponseData(0, new S7ParameterWriteVarResponse(0), new S7PayloadWriteVarResponse(Collections.emptyList()), 0, 0).getLengthInBytes();
    public static final int S7_ADDRESS_ANY_SIZE = 2 + new S7AddressAny(TransportSize.INT, 1, 1, MemoryArea.DATA_BLOCKS, 1, 0).getLengthInBytes();

    @Override
    protected List<PlcReadRequest> processReadRequest(PlcReadRequest readRequest, DriverContext driverContext) {
        S7DriverContext s7DriverContext = (S7DriverContext)driverContext;
        LinkedList<PlcReadRequest> processedRequests = new LinkedList<PlcReadRequest>();
        int curRequestSize = EMPTY_READ_REQUEST_SIZE;
        int curResponseSize = EMPTY_READ_RESPONSE_SIZE;
        LinkedHashMap<String, PlcTag> curTags = new LinkedHashMap<String, PlcTag>();
        for (String tagName : readRequest.getTagNames()) {
            if (readRequest.getTag(tagName) instanceof S7SzlTag || readRequest.getTag(tagName) instanceof S7ClkTag) {
                curTags.put(tagName, readRequest.getTag(tagName));
                continue;
            }
            if (readRequest.getTag(tagName) instanceof S7StringVarLengthTag) {
                LinkedHashMap<String, PlcTag> strTags = new LinkedHashMap<String, PlcTag>();
                strTags.put(tagName, readRequest.getTag(tagName));
                processedRequests.add(new DefaultPlcReadRequest(((DefaultPlcReadRequest)readRequest).getReader(), strTags));
                continue;
            }
            S7Tag tag = (S7Tag)readRequest.getTag(tagName);
            int readRequestItemSize = S7_ADDRESS_ANY_SIZE;
            int readResponseItemSize = 4 + tag.getNumberOfElements() * tag.getDataType().getSizeInBytes();
            if (readResponseItemSize % 2 == 1) {
                ++readResponseItemSize;
            }
            if (curRequestSize + readRequestItemSize <= s7DriverContext.getPduSize() && curResponseSize + readResponseItemSize <= s7DriverContext.getPduSize()) {
                curRequestSize += readRequestItemSize;
                curResponseSize += readResponseItemSize;
            } else {
                processedRequests.add(new DefaultPlcReadRequest(((DefaultPlcReadRequest)readRequest).getReader(), curTags));
                curRequestSize = EMPTY_READ_REQUEST_SIZE + readRequestItemSize;
                curResponseSize = EMPTY_READ_RESPONSE_SIZE + readResponseItemSize;
                curTags = new LinkedHashMap();
                if (curRequestSize + readRequestItemSize > s7DriverContext.getPduSize() && curResponseSize + readResponseItemSize > s7DriverContext.getPduSize()) {
                    throw new PlcRuntimeException("Tag size exceeds maximum payload for one item.");
                }
            }
            curTags.put(tagName, tag);
        }
        if (!curTags.isEmpty()) {
            processedRequests.add(new DefaultPlcReadRequest(((DefaultPlcReadRequest)readRequest).getReader(), curTags));
        }
        return processedRequests;
    }

    @Override
    protected List<PlcWriteRequest> processWriteRequest(PlcWriteRequest writeRequest, DriverContext driverContext) {
        for (String tagName : writeRequest.getTagNames()) {
            if (!(writeRequest.getTag(tagName) instanceof S7ClkTag)) continue;
            return Collections.singletonList(writeRequest);
        }
        S7DriverContext s7DriverContext = (S7DriverContext)driverContext;
        LinkedList<PlcWriteRequest> processedRequests = new LinkedList<PlcWriteRequest>();
        int curRequestSize = EMPTY_WRITE_REQUEST_SIZE;
        int curResponseSize = EMPTY_WRITE_RESPONSE_SIZE;
        LinkedHashMap<String, TagValueItem> curTags = new LinkedHashMap<String, TagValueItem>();
        for (String tagName : writeRequest.getTagNames()) {
            if (writeRequest.getTag(tagName) instanceof S7StringVarLengthTag) {
                LinkedHashMap<String, TagValueItem> strTags = new LinkedHashMap<String, TagValueItem>();
                strTags.put(tagName, new TagValueItem(writeRequest.getTag(tagName), writeRequest.getPlcValue(tagName)));
                processedRequests.add(new DefaultPlcWriteRequest(((DefaultPlcWriteRequest)writeRequest).getWriter(), strTags));
                continue;
            }
            S7Tag tag = (S7Tag)writeRequest.getTag(tagName);
            PlcValue value = writeRequest.getPlcValue(tagName);
            int writeRequestItemSize = S7_ADDRESS_ANY_SIZE + 4;
            writeRequestItemSize = tag.getDataType() == TransportSize.BOOL ? (writeRequestItemSize += (int)Math.ceil((double)tag.getNumberOfElements() / 8.0)) : (writeRequestItemSize += tag.getNumberOfElements() * tag.getDataType().getSizeInBytes());
            if (writeRequestItemSize % 2 == 1) {
                ++writeRequestItemSize;
            }
            int writeResponseItemSize = 4;
            if (curRequestSize + writeRequestItemSize <= s7DriverContext.getPduSize() && curResponseSize + writeResponseItemSize <= s7DriverContext.getPduSize()) {
                curRequestSize += writeRequestItemSize;
                curResponseSize += writeResponseItemSize;
            } else {
                processedRequests.add(new DefaultPlcWriteRequest(((DefaultPlcWriteRequest)writeRequest).getWriter(), curTags));
                curRequestSize = EMPTY_WRITE_REQUEST_SIZE + writeRequestItemSize;
                curResponseSize = EMPTY_WRITE_RESPONSE_SIZE + writeResponseItemSize;
                curTags = new LinkedHashMap();
                if (curRequestSize + writeRequestItemSize > s7DriverContext.getPduSize() && curResponseSize + writeResponseItemSize > s7DriverContext.getPduSize()) {
                    throw new PlcRuntimeException("Tag size exceeds maximum payload for one item.");
                }
            }
            curTags.put(tagName, new TagValueItem(tag, value));
        }
        if (!curTags.isEmpty()) {
            processedRequests.add(new DefaultPlcWriteRequest(((DefaultPlcWriteRequest)writeRequest).getWriter(), curTags));
        }
        return processedRequests;
    }
}

