/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite.tag;

import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.exceptions.PlcInvalidTagException;
import org.apache.plc4x.java.api.model.ArrayInfo;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcValueType;

public class S7SzlTag
implements PlcTag {
    private static final Pattern SSL_ADDRESS_PATTERN = Pattern.compile("^SZL_ID=(?<szlId>16#[0-9a-fA-F]{4});INDEX=(?<index>16#[0-9a-fA-F]{4})");
    private static final String GROUP_NAME_SZL_ID = "szlId";
    private static final String GROUP_NAME_INDEX = "index";
    private final int szlId;
    private final int index;

    public S7SzlTag(int szlId, int index) {
        this.szlId = szlId;
        this.index = index;
    }

    @Override
    public String getAddressString() {
        return String.format("SZL_ID=%s;INDEX=16#%d", this.szlId, this.index);
    }

    @Override
    public PlcValueType getPlcValueType() {
        return PlcValueType.RAW_BYTE_ARRAY;
    }

    @Override
    public List<ArrayInfo> getArrayInfo() {
        return Collections.emptyList();
    }

    public int getSzlId() {
        return this.szlId;
    }

    public int getIndex() {
        return this.index;
    }

    public static boolean matches(String tagString) {
        return SSL_ADDRESS_PATTERN.matcher(tagString).matches();
    }

    public static S7SzlTag of(String tagString) {
        Matcher matcher = SSL_ADDRESS_PATTERN.matcher(tagString);
        if (matcher.matches()) {
            String strSxlId = matcher.group(GROUP_NAME_SZL_ID);
            String strIndex = matcher.group(GROUP_NAME_INDEX);
            strSxlId = strSxlId.replaceAll("16#", "");
            strIndex = strIndex.replaceAll("16#", "");
            return new S7SzlTag(Integer.parseInt(strSxlId, 16), Integer.parseInt(strIndex, 16));
        }
        throw new PlcInvalidTagException("Unable to parse address: " + tagString);
    }
}

