/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.scraper;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.plc4x.java.api.PlcConnectionManager;
import org.apache.plc4x.java.scraper.ResultHandler;
import org.apache.plc4x.java.scraper.ScrapeJob;
import org.apache.plc4x.java.scraper.Scraper;
import org.apache.plc4x.java.scraper.ScraperTask;
import org.apache.plc4x.java.scraper.ScraperTaskImpl;
import org.apache.plc4x.java.scraper.config.ScraperConfiguration;
import org.apache.plc4x.java.scraper.exception.ScraperException;
import org.apache.plc4x.java.scraper.util.PercentageAboveThreshold;
import org.apache.plc4x.java.utils.cache.CachedPlcConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ScraperImpl
implements Scraper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScraperImpl.class);
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(10, new BasicThreadFactory.Builder().namingPattern("scheduler-thread-%d").daemon(false).build());
    private final ExecutorService handlerPool = Executors.newFixedThreadPool(4, new BasicThreadFactory.Builder().namingPattern("handler-thread-%d").daemon(true).build());
    private final ResultHandler resultHandler;
    private final MultiValuedMap<ScrapeJob, ScraperTask> tasks = new ArrayListValuedHashMap<ScrapeJob, ScraperTask>();
    private final MultiValuedMap<ScraperTask, ScheduledFuture<?>> futures = new ArrayListValuedHashMap();
    private final PlcConnectionManager connectionManager;
    private final List<ScrapeJob> jobs;

    public ScraperImpl(ResultHandler resultHandler, PlcConnectionManager connectionManager, List<ScrapeJob> jobs) {
        this.resultHandler = resultHandler;
        Validate.notEmpty(jobs);
        this.connectionManager = connectionManager;
        this.jobs = jobs;
    }

    public ScraperImpl(ScraperConfiguration config, ResultHandler resultHandler) throws ScraperException {
        this(resultHandler, ScraperImpl.createCachedPlcConnectionManager(), config.getJobs());
    }

    private static CachedPlcConnectionManager createCachedPlcConnectionManager() {
        return CachedPlcConnectionManager.getBuilder().build();
    }

    @Override
    public void start() {
        LOGGER.info("Starting jobs...");
        this.jobs.stream().flatMap(job -> job.getSourceConnections().entrySet().stream().map(entry -> Triple.of(job, (String)entry.getKey(), (String)entry.getValue()))).forEach(tuple -> {
            LOGGER.debug("Register task for job {} for conn {} ({}) at rate {} ms", new Object[]{((ScrapeJob)tuple.getLeft()).getJobName(), tuple.getMiddle(), tuple.getRight(), ((ScrapeJob)tuple.getLeft()).getScrapeRate()});
            ScraperTaskImpl task = new ScraperTaskImpl(this.connectionManager, ((ScrapeJob)tuple.getLeft()).getJobName(), (String)tuple.getMiddle(), (String)tuple.getRight(), ((ScrapeJob)tuple.getLeft()).getTags(), 1000L, this.handlerPool, this.resultHandler);
            this.tasks.put((ScrapeJob)tuple.getLeft(), task);
            ScheduledFuture<?> future = this.scheduler.scheduleAtFixedRate(task, 0L, ((ScrapeJob)tuple.getLeft()).getScrapeRate(), TimeUnit.MILLISECONDS);
            this.futures.put(task, future);
        });
        this.scheduler.scheduleAtFixedRate(() -> {
            for (Map.Entry<ScrapeJob, ScraperTask> entry : this.tasks.entries()) {
                DescriptiveStatistics statistics = entry.getValue().getLatencyStatistics();
                String msg = String.format(Locale.ENGLISH, "Job statistics (%s, %s) number of requests: %d (%d success, %.1f %% failed, %.1f %% too slow), min latency: %.2f ms, mean latency: %.2f ms, median: %.2f ms", entry.getValue().getJobName(), entry.getValue().getConnectionAlias(), entry.getValue().getRequestCounter(), entry.getValue().getSuccessfullRequestCounter(), entry.getValue().getPercentageFailed(), statistics.apply(new PercentageAboveThreshold((double)entry.getKey().getScrapeRate() * 1000000.0)), statistics.getMin() * 1.0E-6, statistics.getMean() * 1.0E-6, statistics.getPercentile(50.0) * 1.0E-6);
                LOGGER.debug(msg);
            }
        }, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    @Override
    public int getNumberOfActiveTasks() {
        return (int)this.futures.entries().stream().filter(entry -> !((ScheduledFuture)entry.getValue()).isDone()).count();
    }

    @Override
    public void stop() {
        LOGGER.info("Stopping scraper...");
        for (Map.Entry<ScraperTask, ScheduledFuture<?>> entry : this.futures.entries()) {
            LOGGER.debug("Stopping task {}...", (Object)entry.getKey());
            entry.getValue().cancel(true);
        }
        this.futures.clear();
    }
}

