/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.scraper.triggeredscraper.triggerhandler.collector;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.PlcConnectionManager;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.scraper.exception.ScraperException;
import org.apache.plc4x.java.scraper.triggeredscraper.TriggeredScraperImpl;
import org.apache.plc4x.java.scraper.triggeredscraper.triggerhandler.collector.TriggerCollector;
import org.apache.plc4x.java.utils.cache.CachedPlcConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerCollectorImpl
implements TriggerCollector {
    private static final Logger logger = LoggerFactory.getLogger(TriggerCollectorImpl.class);
    private static final int DEFAULT_SCHEDULED_TRIGGER_INTERVAL = 1000;
    private static final int FUTURE_TIMEOUT = 2000;
    private static final int READ_REQUEST_TIMEOUT = 2000;
    private final PlcConnectionManager plcConnectionManager;
    private final Map<String, RequestElement> currentRequestElements;
    private long schedulerInterval;
    private final long futureTimeout;
    private final ScheduledExecutorService scheduledExecutorService;
    private final ExecutorService executorService;

    public TriggerCollectorImpl(PlcConnectionManager plcConnectionManager, long schedulerInterval, long futureTimeout, int poolSizeScheduler, int poolSizeExecutor) {
        if (!(plcConnectionManager instanceof CachedPlcConnectionManager)) {
            logger.warn("The Triggered Scraper is intended to be used with a Cached Connection-Manager. In other situations leaks could occur!");
        }
        this.plcConnectionManager = plcConnectionManager;
        this.currentRequestElements = new ConcurrentHashMap<String, RequestElement>();
        this.schedulerInterval = schedulerInterval;
        this.futureTimeout = futureTimeout;
        this.scheduledExecutorService = Executors.newScheduledThreadPool(poolSizeScheduler, new BasicThreadFactory.Builder().namingPattern("triggercollector-scheduledExecutorService-thread-%d").daemon(false).build());
        this.executorService = Executors.newFixedThreadPool(poolSizeExecutor, new BasicThreadFactory.Builder().namingPattern("triggercollector-executerService-thread-%d").daemon(true).build());
    }

    public TriggerCollectorImpl(PlcConnectionManager plcConnectionManager, long schedulerInterval, long futureTimeout) {
        this(plcConnectionManager, schedulerInterval, futureTimeout, 10, 20);
    }

    public TriggerCollectorImpl(PlcConnectionManager plcConnectionManager) {
        this(plcConnectionManager, 1000L, 2000L);
    }

    @Override
    public String submitTrigger(String tag, String plcConnectionString, long interval) throws ScraperException {
        RequestElement requestElement;
        String uuid = UUID.randomUUID().toString();
        if (this.schedulerInterval > interval) {
            this.schedulerInterval = interval;
        }
        if (!this.currentRequestElements.containsValue(requestElement = new RequestElement(plcConnectionString, tag, interval, uuid))) {
            this.currentRequestElements.put(uuid, requestElement);
            if (logger.isDebugEnabled()) {
                logger.debug("Received request to: {} for PLC: {}", (Object)tag, (Object)plcConnectionString);
            }
            return uuid;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Received a placed trigger");
        }
        for (RequestElement requestElementFromMap : this.currentRequestElements.values()) {
            if (!requestElementFromMap.equals(requestElement)) continue;
            if (requestElementFromMap.getScanIntervalMs() > interval) {
                requestElementFromMap.setScanIntervalMs(interval);
            }
            return requestElementFromMap.getUuid();
        }
        throw new ScraperException(String.format("Could not evaluate UUID for given trigger (%s,%s). Should not happen please report!", tag, plcConnectionString));
    }

    private void processActiveTrigger() {
        LocalDateTime currentTimestamp = LocalDateTime.now();
        HashMap<String, PlcReadRequest.Builder> plcReadRequestBuilderMap = new HashMap<String, PlcReadRequest.Builder>();
        HashMap<String, PlcReadResponse> plcReadResponseMap = new HashMap<String, PlcReadResponse>();
        ArrayList<RequestElement> activeRequestElements = new ArrayList<RequestElement>();
        ArrayList<PlcConnection> plcConnectionList = new ArrayList<PlcConnection>();
        PlcConnection plcConnection = null;
        for (Map.Entry<String, RequestElement> entry : this.currentRequestElements.entrySet()) {
            if (!entry.getValue().getLastAcquirement().isBefore(currentTimestamp.minus(entry.getValue().scanIntervalMs, ChronoUnit.MILLIS))) continue;
            String plcConnectionString = entry.getValue().plcConnectionString;
            if (!plcReadRequestBuilderMap.containsKey(plcConnectionString)) {
                try {
                    String info = "";
                    if (logger.isTraceEnabled()) {
                        info = String.format("acquiring trigger connection to (%s)", plcConnectionString);
                        logger.trace("acquiring trigger connection to ({})", (Object)plcConnectionString);
                    }
                    plcConnection = TriggeredScraperImpl.getPlcConnection(this.plcConnectionManager, plcConnectionString, this.executorService, this.futureTimeout, info);
                    plcConnectionList.add(plcConnection);
                    plcReadRequestBuilderMap.put(plcConnectionString, plcConnection.readRequestBuilder());
                    ((PlcReadRequest.Builder)plcReadRequestBuilderMap.get(plcConnectionString)).addTagAddress(entry.getKey(), entry.getValue().getPlcTag());
                    activeRequestElements.add(entry.getValue());
                }
                catch (InterruptedException e) {
                    logger.warn("Acquirement of PLC-Connection was interrupted", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    logger.warn("Acquirement of PLC-Connection could not be executed", (Throwable)e);
                }
                catch (TimeoutException e) {
                    logger.warn("Acquirement of PLC-Connection was timeouted", (Throwable)e);
                }
                continue;
            }
            ((PlcReadRequest.Builder)plcReadRequestBuilderMap.get(plcConnectionString)).addTagAddress(entry.getKey(), entry.getValue().getPlcTag());
            activeRequestElements.add(entry.getValue());
        }
        for (Map.Entry<String, RequestElement> entry : plcReadRequestBuilderMap.entrySet()) {
            try {
                PlcReadResponse plcReadResponse = ((PlcReadRequest.Builder)((Object)entry.getValue())).build().execute().get(this.futureTimeout, TimeUnit.MILLISECONDS);
                plcReadResponseMap.put(entry.getKey(), plcReadResponse);
            }
            catch (InterruptedException e) {
                logger.warn("Extraction of PlcResponse was interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                logger.warn("Extraction of PlcResponse could not be executed", (Throwable)e);
            }
            catch (TimeoutException e) {
                logger.warn("Extraction of PlcResponse was timeouted", (Throwable)e);
            }
        }
        LocalDateTime localDateTime = LocalDateTime.now();
        for (RequestElement requestElement : activeRequestElements) {
            requestElement.setResult(((PlcReadResponse)plcReadResponseMap.get(requestElement.getPlcConnectionString())).getObject(requestElement.getUuid()));
            requestElement.setLastAcquirement(localDateTime);
        }
        for (PlcConnection plcConnectionFromList : plcConnectionList) {
            if (plcConnectionFromList == null) continue;
            try {
                plcConnectionFromList.close();
            }
            catch (Exception e) {
                logger.warn("Could not close connection ...");
            }
        }
    }

    @Override
    public Object requestResult(String uuid) throws ScraperException {
        return this.requestResult(uuid, 2000L);
    }

    @Override
    public Object requestResult(String uuid, long timeout) {
        return this.currentRequestElements.get(uuid).getResult();
    }

    @Override
    public void start() {
        this.scheduledExecutorService.scheduleAtFixedRate(this::processActiveTrigger, 1000L, this.schedulerInterval, TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() {
        this.scheduledExecutorService.shutdown();
        this.executorService.shutdown();
    }

    static class RequestElement {
        private final String plcConnectionString;
        private final String plcTag;
        private LocalDateTime lastAcquirement;
        private Object result;
        private final String uuid;
        private long scanIntervalMs;

        RequestElement(String plcConnectionString, String plcTag, long scanIntervalMs, String uuid) {
            this.plcConnectionString = plcConnectionString;
            this.plcTag = plcTag;
            this.uuid = uuid;
            this.scanIntervalMs = scanIntervalMs;
            this.lastAcquirement = LocalDateTime.of(1, 1, 1, 1, 1, 1);
        }

        String getPlcConnectionString() {
            return this.plcConnectionString;
        }

        String getPlcTag() {
            return this.plcTag;
        }

        public Object getResult() {
            return this.result;
        }

        public void setResult(Object result) {
            this.result = result;
        }

        String getUuid() {
            return this.uuid;
        }

        long getScanIntervalMs() {
            return this.scanIntervalMs;
        }

        void setScanIntervalMs(long scanIntervalMs) {
            this.scanIntervalMs = scanIntervalMs;
        }

        LocalDateTime getLastAcquirement() {
            return this.lastAcquirement;
        }

        void setLastAcquirement(LocalDateTime lastAcquirement) {
            this.lastAcquirement = lastAcquirement;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RequestElement that = (RequestElement)o;
            return Objects.equals(this.plcConnectionString, that.plcConnectionString) && Objects.equals(this.plcTag, that.plcTag);
        }

        public int hashCode() {
            return Objects.hash(this.plcConnectionString, this.plcTag);
        }

        public String toString() {
            return "RequestElement{plcConnectionString='" + this.plcConnectionString + '\'' + ", plcTag='" + this.plcTag + '\'' + ", lastAcquirement=" + this.lastAcquirement + ", result=" + this.result + ", uuid='" + this.uuid + '\'' + ", scanIntervalMs=" + this.scanIntervalMs + '}';
        }
    }
}

