/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.simulated.tag;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.exceptions.PlcInvalidTagException;
import org.apache.plc4x.java.api.model.ArrayInfo;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.simulated.types.SimulatedTagType;
import org.apache.plc4x.java.spi.model.DefaultArrayInfo;

public class SimulatedTag
implements PlcTag {
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("^(?<type>\\w+)/(?<name>[a-zA-Z0-9_\\\\.]+):(?<dataType>[a-zA-Z0-9]++)(\\[(?<numElements>\\d+)])?$");
    private final SimulatedTagType type;
    private final String name;
    private final PlcValueType dataType;
    private final int numElements;

    private SimulatedTag(SimulatedTagType type, String name, PlcValueType dataType, int numElements) {
        this.type = type;
        this.name = name;
        this.dataType = dataType;
        this.numElements = numElements;
    }

    public static SimulatedTag of(String tagString) throws PlcInvalidTagException {
        Matcher matcher = ADDRESS_PATTERN.matcher(tagString);
        if (matcher.matches()) {
            PlcValueType dataType;
            SimulatedTagType type = SimulatedTagType.valueOf(matcher.group("type"));
            String name = matcher.group("name");
            try {
                dataType = PlcValueType.valueOf(matcher.group("dataType").toUpperCase());
            }
            catch (Exception e) {
                throw new PlcInvalidTagException("Invalid data type: " + matcher.group("dataType"));
            }
            int numElements = 1;
            if (matcher.group("numElements") != null) {
                numElements = Integer.parseInt(matcher.group("numElements"));
            }
            return new SimulatedTag(type, name, dataType, numElements);
        }
        throw new PlcInvalidTagException("Unable to parse address: " + tagString);
    }

    static boolean matches(String tagString) {
        return ADDRESS_PATTERN.matcher(tagString).matches();
    }

    @Override
    public String getAddressString() {
        return String.format("%s/%s:%s[%d]", this.type.name(), this.name, this.dataType.name(), this.numElements);
    }

    @Override
    public PlcValueType getPlcValueType() {
        return this.dataType;
    }

    @Override
    public List<ArrayInfo> getArrayInfo() {
        return Collections.singletonList(new DefaultArrayInfo(0, this.numElements));
    }

    public SimulatedTagType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimulatedTag simulatedTag = (SimulatedTag)o;
        return this.numElements == simulatedTag.numElements && this.type == simulatedTag.type && Objects.equals(this.name, simulatedTag.name) && Objects.equals((Object)this.dataType, (Object)simulatedTag.dataType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.name, this.dataType, this.numElements});
    }

    public String toString() {
        return "SimulatedTag{type=" + (Object)((Object)this.type) + ", name='" + this.name + '\'' + ", dataType='" + (Object)((Object)this.dataType) + '\'' + ", numElements=" + this.numElements + '}';
    }
}

