/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.List;
import org.apache.plc4x.java.api.listener.EventListener;
import org.apache.plc4x.java.api.listener.MessageExchangeListener;
import org.apache.plc4x.java.spi.generation.Message;

public class EventListenerMessageCodec
extends MessageToMessageCodec<Message, Message> {
    private final List<EventListener> listeners;

    public EventListenerMessageCodec(List<EventListener> listeners) {
        this.listeners = listeners;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, Message msg, List<Object> out) throws Exception {
        if (msg != null) {
            for (EventListener listener : this.listeners) {
                if (!(listener instanceof MessageExchangeListener)) continue;
                ((MessageExchangeListener)listener).sending(msg);
            }
        }
        out.add(msg);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, Message msg, List<Object> out) throws Exception {
        if (msg != null) {
            for (EventListener listener : this.listeners) {
                if (!(listener instanceof MessageExchangeListener)) continue;
                ((MessageExchangeListener)listener).received(msg);
            }
        }
        out.add(msg);
    }
}

