/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.connection;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.PlcDriver;
import org.apache.plc4x.java.api.authentication.PlcAuthentication;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.api.metadata.Option;
import org.apache.plc4x.java.api.metadata.OptionMetadata;
import org.apache.plc4x.java.api.metadata.PlcDriverMetadata;
import org.apache.plc4x.java.api.types.OptionType;
import org.apache.plc4x.java.api.value.PlcValueHandler;
import org.apache.plc4x.java.spi.configuration.ConfigurationFactory;
import org.apache.plc4x.java.spi.configuration.PlcConfiguration;
import org.apache.plc4x.java.spi.configuration.PlcConnectionConfiguration;
import org.apache.plc4x.java.spi.configuration.PlcTransportConfiguration;
import org.apache.plc4x.java.spi.configuration.annotations.ComplexConfigurationParameter;
import org.apache.plc4x.java.spi.configuration.annotations.ConfigurationParameter;
import org.apache.plc4x.java.spi.configuration.annotations.Description;
import org.apache.plc4x.java.spi.configuration.annotations.ParameterConverter;
import org.apache.plc4x.java.spi.configuration.annotations.Required;
import org.apache.plc4x.java.spi.configuration.annotations.defaults.BooleanDefaultValue;
import org.apache.plc4x.java.spi.configuration.annotations.defaults.DoubleDefaultValue;
import org.apache.plc4x.java.spi.configuration.annotations.defaults.FloatDefaultValue;
import org.apache.plc4x.java.spi.configuration.annotations.defaults.IntDefaultValue;
import org.apache.plc4x.java.spi.configuration.annotations.defaults.LongDefaultValue;
import org.apache.plc4x.java.spi.configuration.annotations.defaults.StringDefaultValue;
import org.apache.plc4x.java.spi.connection.ChannelFactory;
import org.apache.plc4x.java.spi.connection.DefaultNettyPlcConnection;
import org.apache.plc4x.java.spi.connection.PlcTagHandler;
import org.apache.plc4x.java.spi.connection.ProtocolStackConfigurer;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.metadata.DefaultOption;
import org.apache.plc4x.java.spi.metadata.DefaultOptionMetadata;
import org.apache.plc4x.java.spi.optimizer.BaseOptimizer;
import org.apache.plc4x.java.spi.transport.Transport;

public abstract class GeneratedDriverBase<BASE_PACKET extends Message>
implements PlcDriver {
    public static final String PROPERTY_PLC4X_FORCE_FIRE_DISCOVER_EVENT = "PLC4X_FORCE_FIRE_DISCOVER_EVENT";
    public static final String PROPERTY_PLC4X_FORCE_AWAIT_SETUP_COMPLETE = "PLC4X_FORCE_AWAIT_SETUP_COMPLETE";
    public static final String PROPERTY_PLC4X_FORCE_AWAIT_DISCONNECT_COMPLETE = "PLC4X_FORCE_AWAIT_DISCONNECT_COMPLETE";
    public static final String PROPERTY_PLC4X_FORCE_AWAIT_DISCOVER_COMPLETE = "PLC4X_FORCE_AWAIT_DISCOVER_COMPLETE";
    public static final Pattern URI_PATTERN = Pattern.compile("^(?<protocolCode>[a-z0-9\\-]*)(:(?<transportCode>[a-z0-9]*))?://(?<transportConfig>[^?]*)(\\?(?<paramString>.*))?");

    protected abstract Class<? extends PlcConnectionConfiguration> getConfigurationClass();

    protected Optional<Class<? extends PlcTransportConfiguration>> getTransportConfigurationClass(String transportCode) {
        return Optional.empty();
    }

    protected Optional<String> getDefaultTransportCode() {
        return Optional.empty();
    }

    protected List<String> getSupportedTransportCodes() {
        return Collections.emptyList();
    }

    @Override
    public PlcDriverMetadata getMetadata() {
        return new PlcDriverMetadata(){

            @Override
            public Optional<String> getDefaultTransportCode() {
                return GeneratedDriverBase.this.getDefaultTransportCode();
            }

            @Override
            public List<String> getSupportedTransportCodes() {
                List<String> supportedTransportCodes = GeneratedDriverBase.this.getSupportedTransportCodes();
                if (supportedTransportCodes.isEmpty() && this.getDefaultTransportCode().isPresent()) {
                    return Collections.singletonList(this.getDefaultTransportCode().get());
                }
                return GeneratedDriverBase.this.getSupportedTransportCodes();
            }

            @Override
            public Optional<OptionMetadata> getProtocolConfigurationOptionMetadata() {
                Class<PlcConnectionConfiguration> clazz = GeneratedDriverBase.this.getConfigurationClass();
                if (clazz == null) {
                    return Optional.empty();
                }
                List<Option> options = this.getOptions(clazz);
                return Optional.of(new DefaultOptionMetadata(options));
            }

            @Override
            public Optional<OptionMetadata> getTransportConfigurationOptionMetadata(String transportCode) {
                Optional<Class<PlcTransportConfiguration>> clazzOption = GeneratedDriverBase.this.resolveTransportConfigurationClass(transportCode);
                if (clazzOption.isEmpty()) {
                    return Optional.empty();
                }
                Class<PlcTransportConfiguration> clazz = clazzOption.get();
                List<Option> options = this.getOptions(clazz);
                return Optional.of(new DefaultOptionMetadata(options));
            }

            private List<Option> getOptions(Class<? extends PlcConfiguration> clazz) {
                return GeneratedDriverBase.this.getAllFields(clazz).stream().map(this::optionsForField).flatMap(Collection::stream).filter(Objects::nonNull).map(Option.class::cast).collect(Collectors.toList());
            }

            private List<DefaultOption> optionsForField(Field field) {
                StringDefaultValue stringDefaultValueAnnotation;
                LongDefaultValue longDefaultValueAnnotation;
                IntDefaultValue intDefaultValueAnnotation;
                FloatDefaultValue floatDefaultValueAnnotation;
                DoubleDefaultValue doubleDefaultValueAnnotation;
                OptionType type;
                ComplexConfigurationParameter complexConfigurationParameterAnnotation = field.getAnnotation(ComplexConfigurationParameter.class);
                if (complexConfigurationParameterAnnotation != null) {
                    String prefix = complexConfigurationParameterAnnotation.prefix();
                    if (PlcConfiguration.class.isAssignableFrom(field.getType())) {
                        return this.getOptions(field.getType()).stream().map(option -> new DefaultOption(String.valueOf(prefix) + "." + option.getKey(), option.getType(), option.getDescription(), option.isRequired(), option.getDefaultValue().orElse(null))).collect(Collectors.toList());
                    }
                }
                String key = null;
                ConfigurationParameter configurationParameterAnnotation = field.getAnnotation(ConfigurationParameter.class);
                if (configurationParameterAnnotation != null && (key = configurationParameterAnnotation.value()).isEmpty()) {
                    key = field.getName();
                }
                if (key == null) {
                    return Collections.emptyList();
                }
                String description = "";
                Description descriptionAnnotation = field.getAnnotation(Description.class);
                if (descriptionAnnotation != null) {
                    description = descriptionAnnotation.value();
                }
                boolean required = false;
                Required requiredAnnotation = field.getAnnotation(Required.class);
                if (requiredAnnotation != null) {
                    required = true;
                }
                switch (field.getType().getSimpleName()) {
                    case "boolean": 
                    case "Boolean": {
                        type = OptionType.BOOLEAN;
                        break;
                    }
                    case "Float": 
                    case "float": {
                        type = OptionType.FLOAT;
                        break;
                    }
                    case "double": 
                    case "Double": {
                        type = OptionType.DOUBLE;
                        break;
                    }
                    case "Integer": 
                    case "int": {
                        type = OptionType.INT;
                        break;
                    }
                    case "Long": 
                    case "long": {
                        type = OptionType.LONG;
                        break;
                    }
                    case "String": {
                        type = OptionType.STRING;
                        break;
                    }
                    default: {
                        ParameterConverter parameterConverterAnnotation = field.getAnnotation(ParameterConverter.class);
                        type = parameterConverterAnnotation != null ? OptionType.STRING : OptionType.STRUCT;
                    }
                }
                Object defaultValue = null;
                BooleanDefaultValue booleanDefaultValueAnnotation = field.getAnnotation(BooleanDefaultValue.class);
                if (booleanDefaultValueAnnotation != null) {
                    defaultValue = booleanDefaultValueAnnotation.value();
                }
                if ((doubleDefaultValueAnnotation = field.getAnnotation(DoubleDefaultValue.class)) != null) {
                    defaultValue = doubleDefaultValueAnnotation.value();
                }
                if ((floatDefaultValueAnnotation = field.getAnnotation(FloatDefaultValue.class)) != null) {
                    defaultValue = Float.valueOf(floatDefaultValueAnnotation.value());
                }
                if ((intDefaultValueAnnotation = field.getAnnotation(IntDefaultValue.class)) != null) {
                    defaultValue = intDefaultValueAnnotation.value();
                }
                if ((longDefaultValueAnnotation = field.getAnnotation(LongDefaultValue.class)) != null) {
                    defaultValue = longDefaultValueAnnotation.value();
                }
                if ((stringDefaultValueAnnotation = field.getAnnotation(StringDefaultValue.class)) != null) {
                    type = OptionType.STRING;
                    defaultValue = stringDefaultValueAnnotation.value();
                }
                return Collections.singletonList(new DefaultOption(key, type, description, required, defaultValue));
            }

            @Override
            public boolean isDiscoverySupported() {
                return GeneratedDriverBase.this.canBrowse();
            }
        };
    }

    protected boolean canPing() {
        return false;
    }

    protected boolean canRead() {
        return false;
    }

    protected boolean canWrite() {
        return false;
    }

    protected boolean canSubscribe() {
        return false;
    }

    protected boolean canBrowse() {
        return false;
    }

    protected boolean fireDiscoverEvent() {
        return false;
    }

    protected boolean awaitSetupComplete() {
        return true;
    }

    protected boolean awaitDisconnectComplete() {
        return false;
    }

    protected boolean awaitDiscoverComplete() {
        return false;
    }

    protected BaseOptimizer getOptimizer() {
        return null;
    }

    protected abstract PlcTagHandler getTagHandler();

    protected abstract PlcValueHandler getValueHandler();

    protected abstract ProtocolStackConfigurer<BASE_PACKET> getStackConfigurer();

    protected ProtocolStackConfigurer<BASE_PACKET> getStackConfigurer(Transport transport) {
        return this.getStackConfigurer();
    }

    protected void initializePipeline(ChannelFactory channelFactory) {
    }

    @Override
    public PlcConnection getConnection(String connectionString) throws PlcConnectionException {
        return this.getConnection(connectionString, null);
    }

    @Override
    public PlcConnection getConnection(String connectionString, PlcAuthentication authentication) throws PlcConnectionException {
        ConfigurationFactory configurationFactory = new ConfigurationFactory();
        Matcher matcher = URI_PATTERN.matcher(connectionString);
        if (!matcher.matches()) {
            throw new PlcConnectionException("Connection string doesn't match the format '{protocol-code}:({transport-code})?//{transport-config}(?{parameter-string)?'");
        }
        String protocolCode = matcher.group("protocolCode");
        String transportCodeMatch = matcher.group("transportCode");
        if (transportCodeMatch == null && this.getMetadata().getDefaultTransportCode().isEmpty()) {
            throw new PlcConnectionException("This driver has no default transport and no transport code was provided.");
        }
        String transportCode = transportCodeMatch != null ? transportCodeMatch : this.getMetadata().getDefaultTransportCode().get();
        String transportConfig = matcher.group("transportConfig");
        String paramString = matcher.group("paramString");
        if (!protocolCode.equals(this.getProtocolCode())) {
            throw new PlcConnectionException("This driver is not suited to handle this connection string");
        }
        PlcConnectionConfiguration configuration = configurationFactory.createConfiguration(this.getConfigurationClass(), protocolCode, transportCode, transportConfig, paramString);
        if (configuration == null) {
            throw new PlcConnectionException("Unsupported configuration");
        }
        Transport transport = null;
        ServiceLoader<Transport> transportLoader = ServiceLoader.load(Transport.class, Thread.currentThread().getContextClassLoader());
        for (Transport curTransport : transportLoader) {
            if (!curTransport.getTransportCode().equals(transportCode)) continue;
            transport = curTransport;
            break;
        }
        if (transport == null) {
            throw new PlcConnectionException("Unsupported transport " + transportCode);
        }
        Class<? extends PlcTransportConfiguration> transportConfigurationType = transport.getTransportConfigType();
        if (this.getTransportConfigurationClass(transportCode).isPresent()) {
            transportConfigurationType = this.getTransportConfigurationClass(transportCode).get();
        }
        PlcTransportConfiguration plcTransportConfiguration = configurationFactory.createTransportConfiguration(transportConfigurationType, protocolCode, transportCode, transportConfig, paramString);
        ConfigurationFactory.configure(plcTransportConfiguration, transport);
        ChannelFactory channelFactory = transport.createChannelFactory(transportConfig);
        if (channelFactory == null) {
            throw new PlcConnectionException("Unable to get channel factory from url " + transportConfig);
        }
        ConfigurationFactory.configure(configuration, channelFactory);
        this.initializePipeline(channelFactory);
        boolean fireDiscoverEvent = this.fireDiscoverEvent();
        if (System.getProperty(PROPERTY_PLC4X_FORCE_FIRE_DISCOVER_EVENT) != null) {
            fireDiscoverEvent = Boolean.parseBoolean(System.getProperty(PROPERTY_PLC4X_FORCE_FIRE_DISCOVER_EVENT));
        }
        boolean awaitSetupComplete = this.awaitSetupComplete();
        if (System.getProperty(PROPERTY_PLC4X_FORCE_AWAIT_SETUP_COMPLETE) != null) {
            awaitSetupComplete = Boolean.parseBoolean(System.getProperty(PROPERTY_PLC4X_FORCE_AWAIT_SETUP_COMPLETE));
        }
        boolean awaitDisconnectComplete = this.awaitDisconnectComplete();
        if (System.getProperty(PROPERTY_PLC4X_FORCE_AWAIT_DISCONNECT_COMPLETE) != null) {
            awaitDisconnectComplete = Boolean.parseBoolean(System.getProperty(PROPERTY_PLC4X_FORCE_AWAIT_DISCONNECT_COMPLETE));
        }
        boolean awaitDiscoverComplete = this.awaitDiscoverComplete();
        if (System.getProperty(PROPERTY_PLC4X_FORCE_AWAIT_DISCOVER_COMPLETE) != null) {
            awaitDiscoverComplete = Boolean.parseBoolean(System.getProperty(PROPERTY_PLC4X_FORCE_AWAIT_DISCOVER_COMPLETE));
        }
        return new DefaultNettyPlcConnection(this.canPing(), this.canRead(), this.canWrite(), this.canSubscribe(), this.canBrowse(), this.getTagHandler(), this.getValueHandler(), configuration, channelFactory, fireDiscoverEvent, awaitSetupComplete, awaitDisconnectComplete, awaitDiscoverComplete, this.getStackConfigurer(transport), this.getOptimizer(), authentication);
    }

    protected Optional<Class<? extends PlcTransportConfiguration>> resolveTransportConfigurationClass(String transportCode) {
        if (this.getTransportConfigurationClass(transportCode).isPresent()) {
            return Optional.of(this.getTransportConfigurationClass(transportCode).get());
        }
        Transport transport = null;
        ServiceLoader<Transport> transportLoader = ServiceLoader.load(Transport.class, Thread.currentThread().getContextClassLoader());
        for (Transport curTransport : transportLoader) {
            if (!curTransport.getTransportCode().equals(transportCode)) continue;
            transport = curTransport;
            break;
        }
        if (transport == null) {
            return Optional.empty();
        }
        Class<? extends PlcTransportConfiguration> transportConfigurationType = transport.getTransportConfigType();
        return Optional.of(transportConfigurationType);
    }

    protected List<Field> getAllFields(Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(type.getDeclaredFields()));
        if (type.getSuperclass() != null) {
            fields.addAll(this.getAllFields(type.getSuperclass()));
        }
        return fields;
    }
}

