/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.generation;

import io.vavr.control.Either;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;
import org.apache.plc4x.java.spi.generation.BufferCommons;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.utils.Serializable;
import org.apache.plc4x.java.spi.utils.ascii.AsciiBox;
import org.apache.plc4x.java.spi.utils.ascii.AsciiBoxWriter;
import org.apache.plc4x.java.spi.utils.hex.Hex;

public class WriteBufferBoxBased
implements WriteBuffer,
BufferCommons {
    private final Deque<Either<AsciiBox, Deque<AsciiBox>>> boxes = new LinkedList<Either<AsciiBox, Deque<AsciiBox>>>();
    private final AsciiBoxWriter asciiBoxWriter;
    private final AsciiBoxWriter asciiBoxWriterLight;
    private final int desiredWidth = 120;
    private final boolean mergeSingleBoxes;
    private final boolean omitEmptyBoxes;
    private int currentWidth = 118;
    private int pos = 1;

    public WriteBufferBoxBased() {
        this(false, false);
    }

    public WriteBufferBoxBased(boolean mergeSingleBoxes, boolean omitEmptyBoxes) {
        this(AsciiBoxWriter.DEFAULT, AsciiBoxWriter.LIGHT, mergeSingleBoxes, omitEmptyBoxes);
    }

    private WriteBufferBoxBased(AsciiBoxWriter asciiBoxWriter, AsciiBoxWriter asciiBoxWriterLight, boolean mergeSingleBoxes, boolean omitEmptyBoxes) {
        this.asciiBoxWriter = asciiBoxWriter;
        this.asciiBoxWriterLight = asciiBoxWriterLight;
        this.mergeSingleBoxes = mergeSingleBoxes;
        this.omitEmptyBoxes = omitEmptyBoxes;
    }

    @Override
    public ByteOrder getByteOrder() {
        return ByteOrder.BIG_ENDIAN;
    }

    @Override
    public void setByteOrder(ByteOrder byteOrder) {
    }

    @Override
    public int getPos() {
        return this.pos / 8;
    }

    @Override
    public void pushContext(String logicalName, WithWriterArgs ... writerArgs) {
        this.currentWidth -= 2;
        this.boxes.offerLast(Either.right(new LinkedList()));
    }

    @Override
    public void writeBit(String logicalName, boolean value, WithWriterArgs ... writerArgs) throws SerializationException {
        String additionalStringRepresentation = this.extractAdditionalStringRepresentation(writerArgs).map(s -> " " + s).orElse("");
        this.boxes.offerLast(Either.left(this.asciiBoxWriter.boxString(logicalName, String.format("b%d %b%s", value ? 1 : 0, value, additionalStringRepresentation), 0)));
        this.move(1);
    }

    @Override
    public void writeByte(String logicalName, byte value, WithWriterArgs ... writerArgs) throws SerializationException {
        String additionalStringRepresentation = this.extractAdditionalStringRepresentation(writerArgs).map(s -> " " + s).orElse("");
        this.boxes.offerLast(Either.left(this.asciiBoxWriter.boxString(logicalName, String.format("0x%02x '%c'%s", value, value < 32 || value > 126 ? 46 : (int)value, additionalStringRepresentation), 0)));
        this.move(8);
    }

    @Override
    public void writeByteArray(String logicalName, byte[] bytes, WithWriterArgs ... writerArgs) throws SerializationException {
        String additionalStringRepresentation = this.extractAdditionalStringRepresentation(writerArgs).map(s -> " " + s).orElse("");
        if (StringUtils.isNotBlank(additionalStringRepresentation)) {
            additionalStringRepresentation = String.valueOf(additionalStringRepresentation) + "\n";
        }
        this.boxes.offerLast(Either.left(this.asciiBoxWriter.boxString(logicalName, String.format("%s%s", Hex.dump(bytes), additionalStringRepresentation), 0)));
        this.move(8 * bytes.length);
    }

    @Override
    public void writeUnsignedByte(String logicalName, int bitLength, byte value, WithWriterArgs ... writerArgs) throws SerializationException {
        String additionalStringRepresentation = this.extractAdditionalStringRepresentation(writerArgs).map(s -> " " + s).orElse("");
        this.boxes.offerLast(Either.left(this.asciiBoxWriter.boxString(logicalName, String.format("0x%0" + Math.max(bitLength / 4, 1) + "x %d%s", value, value, additionalStringRepresentation), 0)));
        this.move(bitLength);
    }

    @Override
    public void writeUnsignedShort(String logicalName, int bitLength, short value, WithWriterArgs ... writerArgs) throws SerializationException {
        String additionalStringRepresentation = this.extractAdditionalStringRepresentation(writerArgs).map(s -> " " + s).orElse("");
        this.boxes.offerLast(Either.left(this.asciiBoxWriter.boxString(logicalName, String.format("0x%0" + Math.max(bitLength / 4, 1) + "x %d%s", value, value, additionalStringRepresentation), 0)));
        this.move(bitLength);
    }

    @Override
    public void writeUnsignedInt(String logicalName, int bitLength, int value, WithWriterArgs ... writerArgs) throws SerializationException {
        String additionalStringRepresentation = this.extractAdditionalStringRepresentation(writerArgs).map(s -> " " + s).orElse("");
        this.boxes.offerLast(Either.left(this.asciiBoxWriter.boxString(logicalName, String.format("0x%0" + Math.max(bitLength / 4, 1) + "x %d%s", value, value, additionalStringRepresentation), 0)));
        this.move(bitLength);
    }

    @Override
    public void writeUnsignedLong(String logicalName, int bitLength, long value, WithWriterArgs ... writerArgs) throws SerializationException {
        String additionalStringRepresentation = this.extractAdditionalStringRepresentation(writerArgs).map(s -> " " + s).orElse("");
        this.boxes.offerLast(Either.left(this.asciiBoxWriter.boxString(logicalName, String.format("0x%0" + Math.max(bitLength / 4, 1) + "x %d%s", value, value, additionalStringRepresentation), 0)));
        this.move(bitLength);
    }

    @Override
    public void writeUnsignedBigInteger(String logicalName, int bitLength, BigInteger value, WithWriterArgs ... writerArgs) throws SerializationException {
        String additionalStringRepresentation = this.extractAdditionalStringRepresentation(writerArgs).map(s -> " " + s).orElse("");
        this.boxes.offerLast(Either.left(this.asciiBoxWriter.boxString(logicalName, String.format("0x%0" + Math.max(bitLength / 4, 1) + "x %d%s", value, value, additionalStringRepresentation), 0)));
        this.move(bitLength);
    }

    @Override
    public void writeSignedByte(String logicalName, int bitLength, byte value, WithWriterArgs ... writerArgs) throws SerializationException {
        String additionalStringRepresentation = this.extractAdditionalStringRepresentation(writerArgs).map(s -> " " + s).orElse("");
        this.boxes.offerLast(Either.left(this.asciiBoxWriter.boxString(logicalName, String.format("0x%0" + Math.max(bitLength / 4, 1) + "x %d%s", value, value, additionalStringRepresentation), 0)));
        this.move(bitLength);
    }

    @Override
    public void writeShort(String logicalName, int bitLength, short value, WithWriterArgs ... writerArgs) throws SerializationException {
        String additionalStringRepresentation = this.extractAdditionalStringRepresentation(writerArgs).map(s -> " " + s).orElse("");
        this.boxes.offerLast(Either.left(this.asciiBoxWriter.boxString(logicalName, String.format("0x%0" + Math.max(bitLength / 4, 1) + "x %d%s", value, value, additionalStringRepresentation), 0)));
        this.move(bitLength);
    }

    @Override
    public void writeInt(String logicalName, int bitLength, int value, WithWriterArgs ... writerArgs) throws SerializationException {
        String additionalStringRepresentation = this.extractAdditionalStringRepresentation(writerArgs).map(s -> " " + s).orElse("");
        this.boxes.offerLast(Either.left(this.asciiBoxWriter.boxString(logicalName, String.format("0x%0" + Math.max(bitLength / 4, 1) + "x %d%s", value, value, additionalStringRepresentation), 0)));
        this.move(bitLength);
    }

    @Override
    public void writeLong(String logicalName, int bitLength, long value, WithWriterArgs ... writerArgs) throws SerializationException {
        String additionalStringRepresentation = this.extractAdditionalStringRepresentation(writerArgs).map(s -> " " + s).orElse("");
        this.boxes.offerLast(Either.left(this.asciiBoxWriter.boxString(logicalName, String.format("0x%0" + Math.max(bitLength / 4, 1) + "x %d%s", value, value, additionalStringRepresentation), 0)));
        this.move(bitLength);
    }

    @Override
    public void writeBigInteger(String logicalName, int bitLength, BigInteger value, WithWriterArgs ... writerArgs) throws SerializationException {
        String additionalStringRepresentation = this.extractAdditionalStringRepresentation(writerArgs).map(s -> " " + s).orElse("");
        this.boxes.offerLast(Either.left(this.asciiBoxWriter.boxString(logicalName, String.format("0x%0" + Math.max(bitLength / 4, 1) + "x %d%s", value, value, additionalStringRepresentation), 0)));
        this.move(bitLength);
    }

    @Override
    public void writeFloat(String logicalName, int bitLength, float value, WithWriterArgs ... writerArgs) throws SerializationException {
        String additionalStringRepresentation = this.extractAdditionalStringRepresentation(writerArgs).map(s -> " " + s).orElse("");
        this.boxes.offerLast(Either.left(this.asciiBoxWriter.boxString(logicalName, String.format("0x%0" + Math.max(bitLength / 4, 1) + "x %f%s", Float.valueOf(value).longValue(), Float.valueOf(value), additionalStringRepresentation), 0)));
        this.move(bitLength);
    }

    @Override
    public void writeDouble(String logicalName, int bitLength, double value, WithWriterArgs ... writerArgs) throws SerializationException {
        String additionalStringRepresentation = this.extractAdditionalStringRepresentation(writerArgs).map(s -> " " + s).orElse("");
        this.boxes.offerLast(Either.left(this.asciiBoxWriter.boxString(logicalName, String.format("0x%0" + Math.max(bitLength / 4, 1) + "x %f%s", Double.valueOf(value).longValue(), value, additionalStringRepresentation), 0)));
        this.move(bitLength);
    }

    @Override
    public void writeBigDecimal(String logicalName, int bitLength, BigDecimal value, WithWriterArgs ... writerArgs) throws SerializationException {
        String additionalStringRepresentation = this.extractAdditionalStringRepresentation(writerArgs).map(s -> " " + s).orElse("");
        this.boxes.offerLast(Either.left(this.asciiBoxWriter.boxString(logicalName, String.format("0x%0" + Math.max(bitLength / 4, 1) + "x %d%s", value, value, additionalStringRepresentation), 0)));
        this.move(bitLength);
    }

    @Override
    public void writeString(String logicalName, int bitLength, String value, WithWriterArgs ... writerArgs) throws SerializationException {
        String additionalStringRepresentation = this.extractAdditionalStringRepresentation(writerArgs).map(s -> " " + s).orElse("");
        this.boxes.offerLast(Either.left(this.asciiBoxWriter.boxString(logicalName, String.format("%s%s", value, additionalStringRepresentation), 0)));
        this.move(bitLength);
    }

    @Override
    public void writeVirtual(String logicalName, Object value, WithWriterArgs ... writerArgs) throws SerializationException {
        AsciiBox virtualBox;
        String additionalStringRepresentation = this.extractAdditionalStringRepresentation(writerArgs).map(s -> " " + s).orElse("");
        if (value instanceof String) {
            virtualBox = this.asciiBoxWriterLight.boxString(logicalName, String.format("%s%s", value, additionalStringRepresentation), 0);
        } else if (value instanceof Float) {
            Float number = (Float)value;
            virtualBox = this.asciiBoxWriterLight.boxString(logicalName, String.format("%f%s", number, additionalStringRepresentation), 0);
        } else if (value instanceof Double) {
            Double number = (Double)value;
            virtualBox = this.asciiBoxWriterLight.boxString(logicalName, String.format("%f%s", number, additionalStringRepresentation), 0);
        } else if (value instanceof Number) {
            Number number = (Number)value;
            virtualBox = this.asciiBoxWriterLight.boxString(logicalName, String.format("0x%x %d%s", number, number, additionalStringRepresentation), 0);
        } else if (value instanceof Boolean) {
            virtualBox = this.asciiBoxWriterLight.boxString(logicalName, String.format("b%d %b%s", (Boolean)value != false ? 1 : 0, value, additionalStringRepresentation), 0);
        } else if (value instanceof Enum) {
            Enum enumValue = (Enum)value;
            virtualBox = this.asciiBoxWriterLight.boxString(logicalName, String.format("%s%s", enumValue.name(), additionalStringRepresentation), 0);
        } else if (value instanceof Serializable) {
            Serializable serializable = (Serializable)value;
            try {
                WriteBufferBoxBased writeBuffer = new WriteBufferBoxBased(true, true);
                serializable.serialize(writeBuffer);
                virtualBox = this.asciiBoxWriterLight.boxBox(logicalName, writeBuffer.getBox(), 0);
            }
            catch (SerializationException e) {
                virtualBox = this.asciiBoxWriterLight.boxString(logicalName, e.getMessage(), 0);
            }
        } else {
            virtualBox = this.asciiBoxWriterLight.boxString(logicalName, "un-renderable", 0);
        }
        this.boxes.offerLast(Either.left(virtualBox));
    }

    @Override
    public void popContext(String logicalName, WithWriterArgs ... writerArgs) {
        this.currentWidth += 2;
        LinkedList<AsciiBox> finalBoxes = new LinkedList<AsciiBox>();
        Either<AsciiBox, Deque<AsciiBox>> back = this.boxes.pollLast();
        while (back != null) {
            if (!back.isLeft()) {
                Deque<AsciiBox> asciiBoxes = back.get();
                LinkedList<AsciiBox> reversedList = new LinkedList<AsciiBox>(asciiBoxes);
                Collections.reverse(reversedList);
                for (AsciiBox box : asciiBoxes) {
                    finalBoxes.offerFirst(box);
                }
                break;
            }
            AsciiBox asciiBox = back.getLeft();
            if (!this.omitEmptyBoxes || !asciiBox.isEmpty()) {
                finalBoxes.offerFirst(asciiBox);
            }
            back = this.boxes.pollLast();
        }
        if (this.mergeSingleBoxes && finalBoxes.size() == 1) {
            AsciiBox onlyChild = (AsciiBox)finalBoxes.remove();
            String childName = onlyChild.getBoxName();
            onlyChild = onlyChild.changeBoxName(String.valueOf(logicalName) + "/" + childName);
            if (this.omitEmptyBoxes && onlyChild.isEmpty()) {
                return;
            }
            this.boxes.offerLast(Either.left(onlyChild));
            return;
        }
        AsciiBox asciiBox = this.asciiBoxWriter.boxBox(logicalName, this.asciiBoxWriter.alignBoxes(finalBoxes, this.currentWidth), 0);
        if (this.omitEmptyBoxes && asciiBox.isEmpty()) {
            return;
        }
        this.boxes.offerLast(Either.left(asciiBox));
    }

    public AsciiBox getBox() {
        return this.boxes.peek().getLeft();
    }

    private void move(int bits) {
        this.pos += bits;
    }
}

