/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.generation;

import java.io.ByteArrayOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Optional;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import org.apache.commons.lang3.StringUtils;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.spi.generation.BufferCommons;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;

public class WriteBufferXmlBased
implements WriteBuffer,
BufferCommons {
    private final Deque<String> stack;
    private final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    private final XMLEventFactory xmlEventFactory;
    private final XMLEventWriter xmlEventWriter;
    private int pos = 1;
    private int depth = 0;

    public WriteBufferXmlBased() {
        XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
        this.xmlEventFactory = XMLEventFactory.newInstance();
        try {
            this.xmlEventWriter = xmlOutputFactory.createXMLEventWriter(this.byteArrayOutputStream);
        }
        catch (XMLStreamException e) {
            throw new PlcRuntimeException(e);
        }
        this.stack = new ArrayDeque<String>();
    }

    @Override
    public ByteOrder getByteOrder() {
        return ByteOrder.BIG_ENDIAN;
    }

    @Override
    public void setByteOrder(ByteOrder byteOrder) {
    }

    @Override
    public int getPos() {
        return this.pos / 8;
    }

    @Override
    public void pushContext(String logicalName, WithWriterArgs ... writerArgs) {
        try {
            this.indent();
            ++this.depth;
            StartElement startElement = this.xmlEventFactory.createStartElement("", "", logicalName);
            this.xmlEventWriter.add(startElement);
            if (this.isToBeRenderedAsList(writerArgs)) {
                Attribute isListAttribute = this.xmlEventFactory.createAttribute("isList", "true");
                this.xmlEventWriter.add(isListAttribute);
            }
            this.newLine();
        }
        catch (XMLStreamException e) {
            throw new PlcRuntimeException(e);
        }
        this.stack.push(logicalName);
    }

    @Override
    public void writeBit(String logicalName, boolean value, WithWriterArgs ... writerArgs) throws SerializationException {
        String dataType = "bit";
        int bitLength = 1;
        String data = Boolean.toString(value);
        this.createAndAppend(logicalName, dataType, bitLength, data, writerArgs);
        this.move(1);
    }

    @Override
    public void writeByte(String logicalName, byte value, WithWriterArgs ... writerArgs) throws SerializationException {
        this.createAndAppend(logicalName, "byte", 8, String.format("0x%02x", value), writerArgs);
        this.move(8);
    }

    @Override
    public void writeByteArray(String logicalName, byte[] bytes, WithWriterArgs ... writerArgs) throws SerializationException {
        StringBuilder hexString = new StringBuilder("0x");
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte aByte = byArray[n2];
            hexString.append(String.format("%02x", aByte));
            ++n2;
        }
        this.createAndAppend(logicalName, "byte", bytes.length * 8, hexString.toString(), writerArgs);
        this.move(8 * bytes.length);
    }

    @Override
    public void writeUnsignedByte(String logicalName, int bitLength, byte value, WithWriterArgs ... writerArgs) throws SerializationException {
        this.createAndAppend(logicalName, "uint", bitLength, Byte.toString(value), writerArgs);
        this.move(bitLength);
    }

    @Override
    public void writeUnsignedShort(String logicalName, int bitLength, short value, WithWriterArgs ... writerArgs) throws SerializationException {
        this.createAndAppend(logicalName, "uint", bitLength, Short.toString(value), writerArgs);
        this.move(bitLength);
    }

    @Override
    public void writeUnsignedInt(String logicalName, int bitLength, int value, WithWriterArgs ... writerArgs) throws SerializationException {
        this.createAndAppend(logicalName, "uint", bitLength, Integer.toString(value), writerArgs);
        this.move(bitLength);
    }

    @Override
    public void writeUnsignedLong(String logicalName, int bitLength, long value, WithWriterArgs ... writerArgs) throws SerializationException {
        this.createAndAppend(logicalName, "uint", bitLength, Long.toString(value), writerArgs);
        this.move(bitLength);
    }

    @Override
    public void writeUnsignedBigInteger(String logicalName, int bitLength, BigInteger value, WithWriterArgs ... writerArgs) throws SerializationException {
        this.createAndAppend(logicalName, "uint", bitLength, value.toString(), writerArgs);
        this.move(bitLength);
    }

    @Override
    public void writeSignedByte(String logicalName, int bitLength, byte value, WithWriterArgs ... writerArgs) throws SerializationException {
        this.createAndAppend(logicalName, "int", bitLength, Byte.toString(value), writerArgs);
        this.move(bitLength);
    }

    @Override
    public void writeShort(String logicalName, int bitLength, short value, WithWriterArgs ... writerArgs) throws SerializationException {
        this.createAndAppend(logicalName, "int", bitLength, Short.toString(value), writerArgs);
        this.move(bitLength);
    }

    @Override
    public void writeInt(String logicalName, int bitLength, int value, WithWriterArgs ... writerArgs) throws SerializationException {
        this.createAndAppend(logicalName, "int", bitLength, Integer.toString(value), writerArgs);
        this.move(bitLength);
    }

    @Override
    public void writeLong(String logicalName, int bitLength, long value, WithWriterArgs ... writerArgs) throws SerializationException {
        this.createAndAppend(logicalName, "int", bitLength, Long.toString(value), writerArgs);
        this.move(bitLength);
    }

    @Override
    public void writeBigInteger(String logicalName, int bitLength, BigInteger value, WithWriterArgs ... writerArgs) throws SerializationException {
        this.createAndAppend(logicalName, "int", bitLength, value.toString(), writerArgs);
        this.move(bitLength);
    }

    @Override
    public void writeFloat(String logicalName, int bitLength, float value, WithWriterArgs ... writerArgs) throws SerializationException {
        this.createAndAppend(logicalName, "float", bitLength, Float.toString(value), writerArgs);
        this.move(bitLength);
    }

    @Override
    public void writeDouble(String logicalName, int bitLength, double value, WithWriterArgs ... writerArgs) throws SerializationException {
        this.createAndAppend(logicalName, "float", bitLength, Double.toString(value), writerArgs);
        this.move(bitLength);
    }

    @Override
    public void writeBigDecimal(String logicalName, int bitLength, BigDecimal value, WithWriterArgs ... writerArgs) throws SerializationException {
        this.createAndAppend(logicalName, "float", bitLength, value.toString(), writerArgs);
        this.move(bitLength);
    }

    @Override
    public void writeString(String logicalName, int bitLength, String value, WithWriterArgs ... writerArgs) throws SerializationException {
        String encoding = this.extractEncoding(writerArgs).orElse("UTF-8");
        String cleanedUpString = StringUtils.trimToEmpty(value).replaceAll("[^\t\r\n -\ud7ff\ue000-\ufffd\ud800\udc00-\udbff\udfff]", "");
        this.createAndAppend(logicalName, "string", bitLength, cleanedUpString, encoding, writerArgs);
        this.move(bitLength);
    }

    @Override
    public void popContext(String logicalName, WithWriterArgs ... writerArgs) {
        try {
            --this.depth;
            this.indent();
            EndElement endElement = this.xmlEventFactory.createEndElement("", "", logicalName);
            this.xmlEventWriter.add(endElement);
            if (this.depth != 0) {
                this.newLine();
            }
        }
        catch (XMLStreamException e) {
            throw new PlcRuntimeException(e);
        }
        String context = this.stack.pop();
        if (!context.equals(logicalName)) {
            throw new PlcRuntimeException("Unexpected pop context '" + context + '\'' + ". Expected '" + logicalName + '\'');
        }
        if (this.stack.isEmpty()) {
            try {
                this.xmlEventWriter.close();
            }
            catch (XMLStreamException e) {
                throw new PlcRuntimeException(e);
            }
        }
    }

    public String getXmlString() {
        return this.byteArrayOutputStream.toString(StandardCharsets.UTF_8);
    }

    private void move(int bits) {
        this.pos += bits;
    }

    private void newLine() throws XMLStreamException {
        Characters newLine = this.xmlEventFactory.createCharacters("\n");
        this.xmlEventWriter.add(newLine);
    }

    private void indent() throws XMLStreamException {
        Characters indent = this.xmlEventFactory.createCharacters(StringUtils.repeat("  ", this.depth));
        this.xmlEventWriter.add(indent);
    }

    private void createAndAppend(String logicalName, String dataType, int bitLength, String data, WithWriterArgs ... writerArgs) {
        this.createAndAppend(logicalName, dataType, bitLength, data, (String)null, writerArgs);
    }

    private void createAndAppend(String logicalName, String dataType, int bitLength, String data, String encoding, WithWriterArgs ... writerArgs) {
        try {
            this.indent();
            StartElement startElement = this.xmlEventFactory.createStartElement("", "", this.sanitizeLogicalName(logicalName));
            this.xmlEventWriter.add(startElement);
            Attribute dataTypeAttribute = this.xmlEventFactory.createAttribute("dataType", dataType);
            this.xmlEventWriter.add(dataTypeAttribute);
            Attribute bitLengthAttribute = this.xmlEventFactory.createAttribute("bitLength", String.valueOf(bitLength));
            this.xmlEventWriter.add(bitLengthAttribute);
            Optional<String> additionalStringRepresentation = this.extractAdditionalStringRepresentation(writerArgs);
            if (additionalStringRepresentation.isPresent()) {
                Attribute additionalStringRepresentationAttribute = this.xmlEventFactory.createAttribute("stringRepresentation", additionalStringRepresentation.get());
                this.xmlEventWriter.add(additionalStringRepresentationAttribute);
            }
            if (encoding != null) {
                Attribute encodingAttribute = this.xmlEventFactory.createAttribute("encoding", encoding);
                this.xmlEventWriter.add(encodingAttribute);
            }
            Characters dataCharacters = this.xmlEventFactory.createCharacters(data);
            this.xmlEventWriter.add(dataCharacters);
            EndElement endElement = this.xmlEventFactory.createEndElement("", "", this.sanitizeLogicalName(logicalName));
            this.xmlEventWriter.add(endElement);
            this.newLine();
        }
        catch (XMLStreamException e) {
            throw new PlcRuntimeException(e);
        }
    }
}

