/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.internal;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.time.Duration;
import java.util.function.Consumer;
import org.apache.plc4x.java.api.authentication.PlcAuthentication;
import org.apache.plc4x.java.spi.ConversationContext;
import org.apache.plc4x.java.spi.configuration.PlcConnectionConfiguration;
import org.apache.plc4x.java.spi.events.ConnectedEvent;
import org.apache.plc4x.java.spi.events.DisconnectedEvent;
import org.apache.plc4x.java.spi.events.DiscoveredEvent;
import org.apache.plc4x.java.spi.internal.DefaultExpectRequestContext;
import org.apache.plc4x.java.spi.internal.DefaultSendRequestContext;
import org.apache.plc4x.java.spi.internal.HandlerRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConversationContext<T1>
implements ConversationContext<T1> {
    private final Logger logger = LoggerFactory.getLogger(DefaultConversationContext.class);
    private final Consumer<HandlerRegistration> handlerRegistrar;
    private final ChannelHandlerContext channelHandlerContext;
    private final PlcAuthentication authentication;
    private final boolean passive;

    public DefaultConversationContext(Consumer<HandlerRegistration> handlerRegistrar, ChannelHandlerContext channelHandlerContext, PlcAuthentication authentication, boolean passive) {
        this.handlerRegistrar = handlerRegistrar;
        this.channelHandlerContext = channelHandlerContext;
        this.authentication = authentication;
        this.passive = passive;
    }

    @Override
    public Channel getChannel() {
        return this.channelHandlerContext.channel();
    }

    @Override
    public PlcAuthentication getAuthentication() {
        return this.authentication;
    }

    @Override
    public boolean isPassive() {
        return this.passive;
    }

    @Override
    public void sendToWire(T1 msg) {
        this.logger.trace("Sending to wire {}", msg);
        this.channelHandlerContext.channel().writeAndFlush(msg).syncUninterruptibly();
    }

    @Override
    public void fireConnected() {
        this.logger.trace("Firing Connected!");
        this.channelHandlerContext.pipeline().fireUserEventTriggered(new ConnectedEvent());
    }

    @Override
    public void fireDisconnected() {
        this.logger.trace("Firing Disconnected!");
        this.channelHandlerContext.pipeline().fireUserEventTriggered(new DisconnectedEvent());
    }

    @Override
    public void fireDiscovered(PlcConnectionConfiguration c) {
        this.logger.trace("Firing Discovered!");
        this.channelHandlerContext.pipeline().fireUserEventTriggered(new DiscoveredEvent(c));
    }

    @Override
    public ConversationContext.SendRequestContext<T1> sendRequest(T1 packet) {
        return new DefaultSendRequestContext<T1>(null, handler -> {
            this.logger.trace("Adding Response Handler ...");
            this.handlerRegistrar.accept((HandlerRegistration)handler);
        }, packet, this);
    }

    @Override
    public ConversationContext.ExpectRequestContext<T1> expectRequest(Class<T1> clazz, Duration timeout) {
        return new DefaultExpectRequestContext<T1>(null, handler -> {
            this.logger.trace("Adding Request Handler ...");
            this.handlerRegistrar.accept((HandlerRegistration)handler);
        }, clazz, timeout, this);
    }
}

