/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.plc4x.java.api.messages.PlcRequest;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionResponse;
import org.apache.plc4x.java.api.model.PlcSubscriptionHandle;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.messages.PlcSubscriber;
import org.apache.plc4x.java.spi.utils.Serializable;

public class DefaultPlcUnsubscriptionRequest
implements PlcUnsubscriptionRequest,
PlcRequest,
Serializable {
    private final PlcSubscriber subscriber;
    private final List<PlcSubscriptionHandle> plcSubscriptionHandles;

    public DefaultPlcUnsubscriptionRequest(PlcSubscriber subscriber, List<PlcSubscriptionHandle> plcSubscriptionHandles) {
        this.subscriber = subscriber;
        this.plcSubscriptionHandles = plcSubscriptionHandles;
    }

    @Override
    public CompletableFuture<PlcUnsubscriptionResponse> execute() {
        return this.subscriber.unsubscribe(this);
    }

    @Override
    public List<PlcSubscriptionHandle> getSubscriptionHandles() {
        return this.plcSubscriptionHandles;
    }

    public PlcSubscriber getSubscriber() {
        return this.subscriber;
    }

    public Collection<PlcSubscriptionHandle> getPlcSubscriptionHandles() {
        return this.plcSubscriptionHandles;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    }

    public static class Builder
    implements PlcUnsubscriptionRequest.Builder {
        private final PlcSubscriber subscriber;
        private final List<PlcSubscriptionHandle> plcSubscriptionHandles;

        public Builder(PlcSubscriber subscriber) {
            this.subscriber = subscriber;
            this.plcSubscriptionHandles = new ArrayList<PlcSubscriptionHandle>();
        }

        @Override
        public PlcUnsubscriptionRequest.Builder addHandles(PlcSubscriptionHandle plcSubscriptionHandle) {
            this.plcSubscriptionHandles.add(plcSubscriptionHandle);
            return this;
        }

        @Override
        public PlcUnsubscriptionRequest.Builder addHandles(PlcSubscriptionHandle plcSubscriptionHandle1, PlcSubscriptionHandle ... plcSubscriptionHandles) {
            this.plcSubscriptionHandles.add(plcSubscriptionHandle1);
            this.plcSubscriptionHandles.addAll(Arrays.stream(plcSubscriptionHandles).map(PlcSubscriptionHandle.class::cast).collect(Collectors.toList()));
            return this;
        }

        @Override
        public PlcUnsubscriptionRequest.Builder addHandles(Collection<PlcSubscriptionHandle> plcSubscriptionHandles) {
            this.plcSubscriptionHandles.addAll(plcSubscriptionHandles.stream().map(PlcSubscriptionHandle.class::cast).collect(Collectors.toList()));
            return this;
        }

        @Override
        public PlcUnsubscriptionRequest build() {
            return new DefaultPlcUnsubscriptionRequest(this.subscriber, this.plcSubscriptionHandles);
        }
    }
}

