/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.messages;

import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.api.value.PlcValueHandler;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.connection.PlcTagHandler;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderWriterArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.messages.PlcWriter;
import org.apache.plc4x.java.spi.messages.utils.TagValueItem;
import org.apache.plc4x.java.spi.utils.Serializable;
import org.apache.plc4x.java.spi.values.PlcList;

public class DefaultPlcWriteRequest
implements PlcWriteRequest,
Serializable {
    private final PlcWriter writer;
    private final LinkedHashMap<String, TagValueItem> tags;

    public DefaultPlcWriteRequest(PlcWriter writer, LinkedHashMap<String, TagValueItem> tags) {
        this.writer = writer;
        this.tags = tags;
    }

    public CompletableFuture<PlcWriteResponse> execute() {
        return this.writer.write(this);
    }

    @Override
    public int getNumberOfTags() {
        return this.tags.size();
    }

    @Override
    public LinkedHashSet<String> getTagNames() {
        return new LinkedHashSet<String>(this.tags.keySet());
    }

    @Override
    public PlcTag getTag(String name) {
        return this.tags.get(name).getTag();
    }

    @Override
    public List<PlcTag> getTags() {
        return this.tags.values().stream().map(TagValueItem::getTag).collect(Collectors.toCollection(LinkedList::new));
    }

    @Override
    public PlcValue getPlcValue(String name) {
        return this.tags.get(name).getValue();
    }

    public List<PlcValue> getPlcValues() {
        return this.tags.values().stream().map(TagValueItem::getValue).collect(Collectors.toCollection(LinkedList::new));
    }

    public PlcWriter getWriter() {
        return this.writer;
    }

    @Override
    public int getNumberOfValues(String name) {
        PlcValue value = this.tags.get(name).getValue();
        if (value instanceof PlcList) {
            PlcList list = (PlcList)value;
            return list.getLength();
        }
        return 1;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        String tagName;
        TagValueItem tagValueItem;
        writeBuffer.pushContext("PlcWriteRequest", new WithWriterArgs[0]);
        writeBuffer.pushContext("PlcTagRequest", new WithWriterArgs[0]);
        writeBuffer.pushContext("tags", WithReaderWriterArgs.WithRenderAsList(true));
        for (Map.Entry<String, TagValueItem> tagEntry : this.tags.entrySet()) {
            tagValueItem = tagEntry.getValue();
            tagName = tagEntry.getKey();
            writeBuffer.pushContext(tagName, new WithWriterArgs[0]);
            PlcTag tag = tagValueItem.getTag();
            if (!(tag instanceof Serializable)) {
                throw new RuntimeException("Error serializing. Tag doesn't implement Serializable");
            }
            ((Serializable)((Object)tag)).serialize(writeBuffer);
            writeBuffer.popContext(tagName, new WithWriterArgs[0]);
        }
        writeBuffer.popContext("tags", new WithWriterArgs[0]);
        writeBuffer.popContext("PlcTagRequest", new WithWriterArgs[0]);
        writeBuffer.pushContext("values", WithReaderWriterArgs.WithRenderAsList(true));
        for (Map.Entry<String, TagValueItem> tagEntry : this.tags.entrySet()) {
            tagValueItem = tagEntry.getValue();
            tagName = tagEntry.getKey();
            writeBuffer.pushContext(tagName, new WithWriterArgs[0]);
            PlcValue value = tagValueItem.getValue();
            if (value != null) {
                this.serializePlcValue(value, writeBuffer);
            }
            writeBuffer.popContext(tagName, new WithWriterArgs[0]);
        }
        writeBuffer.popContext("values", new WithWriterArgs[0]);
        writeBuffer.popContext("PlcWriteRequest", new WithWriterArgs[0]);
    }

    protected void serializePlcValue(PlcValue plcValue, WriteBuffer writeBuffer) throws SerializationException {
        if (plcValue instanceof Serializable) {
            Serializable serializable = (Serializable)((Object)plcValue);
            serializable.serialize(writeBuffer);
        } else {
            String plcValueString = plcValue.getString();
            writeBuffer.writeString("value", plcValueString.getBytes(StandardCharsets.UTF_8).length * 8, plcValueString, WithOption.WithEncoding(StandardCharsets.UTF_8.name()));
        }
    }

    public static class Builder
    implements PlcWriteRequest.Builder {
        private final PlcWriter writer;
        private final PlcTagHandler tagHandler;
        private final PlcValueHandler valueHandler;
        private final Map<String, Pair<Supplier<PlcTag>, Object[]>> tags;

        public Builder(PlcWriter writer, PlcTagHandler tagHandler, PlcValueHandler valueHandler) {
            this.writer = writer;
            this.tagHandler = tagHandler;
            this.valueHandler = valueHandler;
            this.tags = new TreeMap<String, Pair<Supplier<PlcTag>, Object[]>>();
        }

        @Override
        public Builder addTagAddress(String name, String tagAddress, Object ... values) {
            if (this.tags.containsKey(name)) {
                throw new PlcRuntimeException("Duplicate tag definition '" + name + "'");
            }
            this.tags.put(name, Pair.of(() -> this.tagHandler.parseTag(tagAddress), values));
            return this;
        }

        @Override
        public Builder addTag(String name, PlcTag tag, Object ... values) {
            if (this.tags.containsKey(name)) {
                throw new PlcRuntimeException("Duplicate tag definition '" + name + "'");
            }
            this.tags.put(name, Pair.of(() -> tag, values));
            return this;
        }

        @Override
        public PlcWriteRequest build() {
            LinkedHashMap<String, TagValueItem> parsedTags = new LinkedHashMap<String, TagValueItem>();
            this.tags.forEach((name, tagValues) -> {
                PlcTag tag = (PlcTag)((Supplier)tagValues.getLeft()).get();
                Object[] value = (Object[])tagValues.getRight();
                PlcValue plcValue = this.valueHandler.newPlcValue(tag, value);
                parsedTags.put((String)name, new TagValueItem(tag, plcValue));
            });
            return new DefaultPlcWriteRequest(this.writer, parsedTags);
        }
    }
}

