/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.messages;

import java.util.Collection;
import java.util.Map;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderWriterArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.utils.Serializable;

public class DefaultPlcWriteResponse
implements PlcWriteResponse,
Serializable {
    private final PlcWriteRequest request;
    private final Map<String, PlcResponseCode> responseCodes;

    public DefaultPlcWriteResponse(PlcWriteRequest request, Map<String, PlcResponseCode> responseCodes) {
        this.request = request;
        this.responseCodes = responseCodes;
    }

    @Override
    public PlcWriteRequest getRequest() {
        return this.request;
    }

    @Override
    public Collection<String> getTagNames() {
        return this.request.getTagNames();
    }

    @Override
    public PlcTag getTag(String name) {
        return this.request.getTag(name);
    }

    @Override
    public PlcResponseCode getResponseCode(String name) {
        return this.responseCodes.get(name);
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.pushContext("PlcWriteResponse", new WithWriterArgs[0]);
        writeBuffer.pushContext("request", new WithWriterArgs[0]);
        if (this.request instanceof Serializable) {
            ((Serializable)((Object)this.request)).serialize(writeBuffer);
        }
        writeBuffer.popContext("request", new WithWriterArgs[0]);
        writeBuffer.pushContext("responseCodes", WithReaderWriterArgs.WithRenderAsList(true));
        for (Map.Entry<String, PlcResponseCode> tagEntry : this.responseCodes.entrySet()) {
            String tagName = tagEntry.getKey();
            writeBuffer.pushContext(tagName, new WithWriterArgs[0]);
            PlcResponseCode tagResponseCode = tagEntry.getValue();
            writeBuffer.writeUnsignedByte("ResponseCode", 8, (byte)tagResponseCode.getValue(), WithReaderWriterArgs.WithAdditionalStringRepresentation(tagResponseCode.name()));
            writeBuffer.popContext(tagName, new WithWriterArgs[0]);
        }
        writeBuffer.popContext("responseCodes", new WithWriterArgs[0]);
        writeBuffer.popContext("PlcWriteResponse", new WithWriterArgs[0]);
    }
}

