/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.model;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.plc4x.java.api.messages.PlcSubscriptionEvent;
import org.apache.plc4x.java.api.model.PlcConsumerRegistration;
import org.apache.plc4x.java.api.model.PlcSubscriptionHandle;
import org.apache.plc4x.java.spi.messages.PlcSubscriber;

public class DefaultPlcConsumerRegistration
implements PlcConsumerRegistration {
    private final PlcSubscriber plcSubscriber;
    private final List<PlcSubscriptionHandle> handles;
    private final int consumerHash;

    public DefaultPlcConsumerRegistration(PlcSubscriber plcSubscriber, Consumer<PlcSubscriptionEvent> consumer, PlcSubscriptionHandle ... handles) {
        this.plcSubscriber = plcSubscriber;
        this.handles = Arrays.asList(Objects.requireNonNull(handles));
        this.consumerHash = Objects.requireNonNull(consumer).hashCode();
    }

    @Override
    public Integer getConsumerId() {
        return this.consumerHash;
    }

    @Override
    public List<PlcSubscriptionHandle> getSubscriptionHandles() {
        return this.handles;
    }

    @Override
    public void unregister() {
        this.plcSubscriber.unregister(this);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultPlcConsumerRegistration)) {
            return false;
        }
        DefaultPlcConsumerRegistration that = (DefaultPlcConsumerRegistration)o;
        return Objects.equals(this.plcSubscriber, that.plcSubscriber) && Objects.equals(this.handles, that.handles) && this.consumerHash == that.consumerHash;
    }

    public final int hashCode() {
        return Objects.hash(this.plcSubscriber, this.handles, this.consumerHash);
    }

    public String toString() {
        return "DefaultPlcConsumerRegistration{handles=" + this.handles + ", consumerHash=" + this.consumerHash + '}';
    }
}

