/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.netty;

import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.plc4x.java.spi.TimedOperation;
import org.apache.plc4x.java.spi.TimeoutManager;

public class NettyHashTimerTimeoutManager
implements TimeoutManager {
    private final Timer timer;

    public NettyHashTimerTimeoutManager() {
        this(100L);
    }

    public NettyHashTimerTimeoutManager(long tickInMilliseconds) {
        HashedWheelTimer wheelTimer = new HashedWheelTimer(tickInMilliseconds, TimeUnit.MILLISECONDS);
        this.timer = wheelTimer;
        wheelTimer.start();
    }

    @Override
    public TimeoutManager.CompletionCallback<?> register(TimedOperation operation) {
        Timeout newTimeout = this.timer.newTimeout(timeout -> {
            if (timeout.isCancelled()) {
                return;
            }
            TimeoutException exception = new TimeoutException();
            operation.getOnTimeoutConsumer().accept(exception);
        }, operation.getTimeout().toMillis(), TimeUnit.MILLISECONDS);
        return new TimeoutCompletionCallback(newTimeout);
    }

    @Override
    public void stop() {
        Set<Timeout> timeouts = this.timer.stop();
        timeouts.forEach(Timeout::cancel);
    }

    static class TimeoutCompletionCallback<T>
    implements TimeoutManager.CompletionCallback<T> {
        private final Timeout timeout;

        TimeoutCompletionCallback(Timeout timeout) {
            this.timeout = timeout;
        }

        @Override
        public void complete() {
            this.timeout.cancel();
        }
    }
}

