/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.utils.ascii;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.plc4x.java.spi.utils.ascii.AsciiBoxWriter;

public class AsciiBox {
    private final Pattern ANSI_PATTERN = Pattern.compile("[\u001b\u009b][\\[()#;?]*(?:[0-9]{1,4}(?:;[0-9]{0,4})*)?[0-9A-ORZcf-nqry=><]");
    private final AsciiBoxWriter asciiBoxWriter;
    private final String data;
    String compressedBoxSet;

    protected AsciiBox(String data) {
        this(AsciiBoxWriter.DEFAULT, data);
    }

    protected AsciiBox(AsciiBoxWriter asciiBoxWriter, String data) {
        Objects.requireNonNull(data);
        this.asciiBoxWriter = asciiBoxWriter;
        this.data = data;
        this.compressedBoxSet = asciiBoxWriter.boxSet.compressBoxSet();
    }

    public int width() {
        int maxWidth = 0;
        String[] stringArray = this.lines();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            int currentLength = this.ANSI_PATTERN.matcher(line).replaceAll("").length();
            if (maxWidth < currentLength) {
                maxWidth = currentLength;
            }
            ++n2;
        }
        return maxWidth;
    }

    public int height() {
        return this.lines().length;
    }

    public String[] lines() {
        return this.data.split("\n");
    }

    public String getBoxName() {
        Matcher matcher = this.asciiBoxWriter.boxNameRegex.matcher(this.data);
        if (!matcher.find()) {
            return "";
        }
        return matcher.group("name");
    }

    public AsciiBox changeBoxName(String newName) {
        if (!this.asciiBoxWriter.hasBorders(this)) {
            return this.asciiBoxWriter.boxString(newName, this.toString(), 0);
        }
        int minimumWidthWithNewName = (String.valueOf(this.asciiBoxWriter.boxSet.upperLeftCorner) + this.asciiBoxWriter.boxSet.horizontalLine + newName + this.asciiBoxWriter.boxSet.upperRightCorner).length();
        int nameLengthDifference = minimumWidthWithNewName - (this.asciiBoxWriter.unwrap(this).width() + this.asciiBoxWriter.borderWidth + this.asciiBoxWriter.borderWidth);
        AsciiBox asciiBox = this.asciiBoxWriter.boxString(newName, this.asciiBoxWriter.unwrap(this).toString(), this.width() + nameLengthDifference);
        asciiBox.compressedBoxSet = this.asciiBoxWriter.boxSet.contributeToCompressedBoxSet(this);
        return asciiBox;
    }

    public boolean isEmpty() {
        if (this.asciiBoxWriter.hasBorders(this)) {
            return StringUtils.isBlank(this.asciiBoxWriter.unwrap(this).toString());
        }
        return StringUtils.isBlank(this.toString());
    }

    public String toString() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AsciiBox asciiBox = (AsciiBox)o;
        return Objects.equals(this.data, asciiBox.data);
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }
}

