/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcSimpleValue;

public class PlcDATE_AND_LTIME
extends PlcSimpleValue<LocalDateTime> {
    public static PlcDATE_AND_LTIME of(Object value) {
        if (value instanceof LocalDateTime) {
            return new PlcDATE_AND_LTIME((LocalDateTime)value);
        }
        if (value instanceof Long) {
            return new PlcDATE_AND_LTIME(LocalDateTime.ofInstant(Instant.ofEpochSecond((Long)value), ZoneOffset.UTC));
        }
        if (value instanceof BigInteger) {
            return new PlcDATE_AND_LTIME(LocalDateTime.ofInstant(Instant.ofEpochSecond(((BigInteger)value).longValue()), ZoneOffset.UTC));
        }
        throw new PlcRuntimeException("Invalid value type");
    }

    public static PlcDATE_AND_LTIME ofNanosecondsSinceEpoch(BigInteger nanosecondsSinceEpoch) {
        return new PlcDATE_AND_LTIME(nanosecondsSinceEpoch);
    }

    public PlcDATE_AND_LTIME(LocalDateTime value) {
        super(value, true);
    }

    public PlcDATE_AND_LTIME(BigInteger nanosecondsSinceEpoch) {
        super(LocalDateTime.ofEpochSecond(nanosecondsSinceEpoch.divide(BigInteger.valueOf(1000000000L)).longValue(), nanosecondsSinceEpoch.mod(BigInteger.valueOf(1000000000L)).intValue(), ZoneOffset.UTC), true);
    }

    public static PlcDATE_AND_LTIME ofSegments(int year, int month, int day, int hour, int minutes, int seconds, long nannosecondsOfSecond) {
        return new PlcDATE_AND_LTIME(LocalDateTime.of(year, month, day, hour, minutes, seconds, (int)nannosecondsOfSecond));
    }

    @Override
    public PlcValueType getPlcValueType() {
        return PlcValueType.DATE_AND_LTIME;
    }

    public BigInteger getNanosecondsSinceEpoch() {
        Instant instant = this.getDateTime().toInstant(ZoneOffset.UTC);
        return BigInteger.valueOf(instant.getEpochSecond()).multiply(BigInteger.valueOf(1000000000L)).add(BigInteger.valueOf(instant.getNano()));
    }

    @Override
    public boolean isLong() {
        return true;
    }

    @Override
    public long getLong() {
        Instant instant = ((LocalDateTime)this.value).atZone(ZoneOffset.UTC).toInstant();
        return instant.getEpochSecond();
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public String getString() {
        return ((LocalDateTime)this.value).toString();
    }

    @Override
    public boolean isTime() {
        return true;
    }

    @Override
    public LocalTime getTime() {
        return ((LocalDateTime)this.value).toLocalTime();
    }

    @Override
    public boolean isDate() {
        return true;
    }

    @Override
    public LocalDate getDate() {
        return ((LocalDateTime)this.value).toLocalDate();
    }

    @Override
    public boolean isDateTime() {
        return true;
    }

    @Override
    public LocalDateTime getDateTime() {
        return (LocalDateTime)this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        String valueString = ((LocalDateTime)this.value).toString();
        writeBuffer.writeString(this.getClass().getSimpleName(), valueString.getBytes(StandardCharsets.UTF_8).length * 8, valueString, WithOption.WithEncoding(StandardCharsets.UTF_8.name()));
    }
}

