/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcSimpleValue;

public class PlcLTIME
extends PlcSimpleValue<Duration> {
    public static PlcLTIME of(Object value) {
        if (value instanceof Duration) {
            return new PlcLTIME((Duration)value);
        }
        if (value instanceof Integer) {
            return new PlcLTIME(Duration.of((Long)value, ChronoUnit.MILLIS));
        }
        if (value instanceof Long) {
            return new PlcLTIME(Duration.of((Long)value, ChronoUnit.NANOS));
        }
        if (value instanceof BigInteger) {
            return new PlcLTIME(Duration.of(((BigInteger)value).longValue(), ChronoUnit.NANOS));
        }
        throw new PlcRuntimeException("Invalid value type");
    }

    public static PlcLTIME ofNanoseconds(long nanoseconds) {
        return new PlcLTIME(Duration.ofNanos(nanoseconds));
    }

    public static PlcLTIME ofNanoseconds(BigInteger nanoseconds) {
        return new PlcLTIME(Duration.ofNanos(nanoseconds.longValue()));
    }

    public PlcLTIME(Duration value) {
        super(value, true);
    }

    public PlcLTIME(long nanoseconds) {
        super(Duration.ofNanos(nanoseconds), true);
    }

    public PlcLTIME(BigInteger nanoseconds) {
        super(Duration.ofNanos(nanoseconds.longValue()), true);
    }

    @Override
    public PlcValueType getPlcValueType() {
        return PlcValueType.LTIME;
    }

    public long getNanoseconds() {
        return ((Duration)this.value).toNanos();
    }

    @Override
    public boolean isInteger() {
        return true;
    }

    @Override
    public boolean isLong() {
        return true;
    }

    @Override
    public boolean isBigInteger() {
        return true;
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public boolean isDuration() {
        return true;
    }

    @Override
    public int getInteger() {
        return (int)(((Duration)this.value).get(ChronoUnit.NANOS) / 1000000L);
    }

    @Override
    public long getLong() {
        return ((Duration)this.value).get(ChronoUnit.NANOS);
    }

    @Override
    public BigInteger getBigInteger() {
        return BigInteger.valueOf(((Duration)this.value).get(ChronoUnit.NANOS));
    }

    @Override
    public Duration getDuration() {
        return (Duration)this.value;
    }

    @Override
    public String getString() {
        return ((Duration)this.value).toString();
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        String valueString = ((Duration)this.value).toString();
        writeBuffer.writeString(this.getClass().getSimpleName(), valueString.getBytes(StandardCharsets.UTF_8).length * 8, valueString, WithOption.WithEncoding(StandardCharsets.UTF_8.name()));
    }
}

