/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.BitSet;
import org.apache.plc4x.java.api.exceptions.PlcInvalidTagException;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcIECValue;

public class PlcLWORD
extends PlcIECValue<BigInteger> {
    private static final String VALUE_OUT_OF_RANGE = "Value of type %s is out of range %d - %d for a %s Value";
    static final BigInteger minValue = BigInteger.valueOf(0L);
    static final BigInteger maxValue = BigInteger.valueOf(Long.MAX_VALUE).multiply(BigInteger.valueOf(2L)).add(BigInteger.valueOf(1L));

    public static PlcLWORD of(Object value) {
        if (value instanceof Boolean) {
            return new PlcLWORD((Boolean)value);
        }
        if (value instanceof Byte) {
            return new PlcLWORD((Byte)value);
        }
        if (value instanceof Short) {
            return new PlcLWORD((Short)value);
        }
        if (value instanceof Integer) {
            return new PlcLWORD((Integer)value);
        }
        if (value instanceof Long) {
            return new PlcLWORD((Long)value);
        }
        if (value instanceof Float) {
            return new PlcLWORD((Float)value);
        }
        if (value instanceof Double) {
            return new PlcLWORD((Double)value);
        }
        if (value instanceof BigInteger) {
            return new PlcLWORD((BigInteger)value);
        }
        if (value instanceof BigDecimal) {
            return new PlcLWORD((BigDecimal)value);
        }
        return new PlcLWORD((String)value);
    }

    public PlcLWORD(Boolean value) {
        this.value = value != false ? BigInteger.valueOf(1L) : BigInteger.valueOf(0L);
        this.isNullable = false;
    }

    public PlcLWORD(Byte value) {
        BigInteger val = BigInteger.valueOf(value.byteValue());
        if (val.compareTo(minValue) < 0 || val.compareTo(maxValue) > 0) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = val;
        this.isNullable = false;
    }

    public PlcLWORD(Short value) {
        BigInteger val = BigInteger.valueOf(value.shortValue());
        if (val.compareTo(minValue) < 0 || val.compareTo(maxValue) > 0) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = val;
        this.isNullable = false;
    }

    public PlcLWORD(Integer value) {
        BigInteger val = BigInteger.valueOf(value.intValue());
        if (val.compareTo(minValue) < 0 || val.compareTo(maxValue) > 0) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = val;
        this.isNullable = false;
    }

    public PlcLWORD(Long value) {
        BigInteger val = BigInteger.valueOf(value);
        if (val.compareTo(minValue) < 0 || val.compareTo(maxValue) > 0) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = val;
        this.isNullable = false;
    }

    public PlcLWORD(Float value) {
        try {
            BigInteger val = BigDecimal.valueOf(value.floatValue()).toBigInteger();
            if (val.compareTo(minValue) < 0 || val.compareTo(maxValue) > 0) {
                throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
            }
            this.value = val;
            this.isNullable = false;
        }
        catch (Exception e) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()), e);
        }
    }

    public PlcLWORD(Double value) {
        try {
            BigInteger val = BigDecimal.valueOf(value).toBigInteger();
            if (val.compareTo(minValue) < 0 || val.compareTo(maxValue) > 0) {
                throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
            }
            this.value = val;
            this.isNullable = false;
        }
        catch (Exception e) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()), e);
        }
    }

    public PlcLWORD(BigInteger value) {
        if (value.compareTo(minValue) < 0 || value.compareTo(maxValue) > 0) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value;
        this.isNullable = false;
    }

    public PlcLWORD(BigDecimal value) {
        try {
            BigInteger val = value.toBigInteger();
            if (val.compareTo(minValue) < 0 || val.compareTo(maxValue) > 0) {
                throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
            }
            this.value = val;
            this.isNullable = false;
        }
        catch (Exception e) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()), e);
        }
    }

    public PlcLWORD(String value) {
        try {
            BigInteger val = new BigInteger(value.trim());
            if (val.compareTo(minValue) < 0 || val.compareTo(maxValue) > 0) {
                throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
            }
            this.value = val;
            this.isNullable = false;
        }
        catch (Exception e) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()), e);
        }
    }

    @Override
    public PlcValueType getPlcValueType() {
        return PlcValueType.LWORD;
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public boolean getBoolean() {
        return this.value != null && !((BigInteger)this.value).equals(BigInteger.ZERO);
    }

    public boolean[] getBooleanArray() {
        boolean[] booleanValues = new boolean[64];
        BitSet bitSet = BitSet.valueOf(((BigInteger)this.value).toByteArray());
        int i = 0;
        while (i < 64) {
            booleanValues[i] = bitSet.get(i);
            ++i;
        }
        return booleanValues;
    }

    @Override
    public boolean isByte() {
        return this.value != null && ((BigInteger)this.value).compareTo(BigInteger.valueOf(127L)) <= 0 && ((BigInteger)this.value).compareTo(BigInteger.valueOf(-128L)) >= 0;
    }

    @Override
    public byte getByte() {
        return ((BigInteger)this.value).byteValue();
    }

    @Override
    public boolean isShort() {
        return this.value != null && ((BigInteger)this.value).compareTo(BigInteger.valueOf(32767L)) <= 0 && ((BigInteger)this.value).compareTo(BigInteger.valueOf(-32768L)) >= 0;
    }

    @Override
    public short getShort() {
        return ((BigInteger)this.value).shortValue();
    }

    @Override
    public boolean isInteger() {
        return this.value != null && ((BigInteger)this.value).compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) <= 0 && ((BigInteger)this.value).compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) >= 0;
    }

    @Override
    public int getInteger() {
        return ((BigInteger)this.value).intValue();
    }

    @Override
    public boolean isLong() {
        return this.value != null && ((BigInteger)this.value).compareTo(BigInteger.valueOf(Long.MAX_VALUE)) <= 0 && ((BigInteger)this.value).compareTo(BigInteger.valueOf(Long.MIN_VALUE)) >= 0;
    }

    @Override
    public long getLong() {
        return ((BigInteger)this.value).longValue();
    }

    @Override
    public boolean isBigInteger() {
        return true;
    }

    @Override
    public BigInteger getBigInteger() {
        return (BigInteger)this.value;
    }

    @Override
    public boolean isFloat() {
        return true;
    }

    @Override
    public float getFloat() {
        return ((BigInteger)this.value).floatValue();
    }

    @Override
    public boolean isDouble() {
        return true;
    }

    @Override
    public double getDouble() {
        return ((BigInteger)this.value).doubleValue();
    }

    @Override
    public boolean isBigDecimal() {
        return true;
    }

    @Override
    public BigDecimal getBigDecimal() {
        return new BigDecimal((BigInteger)this.value);
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public String getString() {
        return this.toString();
    }

    public String toString() {
        return ((BigInteger)this.value).toString();
    }

    public byte[] getBytes() {
        byte[] tmp = ((BigInteger)this.value).toByteArray();
        byte[] bytes = new byte[8];
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = i >= bytes.length - tmp.length ? tmp[i - (bytes.length - tmp.length)] : (byte)0;
            ++i;
        }
        return bytes;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.writeBigInteger(this.getClass().getSimpleName(), 64, (BigInteger)this.value, new WithWriterArgs[0]);
    }
}

