/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.exceptions.PlcUnsupportedDataTypeException;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.spi.values.PlcBOOL;
import org.apache.plc4x.java.spi.values.PlcBYTE;
import org.apache.plc4x.java.spi.values.PlcCHAR;
import org.apache.plc4x.java.spi.values.PlcDATE;
import org.apache.plc4x.java.spi.values.PlcDATE_AND_TIME;
import org.apache.plc4x.java.spi.values.PlcDINT;
import org.apache.plc4x.java.spi.values.PlcDWORD;
import org.apache.plc4x.java.spi.values.PlcINT;
import org.apache.plc4x.java.spi.values.PlcLINT;
import org.apache.plc4x.java.spi.values.PlcLREAL;
import org.apache.plc4x.java.spi.values.PlcLWORD;
import org.apache.plc4x.java.spi.values.PlcList;
import org.apache.plc4x.java.spi.values.PlcNull;
import org.apache.plc4x.java.spi.values.PlcREAL;
import org.apache.plc4x.java.spi.values.PlcRawByteArray;
import org.apache.plc4x.java.spi.values.PlcSINT;
import org.apache.plc4x.java.spi.values.PlcSTRING;
import org.apache.plc4x.java.spi.values.PlcTIME;
import org.apache.plc4x.java.spi.values.PlcTIME_OF_DAY;
import org.apache.plc4x.java.spi.values.PlcUDINT;
import org.apache.plc4x.java.spi.values.PlcUINT;
import org.apache.plc4x.java.spi.values.PlcULINT;
import org.apache.plc4x.java.spi.values.PlcUSINT;
import org.apache.plc4x.java.spi.values.PlcWCHAR;
import org.apache.plc4x.java.spi.values.PlcWORD;
import org.apache.plc4x.java.spi.values.PlcWSTRING;

public class PlcValueHandler
implements org.apache.plc4x.java.api.value.PlcValueHandler {
    @Override
    public PlcValue newPlcValue(Object value) {
        return PlcValueHandler.of(new Object[]{value});
    }

    @Override
    public PlcValue newPlcValue(Object[] values) {
        return PlcValueHandler.of(values);
    }

    @Override
    public PlcValue newPlcValue(PlcTag tag, Object value) {
        return PlcValueHandler.of(tag, new Object[]{value});
    }

    @Override
    public PlcValue newPlcValue(PlcTag tag, Object[] values) {
        return PlcValueHandler.of(tag, values);
    }

    public static PlcValue of(Object value) {
        return PlcValueHandler.of(new Object[]{value});
    }

    public static PlcValue of(List<?> value) {
        return PlcValueHandler.of(value.toArray());
    }

    public static PlcValue of(Object[] values) {
        if (values.length != 1) {
            PlcList list = new PlcList();
            Object[] objectArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                list.add(PlcValueHandler.of(new Object[]{value}));
                ++n2;
            }
            return list;
        }
        Object value = values[0];
        if (value instanceof Boolean) {
            return PlcBOOL.of(value);
        }
        if (value instanceof Byte) {
            return PlcSINT.of(value);
        }
        if (value instanceof byte[]) {
            return PlcRawByteArray.of(value);
        }
        if (value instanceof Short) {
            return PlcINT.of(value);
        }
        if (value instanceof Integer) {
            return PlcDINT.of(value);
        }
        if (value instanceof Long) {
            return PlcLINT.of(value);
        }
        if (value instanceof BigInteger) {
            return PlcLINT.of(value);
        }
        if (value instanceof Float) {
            return PlcREAL.of(value);
        }
        if (value instanceof Double) {
            return PlcLREAL.of(value);
        }
        if (value instanceof Duration) {
            return new PlcTIME((Duration)value);
        }
        if (value instanceof LocalTime) {
            return new PlcTIME_OF_DAY((LocalTime)value);
        }
        if (value instanceof LocalDate) {
            return new PlcDATE((LocalDate)value);
        }
        if (value instanceof LocalDateTime) {
            return new PlcDATE_AND_TIME((LocalDateTime)value);
        }
        if (value instanceof String) {
            return new PlcSTRING((String)value);
        }
        if (value instanceof PlcValue) {
            return (PlcValue)value;
        }
        throw new PlcUnsupportedDataTypeException("Data Type " + value.getClass() + " Is not supported");
    }

    public static PlcValue of(PlcTag tag, Object value) {
        return PlcValueHandler.of(tag, new Object[]{value});
    }

    public static PlcValue of(PlcTag tag, Object[] values) {
        if (values.length == 1) {
            Object value = values[0];
            if (tag.getPlcValueType() == null) {
                if (value instanceof PlcValue) {
                    return (PlcValue)value;
                }
                return new PlcNull();
            }
            if (value instanceof PlcValue) {
                PlcValue plcValue = (PlcValue)value;
                if (plcValue.getPlcValueType() == tag.getPlcValueType()) {
                    return (PlcValue)value;
                }
                throw new PlcRuntimeException("Expected PlcValue of type " + tag.getPlcValueType().name() + " but got " + plcValue.getPlcValueType().name());
            }
            switch (tag.getPlcValueType()) {
                case BOOL: {
                    return PlcBOOL.of(value);
                }
                case BYTE: {
                    if (value instanceof Short) {
                        return new PlcBYTE((short)((Short)value));
                    }
                    if (value instanceof Integer) {
                        return new PlcBYTE(((Integer)value).shortValue());
                    }
                    if (value instanceof Long) {
                        return new PlcBYTE(((Long)value).shortValue());
                    }
                    if (value instanceof BigInteger) {
                        return new PlcBYTE(((BigInteger)value).shortValue());
                    }
                    if (value instanceof String) {
                        try {
                            return new PlcBYTE(Short.valueOf((String)value));
                        }
                        catch (NumberFormatException e) {
                            throw new PlcRuntimeException("Value of " + value + " not parseable as Byte");
                        }
                    }
                    throw new PlcRuntimeException("BYTE requires short");
                }
                case SINT: {
                    return PlcSINT.of(value);
                }
                case USINT: {
                    return PlcUSINT.of(value);
                }
                case INT: {
                    return PlcINT.of(value);
                }
                case UINT: {
                    return PlcUINT.of(value);
                }
                case WORD: {
                    if (value instanceof Short) {
                        return new PlcWORD((int)((Integer)value));
                    }
                    if (value instanceof Integer) {
                        return new PlcWORD((int)((Integer)value));
                    }
                    if (value instanceof Long) {
                        return new PlcWORD(((Long)value).intValue());
                    }
                    if (value instanceof BigInteger) {
                        return new PlcWORD(((BigInteger)value).intValue());
                    }
                    if (value instanceof String) {
                        try {
                            return new PlcWORD(Integer.valueOf((String)value));
                        }
                        catch (NumberFormatException e) {
                            throw new PlcRuntimeException("Value of " + value + " not parseable as Integer");
                        }
                    }
                    throw new PlcRuntimeException("WORD requires int");
                }
                case DINT: {
                    return PlcDINT.of(value);
                }
                case UDINT: {
                    return PlcUDINT.of(value);
                }
                case DWORD: {
                    if (value instanceof Short) {
                        return new PlcDWORD((long)((Long)value));
                    }
                    if (value instanceof Integer) {
                        return new PlcDWORD((long)((Long)value));
                    }
                    if (value instanceof Long) {
                        return new PlcDWORD((long)((Long)value));
                    }
                    if (value instanceof BigInteger) {
                        return new PlcDWORD(((BigInteger)value).longValue());
                    }
                    if (value instanceof String) {
                        try {
                            return new PlcDWORD(Long.valueOf((String)value));
                        }
                        catch (NumberFormatException e) {
                            throw new PlcRuntimeException("Value of " + value + " not parseable as Long");
                        }
                    }
                    throw new PlcRuntimeException("DWORD requires long");
                }
                case LINT: {
                    return PlcLINT.of(value);
                }
                case ULINT: {
                    return PlcULINT.of(value);
                }
                case LWORD: {
                    if (value instanceof Short) {
                        return new PlcLWORD(BigInteger.valueOf((Long)value));
                    }
                    if (value instanceof Integer) {
                        return new PlcLWORD(BigInteger.valueOf((Long)value));
                    }
                    if (value instanceof Long) {
                        return new PlcLWORD(BigInteger.valueOf((Long)value));
                    }
                    if (value instanceof BigInteger) {
                        return new PlcLWORD((BigInteger)value);
                    }
                    if (value instanceof String) {
                        try {
                            return new PlcLWORD(new BigInteger((String)value));
                        }
                        catch (NumberFormatException e) {
                            throw new PlcRuntimeException("Value of " + value + " not parseable as BigInteger");
                        }
                    }
                    throw new PlcRuntimeException("LWORD requires BigInteger");
                }
                case REAL: {
                    return PlcREAL.of(value);
                }
                case LREAL: {
                    return PlcLREAL.of(value);
                }
                case CHAR: {
                    return PlcCHAR.of(value);
                }
                case WCHAR: {
                    return PlcWCHAR.of(value);
                }
                case STRING: {
                    return PlcSTRING.of(value);
                }
                case WSTRING: {
                    return PlcWSTRING.of(value);
                }
                case TIME: {
                    return PlcTIME.of(value);
                }
                case DATE: {
                    return PlcDATE.of(value);
                }
                case TIME_OF_DAY: {
                    return PlcTIME_OF_DAY.of(value);
                }
                case DATE_AND_TIME: {
                    return PlcDATE_AND_TIME.of(value);
                }
            }
            return PlcValueHandler.customDataType(new Object[]{value});
        }
        PlcList list = new PlcList();
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            list.add(PlcValueHandler.of(tag, new Object[]{value}));
            ++n2;
        }
        return list;
    }

    public static PlcValue customDataType(Object[] values) {
        return PlcValueHandler.of(values);
    }
}

