/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.transport.pcapreplay;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import org.apache.plc4x.java.spi.configuration.HasConfiguration;
import org.apache.plc4x.java.spi.connection.NettyChannelFactory;
import org.apache.plc4x.java.transport.pcapreplay.PcapReplayTransportConfiguration;
import org.apache.plc4x.java.utils.pcap.netty.address.PcapSocketAddress;
import org.apache.plc4x.java.utils.pcap.netty.config.PcapChannelOption;
import org.apache.plc4x.java.utils.pcapreplay.netty.PcapReplayChannel;
import org.apache.plc4x.java.utils.pcapreplay.netty.config.PcapReplayChannelOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcapReplayChannelFactory
extends NettyChannelFactory
implements HasConfiguration<PcapReplayTransportConfiguration> {
    private static final Logger logger = LoggerFactory.getLogger(PcapReplayChannelFactory.class);
    private PcapReplayTransportConfiguration configuration;

    public PcapReplayChannelFactory(PcapSocketAddress address) {
        super(address);
    }

    @Override
    public void setConfiguration(PcapReplayTransportConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public Class<? extends Channel> getChannel() {
        return PcapReplayChannel.class;
    }

    @Override
    public boolean isPassive() {
        return true;
    }

    @Override
    public void configureBootstrap(Bootstrap bootstrap) {
        if (this.configuration != null) {
            logger.info("Configuring Bootstrap with {}", (Object)this.configuration);
            bootstrap.option(PcapChannelOption.SUPPORT_VLANS, this.configuration.getSupportVlans());
            bootstrap.option(PcapChannelOption.PORT, this.configuration.getDefaultPort());
            bootstrap.option(PcapChannelOption.PROTOCOL_ID, this.configuration.getProtocolId());
            if (this.configuration.getPcapPacketHandler() != null) {
                bootstrap.option(PcapChannelOption.PACKET_HANDLER, this.configuration.getPcapPacketHandler());
            }
            bootstrap.option(PcapReplayChannelOption.SPEED_FACTOR, Float.valueOf(this.configuration.getReplaySpeedFactor()));
            bootstrap.option(PcapReplayChannelOption.FILTER, this.configuration.getFilter());
        }
    }

    @Override
    public EventLoopGroup getEventLoopGroup() {
        return new OioEventLoopGroup();
    }
}

