/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.transport.pcapreplay;

import java.io.File;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.spi.configuration.PlcTransportConfiguration;
import org.apache.plc4x.java.spi.connection.ChannelFactory;
import org.apache.plc4x.java.spi.transport.Transport;
import org.apache.plc4x.java.transport.pcapreplay.DefaultPcapReplayTransportConfiguration;
import org.apache.plc4x.java.transport.pcapreplay.PcapReplayChannelFactory;
import org.apache.plc4x.java.utils.pcapreplay.netty.address.PcapReplayAddress;

public class PcapReplayTransport
implements Transport {
    @Override
    public String getTransportCode() {
        return "pcap";
    }

    @Override
    public String getTransportName() {
        return "PCAP(NG) Playback Transport";
    }

    @Override
    public ChannelFactory createChannelFactory(String transportConfig) {
        File pcapFile = new File(transportConfig);
        if (!pcapFile.exists() || !pcapFile.isFile()) {
            throw new PlcRuntimeException("File not found at " + transportConfig);
        }
        PcapReplayAddress address = new PcapReplayAddress(pcapFile);
        return new PcapReplayChannelFactory(address);
    }

    @Override
    public Class<? extends PlcTransportConfiguration> getTransportConfigType() {
        return DefaultPcapReplayTransportConfiguration.class;
    }
}

