/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.transport.serial;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.FileRegion;
import io.netty.channel.MessageSizeEstimator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.VoidChannelPromise;
import io.netty.channel.nio.AbstractNioByteChannel;
import io.netty.channel.nio.AbstractNioChannel;
import io.netty.channel.nio.NioEventLoop;
import io.netty.channel.socket.DuplexChannel;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.util.Optional;
import java.util.concurrent.RejectedExecutionException;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.plc4x.java.transport.serial.SerialChannelConfig;
import org.apache.plc4x.java.transport.serial.SerialChannelHandler;
import org.apache.plc4x.java.transport.serial.SerialPollingSelector;
import org.apache.plc4x.java.transport.serial.SerialSelectionKey;
import org.apache.plc4x.java.transport.serial.SerialSelectorProvider;
import org.apache.plc4x.java.transport.serial.SerialSocketAddress;
import org.apache.plc4x.java.transport.serial.SerialSocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialChannel
extends AbstractNioByteChannel
implements DuplexChannel {
    private static final Logger logger = LoggerFactory.getLogger(SerialChannel.class);
    private final SerialChannelConfig config;
    private final VoidChannelPromise unsafeVoidPromise = new VoidChannelPromise(this, false);
    private boolean serialReadPending = false;
    private SocketAddress remoteAddress;
    private boolean active = false;
    private SerialSelectionKey serialSelectionKey;
    private SerialChannelHandler comPort;
    private final DefaultChannelPipeline pipeline;

    public SerialChannel() {
        this(null, new SerialSocketChannel(new SerialSelectorProvider()));
        ((SerialSocketChannel)this.javaChannel()).setChild(this);
    }

    protected SerialChannel(Channel parent, SelectableChannel ch) {
        super(parent, ch);
        this.config = new SerialChannelConfig(this);
        this.pipeline = this.newChannelPipeline();
    }

    @Override
    public AbstractNioChannel.NioUnsafe unsafe() {
        return new SerialNioUnsafe();
    }

    @Override
    public boolean isInputShutdown() {
        throw new NotImplementedException("");
    }

    @Override
    public ChannelFuture shutdownInput() {
        throw new NotImplementedException("");
    }

    @Override
    public ChannelFuture shutdownInput(ChannelPromise promise) {
        throw new NotImplementedException("");
    }

    @Override
    public boolean isOutputShutdown() {
        throw new NotImplementedException("");
    }

    @Override
    public ChannelFuture shutdownOutput() {
        throw new NotImplementedException("");
    }

    @Override
    public ChannelFuture shutdownOutput(ChannelPromise promise) {
        throw new NotImplementedException("");
    }

    @Override
    public boolean isShutdown() {
        throw new NotImplementedException("");
    }

    @Override
    public ChannelFuture shutdown() {
        throw new NotImplementedException("");
    }

    @Override
    public ChannelFuture shutdown(ChannelPromise promise) {
        throw new NotImplementedException("");
    }

    @Override
    protected long doWriteFileRegion(FileRegion region) throws Exception {
        throw new NotImplementedException("");
    }

    @Override
    protected int doReadBytes(ByteBuf buf) throws Exception {
        if (!this.active) {
            return 0;
        }
        logger.debug("Trying to read bytes from wire...");
        int bytesRead = this.comPort.read(buf);
        logger.debug("Read {} bytes from the wire", (Object)bytesRead);
        return bytesRead;
    }

    @Override
    protected int doWriteBytes(ByteBuf buf) throws Exception {
        if (!this.active) {
            return 0;
        }
        logger.debug("Trying to write bytes to wire...");
        int bytesWritten = this.comPort.write(buf);
        logger.debug("Wrote {} bytes to wire!", (Object)bytesWritten);
        return bytesWritten;
    }

    @Override
    protected boolean doConnect(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
        block4: {
            this.remoteAddress = remoteAddress;
            if (!(remoteAddress instanceof SerialSocketAddress)) {
                throw new IllegalArgumentException("Socket Address has to be of type " + SerialSocketAddress.class);
            }
            logger.debug("Connecting to Socket Address '{}'", (Object)((SerialSocketAddress)remoteAddress).getIdentifier());
            try {
                Optional<SerialChannelHandler> customHandler = ((SerialSocketAddress)remoteAddress).getHandler();
                this.comPort = customHandler.orElseGet(() -> new SerialChannelHandler.SerialPortHandler(remoteAddress, this.config));
                logger.debug("Using Com Port {}, trying to open port", (Object)this.comPort.getIdentifier());
                if (!this.comPort.open()) break block4;
                logger.debug("Opened port successful to {}", (Object)this.comPort.getIdentifier());
                this.comPort.registerSelectionKey(this.serialSelectionKey);
                this.active = true;
                return true;
            }
            catch (Exception e) {
                logger.warn("exception caught", (Throwable)e);
                this.active = false;
                return false;
            }
        }
        logger.debug("Unable to open port {}", (Object)this.comPort.getIdentifier());
        return false;
    }

    @Override
    protected void doClose() throws Exception {
        if (this.comPort != null) {
            this.comPort.close();
        }
    }

    @Override
    protected void doFinishConnect() throws Exception {
        throw new NotImplementedException("");
    }

    @Override
    protected SocketAddress localAddress0() {
        return null;
    }

    @Override
    protected SocketAddress remoteAddress0() {
        return null;
    }

    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
        throw new NotImplementedException("");
    }

    @Override
    protected void doDisconnect() throws Exception {
        throw new NotImplementedException("");
    }

    @Override
    public ChannelConfig config() {
        return this.config;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    private class SerialNioUnsafe
    implements AbstractNioChannel.NioUnsafe {
        private boolean inFlush0;
        private Throwable initialCloseCause;
        private final ChannelOutboundBuffer outboundBuffer;
        private RecvByteBufAllocator.Handle recvHandle;

        public SerialNioUnsafe() {
            try {
                Constructor ctor = ChannelOutboundBuffer.class.getDeclaredConstructor(AbstractChannel.class);
                ctor.setAccessible(true);
                this.outboundBuffer = (ChannelOutboundBuffer)ctor.newInstance(SerialChannel.this);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                logger.warn("Problem with reflection", (Throwable)e);
                throw new RuntimeException("Problem providing Buffer", e);
            }
        }

        @Override
        public SelectableChannel ch() {
            throw new NotImplementedException("");
        }

        @Override
        public void finishConnect() {
            throw new NotImplementedException("");
        }

        @Override
        public void read() {
            logger.debug("Reading...");
            ChannelConfig config = SerialChannel.this.config();
            ChannelPipeline pipeline = SerialChannel.this.pipeline();
            ByteBufAllocator allocator = config.getAllocator();
            RecvByteBufAllocator.Handle allocHandle = this.recvBufAllocHandle();
            allocHandle.reset(config);
            boolean close = false;
            try {
                try {
                    do {
                        ByteBuf byteBuf = allocHandle.allocate(allocator);
                        allocHandle.lastBytesRead(SerialChannel.this.doReadBytes(byteBuf));
                        if (allocHandle.lastBytesRead() <= 0) {
                            byteBuf.release();
                            byteBuf = null;
                            boolean bl = close = allocHandle.lastBytesRead() < 0;
                            if (!close) break;
                            SerialChannel.this.serialReadPending = false;
                            break;
                        }
                        allocHandle.incMessagesRead(1);
                        SerialChannel.this.serialReadPending = false;
                        pipeline.fireChannelRead(byteBuf);
                    } while (allocHandle.continueReading());
                    allocHandle.readComplete();
                    pipeline.fireChannelReadComplete();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    if (!SerialChannel.this.serialReadPending) {
                        config.isAutoRead();
                    }
                }
            }
            finally {
                if (!SerialChannel.this.serialReadPending) {
                    config.isAutoRead();
                }
            }
        }

        @Override
        public void forceFlush() {
            throw new NotImplementedException("");
        }

        @Override
        public RecvByteBufAllocator.Handle recvBufAllocHandle() {
            if (this.recvHandle == null) {
                this.recvHandle = SerialChannel.this.config().getRecvByteBufAllocator().newHandle();
            }
            return this.recvHandle;
        }

        @Override
        public SocketAddress localAddress() {
            throw new NotImplementedException("");
        }

        @Override
        public SocketAddress remoteAddress() {
            return null;
        }

        @Override
        public void register(EventLoop eventLoop, ChannelPromise promise) {
            if (!(eventLoop instanceof NioEventLoop)) {
                throw new IllegalArgumentException("Only valid for NioEventLoop!");
            }
            if (!(promise.channel() instanceof SerialChannel)) {
                throw new IllegalArgumentException("Only valid for " + SerialChannel.class + " but is " + promise.channel().getClass());
            }
            try {
                Method method = NioEventLoop.class.getDeclaredMethod("unwrappedSelector", new Class[0]);
                method.setAccessible(true);
                SerialPollingSelector selector = (SerialPollingSelector)method.invoke((Object)eventLoop, new Object[0]);
                SerialChannel.this.serialSelectionKey = (SerialSelectionKey)((SerialChannel)promise.channel()).javaChannel().register(selector, 0, SerialChannel.this);
                Field selectionKeyField = AbstractNioChannel.class.getDeclaredField("selectionKey");
                selectionKeyField.setAccessible(true);
                selectionKeyField.set(SerialChannel.this, SerialChannel.this.serialSelectionKey);
                Field loop = AbstractChannel.class.getDeclaredField("eventLoop");
                loop.setAccessible(true);
                loop.set(SerialChannel.this, eventLoop);
                if (!(SerialChannel.this.pipeline() instanceof DefaultChannelPipeline)) {
                    throw new IllegalStateException("Pipeline should be of Type " + DefaultChannelPipeline.class);
                }
                SerialChannel.this.eventLoop().execute(() -> {
                    try {
                        Method invokeHandlerAddedIfNeeded = DefaultChannelPipeline.class.getDeclaredMethod("invokeHandlerAddedIfNeeded", new Class[0]);
                        invokeHandlerAddedIfNeeded.setAccessible(true);
                        invokeHandlerAddedIfNeeded.invoke((Object)SerialChannel.this.pipeline(), new Object[0]);
                        SerialChannel.this.pipeline().fireChannelRegistered();
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                        logger.warn("Exception caught", (Throwable)e);
                    }
                });
                promise.setSuccess();
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException | ClosedChannelException e) {
                logger.warn("Exception caught", (Throwable)e);
                throw new NotImplementedException("Should register channel to event loop!!!");
            }
        }

        @Override
        public void bind(SocketAddress localAddress, ChannelPromise promise) {
            throw new NotImplementedException("");
        }

        @Override
        public void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            SerialChannel.this.remoteAddress = remoteAddress;
            SerialChannel.this.eventLoop().execute(() -> {
                try {
                    boolean success = SerialChannel.this.doConnect(remoteAddress, localAddress);
                    if (success) {
                        SerialChannel.this.pipeline().fireChannelActive();
                        promise.setSuccess();
                    } else {
                        promise.setFailure(new RuntimeException("Unable to open the com port '" + ((SerialSocketAddress)remoteAddress).getIdentifier() + "'"));
                    }
                }
                catch (Exception e) {
                    promise.setFailure(e);
                }
            });
        }

        @Override
        public void disconnect(ChannelPromise promise) {
            throw new NotImplementedException("");
        }

        @Override
        public void close(ChannelPromise promise) {
            logger.debug("Closing the Serial Port '{}'", (Object)((SerialSocketAddress)SerialChannel.this.remoteAddress).getIdentifier());
            SerialChannel.this.eventLoop().execute(() -> {
                try {
                    SerialChannel.this.doClose();
                    promise.setSuccess();
                }
                catch (Exception e) {
                    logger.warn("Unable to close the connection", (Throwable)e);
                    promise.setFailure(e);
                }
            });
        }

        @Override
        public void closeForcibly() {
        }

        @Override
        public void deregister(ChannelPromise promise) {
            throw new NotImplementedException("");
        }

        @Override
        public final void beginRead() {
            assert (SerialChannel.this.eventLoop().inEventLoop());
            if (!SerialChannel.this.isActive()) {
                return;
            }
            try {
                SerialChannel.this.doBeginRead();
            }
            catch (Exception e) {
                this.invokeLater(() -> {
                    ChannelPipeline channelPipeline = SerialChannel.this.pipeline().fireExceptionCaught(e);
                });
                this.close(this.voidPromise());
            }
        }

        private void invokeLater(Runnable task) {
            try {
                SerialChannel.this.eventLoop().execute(task);
            }
            catch (RejectedExecutionException e) {
                logger.warn("Can't invoke task later as EventLoop rejected it", (Throwable)e);
            }
        }

        @Override
        public void write(Object msg, ChannelPromise promise) {
            int size;
            assert (SerialChannel.this.eventLoop().inEventLoop());
            ChannelOutboundBuffer outboundBuffer = this.outboundBuffer;
            if (outboundBuffer == null) {
                this.close(this.voidPromise());
                ReferenceCountUtil.release(msg);
                throw new RuntimeException("Unable to write", this.initialCloseCause);
            }
            try {
                msg = SerialChannel.this.filterOutboundMessage(msg);
                Method estimatorHandle = DefaultChannelPipeline.class.getDeclaredMethod("estimatorHandle", new Class[0]);
                estimatorHandle.setAccessible(true);
                MessageSizeEstimator.Handle handle = (MessageSizeEstimator.Handle)estimatorHandle.invoke((Object)SerialChannel.this.pipeline, new Object[0]);
                size = handle.size(msg);
                if (size < 0) {
                    size = 0;
                }
            }
            catch (Throwable t) {
                this.close(this.voidPromise());
                ReferenceCountUtil.release(msg);
                logger.error("Problem during write", t);
                throw new RuntimeException("Problem during write", t);
            }
            outboundBuffer.addMessage(msg, size, promise);
        }

        @Override
        public final void flush() {
            assert (SerialChannel.this.eventLoop().inEventLoop());
            ChannelOutboundBuffer outboundBuffer = this.outboundBuffer;
            if (outboundBuffer == null) {
                return;
            }
            outboundBuffer.addFlush();
            this.flush0();
        }

        protected void flush0() {
            if (this.inFlush0) {
                return;
            }
            ChannelOutboundBuffer outboundBuffer = this.outboundBuffer;
            if (outboundBuffer == null || outboundBuffer.isEmpty()) {
                return;
            }
            this.inFlush0 = true;
            if (!SerialChannel.this.isActive()) {
                try {
                    if (SerialChannel.this.isOpen()) {
                        this.callFailFlushed(true);
                    } else {
                        this.callFailFlushed(false);
                    }
                }
                finally {
                    this.inFlush0 = false;
                }
                return;
            }
            try {
                try {
                    SerialChannel.this.doWrite(outboundBuffer);
                }
                catch (Throwable t) {
                    if (t instanceof IOException && SerialChannel.this.config().isAutoClose()) {
                        this.initialCloseCause = t;
                        this.close(this.voidPromise());
                        throw new RuntimeException("Unable to flush", t);
                    }
                    try {
                        SerialChannel.this.shutdownOutput(this.voidPromise());
                        throw new RuntimeException("Unable to flush", t);
                    }
                    catch (Throwable t2) {
                        this.initialCloseCause = t;
                        this.close(this.voidPromise());
                        throw new RuntimeException("Unable to flush", t);
                    }
                }
            }
            finally {
                this.inFlush0 = false;
            }
        }

        private void callFailFlushed(boolean notify) {
            try {
                Method failFlushed = ChannelOutboundBuffer.class.getDeclaredMethod("failFlushed", Throwable.class, Boolean.TYPE);
                failFlushed.setAccessible(true);
                failFlushed.invoke((Object)new RuntimeException("Unable to Flush!"), notify);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to call Failed Flushed!");
            }
        }

        @Override
        public ChannelPromise voidPromise() {
            return SerialChannel.this.unsafeVoidPromise;
        }

        @Override
        public ChannelOutboundBuffer outboundBuffer() {
            return this.outboundBuffer;
        }
    }
}

