/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.transport.tcp;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.net.SocketAddress;
import org.apache.plc4x.java.spi.configuration.HasConfiguration;
import org.apache.plc4x.java.spi.connection.NettyChannelFactory;
import org.apache.plc4x.java.transport.tcp.TcpTransportConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpChannelFactory
extends NettyChannelFactory
implements HasConfiguration<TcpTransportConfiguration> {
    private static final Logger logger = LoggerFactory.getLogger(TcpChannelFactory.class);
    private TcpTransportConfiguration configuration;

    public TcpChannelFactory(SocketAddress address) {
        super(address);
    }

    @Override
    public void setConfiguration(TcpTransportConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public Class<? extends Channel> getChannel() {
        return NioSocketChannel.class;
    }

    @Override
    public boolean isPassive() {
        return false;
    }

    @Override
    public void configureBootstrap(Bootstrap bootstrap) {
        if (this.configuration != null) {
            logger.info("Configuring Bootstrap with {}", (Object)this.configuration);
            bootstrap.option(ChannelOption.SO_KEEPALIVE, this.configuration.isKeepAlive());
            bootstrap.option(ChannelOption.TCP_NODELAY, this.configuration.isNoDelay());
            bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, this.configuration.getConnectTimeout());
        }
    }
}

