/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.utils.cache;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.plc4x.java.DefaultPlcDriverManager;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.PlcConnectionManager;
import org.apache.plc4x.java.api.authentication.PlcAuthentication;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.utils.cache.ConnectionContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedPlcConnectionManager
implements PlcConnectionManager {
    private static final Logger LOG = LoggerFactory.getLogger(CachedPlcConnectionManager.class);
    private final PlcConnectionManager connectionManager;
    private final Duration maxLeaseTime;
    private final Duration maxWaitTime;
    private final Map<String, ConnectionContainer> connectionContainers;

    public static Builder getBuilder() {
        return new Builder(new DefaultPlcDriverManager());
    }

    public static Builder getBuilder(PlcConnectionManager connectionManager) {
        return new Builder(connectionManager);
    }

    public CachedPlcConnectionManager(PlcConnectionManager connectionManager, Duration maxLeaseTime, Duration maxWaitTime) {
        this.connectionManager = connectionManager;
        this.maxLeaseTime = maxLeaseTime;
        this.maxWaitTime = maxWaitTime;
        this.connectionContainers = new HashMap<String, ConnectionContainer>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getCachedConnections() {
        Map<String, ConnectionContainer> map = this.connectionContainers;
        synchronized (map) {
            return this.connectionContainers.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCachedConnection(String url) {
        Map<String, ConnectionContainer> map = this.connectionContainers;
        synchronized (map) {
            this.connectionContainers.remove(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PlcConnection getConnection(String url) throws PlcConnectionException {
        ConnectionContainer connectionContainer;
        Map<String, ConnectionContainer> map = this.connectionContainers;
        synchronized (map) {
            connectionContainer = this.connectionContainers.get(url);
            if (this.connectionContainers.get(url) == null) {
                LOG.debug("Creating new connection");
                connectionContainer = new ConnectionContainer(this.connectionManager, url, this.maxLeaseTime);
                this.connectionContainers.put(url, connectionContainer);
            } else {
                LOG.debug("Reusing exising connection");
            }
        }
        Future<PlcConnection> leaseFuture = connectionContainer.lease();
        try {
            return leaseFuture.get(this.maxWaitTime.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new PlcConnectionException("Error acquiring lease for connection", e);
        }
    }

    @Override
    public PlcConnection getConnection(String url, PlcAuthentication authentication) throws PlcConnectionException {
        throw new PlcConnectionException("the cached driver manager currently doesn't support authentication");
    }

    public static class Builder {
        private final PlcConnectionManager connectionManager;
        private Duration maxLeaseTime;
        private Duration maxWaitTime;

        public Builder(PlcConnectionManager connectionManager) {
            this.connectionManager = connectionManager;
            this.maxLeaseTime = Duration.ofSeconds(4L);
            this.maxWaitTime = Duration.ofSeconds(20L);
        }

        public CachedPlcConnectionManager build() {
            return new CachedPlcConnectionManager(this.connectionManager, this.maxLeaseTime, this.maxWaitTime);
        }

        public Builder withMaxLeaseTime(Duration maxLeaseTime) {
            this.maxLeaseTime = maxLeaseTime;
            return this;
        }

        public Builder withMaxWaitTime(Duration maxWaitTime) {
            this.maxWaitTime = maxWaitTime;
            return this;
        }
    }
}

