/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.utils.cache;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcBrowseRequest;
import org.apache.plc4x.java.api.messages.PlcBrowseRequestInterceptor;
import org.apache.plc4x.java.api.messages.PlcBrowseResponse;
import org.apache.plc4x.java.api.messages.PlcPingResponse;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.messages.PlcSubscriptionEvent;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.metadata.PlcConnectionMetadata;
import org.apache.plc4x.java.api.model.PlcQuery;
import org.apache.plc4x.java.api.model.PlcSubscriptionHandle;
import org.apache.plc4x.java.api.model.PlcSubscriptionTag;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.utils.cache.ConnectionContainer;

public class LeasedPlcConnection
implements PlcConnection {
    private final ConnectionContainer connectionContainer;
    private final AtomicReference<PlcConnection> connection;
    private boolean invalidateConnection;
    private final Timer usageTimer;

    LeasedPlcConnection(ConnectionContainer connectionContainer, PlcConnection connection, Duration maxUseTime) {
        this.connectionContainer = connectionContainer;
        this.connection = new AtomicReference<PlcConnection>(connection);
        this.invalidateConnection = false;
        this.usageTimer = new Timer();
        this.usageTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                LeasedPlcConnection.this.close();
            }
        }, Date.from(LocalDateTime.now().plusNanos(maxUseTime.toNanos()).atZone(ZoneId.systemDefault()).toInstant()));
    }

    @Override
    public synchronized void close() {
        if (this.connection.get() == null) {
            return;
        }
        this.usageTimer.cancel();
        this.connection.set(null);
        this.connectionContainer.returnConnection(this, this.invalidateConnection);
    }

    @Override
    public void connect() throws PlcConnectionException {
        throw new PlcConnectionException("Error connecting leased connection");
    }

    @Override
    public boolean isConnected() {
        PlcConnection plcConnection = this.connection.get();
        if (plcConnection == null) {
            throw new PlcRuntimeException("Error using leased connection after returning it to the cache.");
        }
        return plcConnection.isConnected();
    }

    @Override
    public PlcConnectionMetadata getMetadata() {
        PlcConnection plcConnection = this.connection.get();
        if (plcConnection == null) {
            throw new PlcRuntimeException("Error using leased connection after returning it to the cache.");
        }
        return plcConnection.getMetadata();
    }

    @Override
    public CompletableFuture<? extends PlcPingResponse> ping() {
        PlcConnection plcConnection = this.connection.get();
        if (plcConnection == null) {
            throw new PlcRuntimeException("Error using leased connection after returning it to the cache.");
        }
        return plcConnection.ping();
    }

    @Override
    public PlcReadRequest.Builder readRequestBuilder() {
        PlcConnection plcConnection = this.connection.get();
        if (plcConnection == null) {
            throw new PlcRuntimeException("Error using leased connection after returning it to the cache.");
        }
        final PlcReadRequest.Builder innerBuilder = plcConnection.readRequestBuilder();
        return new PlcReadRequest.Builder(){

            @Override
            public PlcReadRequest build() {
                final PlcReadRequest innerPlcReadRequest = innerBuilder.build();
                return new PlcReadRequest(){

                    @Override
                    public CompletableFuture<? extends PlcReadResponse> execute() {
                        CompletableFuture<? extends PlcReadResponse> future = innerPlcReadRequest.execute();
                        CompletableFuture responseFuture = new CompletableFuture();
                        future.handle((plcReadResponse, throwable) -> {
                            if (throwable == null) {
                                responseFuture.complete(plcReadResponse);
                            } else {
                                (this).LeasedPlcConnection.this.invalidateConnection = true;
                                responseFuture.completeExceptionally((Throwable)throwable);
                            }
                            return null;
                        });
                        return responseFuture;
                    }

                    @Override
                    public int getNumberOfTags() {
                        return innerPlcReadRequest.getNumberOfTags();
                    }

                    @Override
                    public LinkedHashSet<String> getTagNames() {
                        return innerPlcReadRequest.getTagNames();
                    }

                    @Override
                    public PlcTag getTag(String name) {
                        return innerPlcReadRequest.getTag(name);
                    }

                    @Override
                    public List<PlcTag> getTags() {
                        return innerPlcReadRequest.getTags();
                    }
                };
            }

            @Override
            public PlcReadRequest.Builder addTagAddress(String name, String tagAddress) {
                return innerBuilder.addTagAddress(name, tagAddress);
            }

            @Override
            public PlcReadRequest.Builder addTag(String name, PlcTag tag) {
                return innerBuilder.addTag(name, tag);
            }
        };
    }

    @Override
    public PlcWriteRequest.Builder writeRequestBuilder() {
        PlcConnection plcConnection = this.connection.get();
        if (plcConnection == null) {
            throw new PlcRuntimeException("Error using leased connection after returning it to the cache.");
        }
        final PlcWriteRequest.Builder innerBuilder = plcConnection.writeRequestBuilder();
        return new PlcWriteRequest.Builder(){

            @Override
            public PlcWriteRequest build() {
                final PlcWriteRequest innerPlcWriteRequest = innerBuilder.build();
                return new PlcWriteRequest(){

                    @Override
                    public CompletableFuture<? extends PlcWriteResponse> execute() {
                        CompletableFuture<? extends PlcWriteResponse> future = innerPlcWriteRequest.execute();
                        CompletableFuture responseFuture = new CompletableFuture();
                        future.handle((plcWriteResponse, throwable) -> {
                            if (throwable == null) {
                                responseFuture.complete(plcWriteResponse);
                            } else {
                                (this).LeasedPlcConnection.this.invalidateConnection = true;
                                responseFuture.completeExceptionally((Throwable)throwable);
                            }
                            return null;
                        });
                        return responseFuture;
                    }

                    @Override
                    public int getNumberOfValues(String name) {
                        return innerPlcWriteRequest.getNumberOfValues(name);
                    }

                    @Override
                    public PlcValue getPlcValue(String name) {
                        return innerPlcWriteRequest.getPlcValue(name);
                    }

                    @Override
                    public int getNumberOfTags() {
                        return innerPlcWriteRequest.getNumberOfTags();
                    }

                    @Override
                    public LinkedHashSet<String> getTagNames() {
                        return innerPlcWriteRequest.getTagNames();
                    }

                    @Override
                    public PlcTag getTag(String name) {
                        return innerPlcWriteRequest.getTag(name);
                    }

                    @Override
                    public List<PlcTag> getTags() {
                        return innerPlcWriteRequest.getTags();
                    }
                };
            }

            @Override
            public PlcWriteRequest.Builder addTagAddress(String name, String tagAddress, Object ... values) {
                return innerBuilder.addTagAddress(name, tagAddress, values);
            }

            @Override
            public PlcWriteRequest.Builder addTag(String name, PlcTag tag, Object ... values) {
                return innerBuilder.addTag(name, tag, values);
            }
        };
    }

    @Override
    public PlcSubscriptionRequest.Builder subscriptionRequestBuilder() {
        PlcConnection plcConnection = this.connection.get();
        if (plcConnection == null) {
            throw new PlcRuntimeException("Error using leased connection after returning it to the cache.");
        }
        final PlcSubscriptionRequest.Builder innerBuilder = plcConnection.subscriptionRequestBuilder();
        return new PlcSubscriptionRequest.Builder(){

            @Override
            public PlcSubscriptionRequest build() {
                final PlcSubscriptionRequest innerPlcSubscriptionRequest = innerBuilder.build();
                return new PlcSubscriptionRequest(){

                    @Override
                    public CompletableFuture<? extends PlcSubscriptionResponse> execute() {
                        CompletableFuture<? extends PlcSubscriptionResponse> future = innerPlcSubscriptionRequest.execute();
                        CompletableFuture responseFuture = new CompletableFuture();
                        future.handle((plcSubscriptionResponse, throwable) -> {
                            if (throwable == null) {
                                responseFuture.complete(plcSubscriptionResponse);
                            } else {
                                (this).LeasedPlcConnection.this.invalidateConnection = true;
                                responseFuture.completeExceptionally((Throwable)throwable);
                            }
                            return null;
                        });
                        return responseFuture;
                    }

                    @Override
                    public int getNumberOfTags() {
                        return innerPlcSubscriptionRequest.getNumberOfTags();
                    }

                    @Override
                    public LinkedHashSet<String> getTagNames() {
                        return innerPlcSubscriptionRequest.getTagNames();
                    }

                    @Override
                    public PlcSubscriptionTag getTag(String name) {
                        return innerPlcSubscriptionRequest.getTag(name);
                    }

                    @Override
                    public List<PlcSubscriptionTag> getTags() {
                        return innerPlcSubscriptionRequest.getTags();
                    }

                    @Override
                    public Map<String, List<Consumer<PlcSubscriptionEvent>>> getPreRegisteredConsumers() {
                        return innerPlcSubscriptionRequest.getPreRegisteredConsumers();
                    }
                };
            }

            @Override
            public PlcSubscriptionRequest.Builder addCyclicTagAddress(String name, String tagAddress, Duration pollingInterval) {
                return innerBuilder.addCyclicTagAddress(name, tagAddress, pollingInterval);
            }

            @Override
            public PlcSubscriptionRequest.Builder addCyclicTag(String name, PlcTag tag, Duration pollingInterval) {
                return innerBuilder.addCyclicTag(name, tag, pollingInterval);
            }

            @Override
            public PlcSubscriptionRequest.Builder addChangeOfStateTagAddress(String name, String tagAddress) {
                return innerBuilder.addChangeOfStateTagAddress(name, tagAddress);
            }

            @Override
            public PlcSubscriptionRequest.Builder addChangeOfStateTag(String name, PlcTag tag) {
                return innerBuilder.addChangeOfStateTag(name, tag);
            }

            @Override
            public PlcSubscriptionRequest.Builder addEventTagAddress(String name, String tagAddress) {
                return innerBuilder.addEventTagAddress(name, tagAddress);
            }

            @Override
            public PlcSubscriptionRequest.Builder addEventTag(String name, PlcTag tag) {
                return innerBuilder.addEventTag(name, tag);
            }

            @Override
            public PlcSubscriptionRequest.Builder addPreRegisteredConsumer(String name, Consumer<PlcSubscriptionEvent> preRegisteredConsumer) {
                return innerBuilder.addPreRegisteredConsumer(name, preRegisteredConsumer);
            }
        };
    }

    @Override
    public PlcUnsubscriptionRequest.Builder unsubscriptionRequestBuilder() {
        PlcConnection plcConnection = this.connection.get();
        if (plcConnection == null) {
            throw new PlcRuntimeException("Error using leased connection after returning it to the cache.");
        }
        final PlcUnsubscriptionRequest.Builder innerBuilder = plcConnection.unsubscriptionRequestBuilder();
        return new PlcUnsubscriptionRequest.Builder(){

            @Override
            public PlcUnsubscriptionRequest build() {
                final PlcUnsubscriptionRequest innerPlcUnsubscriptionRequest = innerBuilder.build();
                return new PlcUnsubscriptionRequest(){

                    @Override
                    public CompletableFuture<PlcUnsubscriptionResponse> execute() {
                        CompletableFuture<PlcUnsubscriptionResponse> future = innerPlcUnsubscriptionRequest.execute();
                        CompletableFuture<PlcUnsubscriptionResponse> responseFuture = new CompletableFuture<PlcUnsubscriptionResponse>();
                        future.handle((plcUnsubscriptionResponse, throwable) -> {
                            if (throwable == null) {
                                responseFuture.complete((PlcUnsubscriptionResponse)plcUnsubscriptionResponse);
                            } else {
                                (this).LeasedPlcConnection.this.invalidateConnection = true;
                                responseFuture.completeExceptionally((Throwable)throwable);
                            }
                            return null;
                        });
                        return responseFuture;
                    }

                    @Override
                    public List<PlcSubscriptionHandle> getSubscriptionHandles() {
                        return innerPlcUnsubscriptionRequest.getSubscriptionHandles();
                    }
                };
            }

            @Override
            public PlcUnsubscriptionRequest.Builder addHandles(PlcSubscriptionHandle plcSubscriptionHandle) {
                return innerBuilder.addHandles(plcSubscriptionHandle);
            }

            @Override
            public PlcUnsubscriptionRequest.Builder addHandles(PlcSubscriptionHandle plcSubscriptionHandle1, PlcSubscriptionHandle ... plcSubscriptionHandles) {
                return innerBuilder.addHandles(plcSubscriptionHandle1, plcSubscriptionHandles);
            }

            @Override
            public PlcUnsubscriptionRequest.Builder addHandles(Collection<PlcSubscriptionHandle> plcSubscriptionHandle) {
                return innerBuilder.addHandles(plcSubscriptionHandle);
            }
        };
    }

    @Override
    public PlcBrowseRequest.Builder browseRequestBuilder() {
        PlcConnection plcConnection = this.connection.get();
        if (plcConnection == null) {
            throw new PlcRuntimeException("Error using leased connection after returning it to the cache.");
        }
        final PlcBrowseRequest.Builder innerBuilder = plcConnection.browseRequestBuilder();
        return new PlcBrowseRequest.Builder(){

            @Override
            public PlcBrowseRequest build() {
                final PlcBrowseRequest innerPlcBrowseRequest = innerBuilder.build();
                return new PlcBrowseRequest(){

                    @Override
                    public CompletableFuture<? extends PlcBrowseResponse> execute() {
                        CompletableFuture<? extends PlcBrowseResponse> future = innerPlcBrowseRequest.execute();
                        CompletableFuture responseFuture = new CompletableFuture();
                        future.handle((plcBrowseResponse, throwable) -> {
                            if (throwable == null) {
                                responseFuture.complete(plcBrowseResponse);
                            } else {
                                (this).LeasedPlcConnection.this.invalidateConnection = true;
                                responseFuture.completeExceptionally((Throwable)throwable);
                            }
                            return null;
                        });
                        return responseFuture;
                    }

                    @Override
                    public CompletableFuture<? extends PlcBrowseResponse> executeWithInterceptor(PlcBrowseRequestInterceptor interceptor) {
                        CompletableFuture<? extends PlcBrowseResponse> future = innerPlcBrowseRequest.executeWithInterceptor(interceptor);
                        CompletableFuture responseFuture = new CompletableFuture();
                        future.handle((plcBrowseResponse, throwable) -> {
                            if (throwable == null) {
                                responseFuture.complete(plcBrowseResponse);
                            } else {
                                (this).LeasedPlcConnection.this.invalidateConnection = true;
                                responseFuture.completeExceptionally((Throwable)throwable);
                            }
                            return null;
                        });
                        return responseFuture;
                    }

                    @Override
                    public LinkedHashSet<String> getQueryNames() {
                        return innerPlcBrowseRequest.getQueryNames();
                    }

                    @Override
                    public PlcQuery getQuery(String name) {
                        return innerPlcBrowseRequest.getQuery(name);
                    }
                };
            }

            @Override
            public PlcBrowseRequest.Builder addQuery(String name, String query) {
                return innerBuilder.addQuery(name, query);
            }
        };
    }

    static /* synthetic */ void access$0(LeasedPlcConnection leasedPlcConnection, boolean bl) {
        leasedPlcConnection.invalidateConnection = bl;
    }
}

