/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.List;
import org.pcap4j.packet.IcmpIdentifiablePacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.util.ByteArrays;

public final class IcmpV4TimestampPacket
extends IcmpIdentifiablePacket {
    private static final long serialVersionUID = -122451430580609855L;
    private final IcmpV4TimestampHeader header;

    public static IcmpV4TimestampPacket newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new IcmpV4TimestampPacket(rawData, offset, length);
    }

    private IcmpV4TimestampPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        this.header = new IcmpV4TimestampHeader(rawData, offset, length);
    }

    private IcmpV4TimestampPacket(Builder builder) {
        super(builder);
        this.header = new IcmpV4TimestampHeader(builder);
    }

    @Override
    public IcmpV4TimestampHeader getHeader() {
        return this.header;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class IcmpV4TimestampHeader
    extends IcmpIdentifiablePacket.IcmpIdentifiableHeader {
        private static final long serialVersionUID = -5997732668989705976L;
        private static final int ORIGINATE_TIMESTAMP_OFFSET = 4;
        private static final int ORIGINATE_TIMESTAMP_SIZE = 4;
        private static final int RECEIVE_TIMESTAMP_OFFSET = 8;
        private static final int RECEIVE_TIMESTAMP_SIZE = 4;
        private static final int TRANSMIT_TIMESTAMP_OFFSET = 12;
        private static final int TRANSMIT_TIMESTAMP_SIZE = 4;
        private static final int ICMPV4_TIMESTAMP_HEADER_SIZE = 16;
        private final int originateTimestamp;
        private final int receiveTimestamp;
        private final int transmitTimestamp;

        private IcmpV4TimestampHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            super(rawData, offset, length);
            if (length < 16) {
                StringBuilder sb = new StringBuilder(80);
                sb.append("The data is too short to build an ").append(this.getHeaderName()).append("(").append(16).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            this.originateTimestamp = ByteArrays.getInt(rawData, 4 + offset);
            this.receiveTimestamp = ByteArrays.getInt(rawData, 8 + offset);
            this.transmitTimestamp = ByteArrays.getInt(rawData, 12 + offset);
        }

        private IcmpV4TimestampHeader(Builder builder) {
            super(builder);
            this.originateTimestamp = builder.originateTimestamp;
            this.receiveTimestamp = builder.receiveTimestamp;
            this.transmitTimestamp = builder.transmitTimestamp;
        }

        public int getOriginateTimestamp() {
            return this.originateTimestamp;
        }

        public int getReceiveTimestamp() {
            return this.receiveTimestamp;
        }

        public int getTransmitTimestamp() {
            return this.transmitTimestamp;
        }

        @Override
        protected List<byte[]> getRawFields() {
            List<byte[]> rawFields = super.getRawFields();
            rawFields.add(ByteArrays.toByteArray(this.originateTimestamp));
            rawFields.add(ByteArrays.toByteArray(this.receiveTimestamp));
            rawFields.add(ByteArrays.toByteArray(this.transmitTimestamp));
            return rawFields;
        }

        @Override
        public int length() {
            return 16;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append(super.buildString());
            sb.append("  Originate Timestamp: ").append(this.originateTimestamp).append(ls);
            sb.append("  Receive Timestamp: ").append(this.receiveTimestamp).append(ls);
            sb.append("  Transmit Timestamp: ").append(this.transmitTimestamp).append(ls);
            return sb.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            IcmpV4TimestampHeader other = (IcmpV4TimestampHeader)obj;
            return this.originateTimestamp == other.originateTimestamp && this.receiveTimestamp == other.receiveTimestamp && this.transmitTimestamp == other.transmitTimestamp;
        }

        @Override
        protected int calcHashCode() {
            int result = super.calcHashCode();
            result = 31 * result + this.originateTimestamp;
            result = 31 * result + this.receiveTimestamp;
            result = 31 * result + this.transmitTimestamp;
            return result;
        }

        @Override
        protected String getHeaderName() {
            return "ICMPv4 Timestamp Header";
        }
    }

    public static final class Builder
    extends IcmpIdentifiablePacket.Builder {
        private int originateTimestamp;
        private int receiveTimestamp;
        private int transmitTimestamp;

        public Builder() {
        }

        private Builder(IcmpV4TimestampPacket packet) {
            super(packet);
            this.originateTimestamp = packet.header.originateTimestamp;
            this.receiveTimestamp = packet.header.receiveTimestamp;
            this.transmitTimestamp = packet.header.transmitTimestamp;
        }

        @Override
        public Builder identifier(short identifier) {
            super.identifier(identifier);
            return this;
        }

        @Override
        public Builder sequenceNumber(short sequenceNumber) {
            super.sequenceNumber(sequenceNumber);
            return this;
        }

        public Builder originateTimestamp(int originateTimestamp) {
            this.originateTimestamp = originateTimestamp;
            return this;
        }

        public Builder receiveTimestamp(int receiveTimestamp) {
            this.receiveTimestamp = receiveTimestamp;
            return this;
        }

        public Builder transmitTimestamp(int transmitTimestamp) {
            this.transmitTimestamp = transmitTimestamp;
            return this;
        }

        @Override
        public IcmpV4TimestampPacket build() {
            return new IcmpV4TimestampPacket(this);
        }
    }
}

