/*
 * Decompiled with CFR 0.152.
 */
package jtermios.windows;

import com.sun.jna.FromNativeContext;
import com.sun.jna.IntegerType;
import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.StdCallLibrary;
import com.sun.jna.win32.W32APIOptions;
import java.util.Arrays;
import java.util.List;
import jtermios.JTermios;

public class WinAPI {
    private static Windows_kernel32_lib m_K32lib;
    private static Windows_kernel32_lib_Direct m_K32libDM;
    private static WaitMultiple m_K32libWM;
    private static final ThreadLocal<int[]> LastError;
    public static HANDLE INVALID_HANDLE_VALUE;
    public static HANDLE NULL;
    public static final int ERROR_INSUFFICIENT_BUFFER = 122;
    public static final int MAXDWORD = -1;
    public static final int STATUS_WAIT_0 = 0;
    public static final int STATUS_ABANDONED_WAIT_0 = 128;
    public static final int WAIT_ABANDONED = 128;
    public static final int WAIT_ABANDONED_0 = 128;
    public static final int WAIT_OBJECT_0 = 0;
    public static final int WAIT_FAILED = -1;
    public static final int INFINITE = -1;
    public static final int WAIT_TIMEOUT = 258;
    public static final int GENERIC_READ = Integer.MIN_VALUE;
    public static final int GENERIC_WRITE = 0x40000000;
    public static final int GENERIC_EXECUTE = 0x20000000;
    public static final int GENERIC_ALL = 0x10000000;
    public static final int CREATE_NEW = 1;
    public static final int CREATE_ALWAYS = 2;
    public static final int OPEN_EXISTING = 3;
    public static final int OPEN_ALWAYS = 4;
    public static final int TRUNCATE_EXISTING = 5;
    public static final int PURGE_TXABORT = 1;
    public static final int PURGE_RXABORT = 2;
    public static final int PURGE_TXCLEAR = 4;
    public static final int PURGE_RXCLEAR = 8;
    public static final int MS_CTS_ON = 16;
    public static final int MS_DSR_ON = 32;
    public static final int MS_RING_ON = 64;
    public static final int MS_RLSD_ON = 128;
    public static final int SETXOFF = 1;
    public static final int SETXON = 2;
    public static final int SETRTS = 3;
    public static final int CLRRTS = 4;
    public static final int SETDTR = 5;
    public static final int CLRDTR = 6;
    public static final int RESETDEV = 7;
    public static final int SETBREAK = 8;
    public static final int CLRBREAK = 9;
    public static final int FILE_FLAG_WRITE_THROUGH = Integer.MIN_VALUE;
    public static final int FILE_FLAG_OVERLAPPED = 0x40000000;
    public static final int FILE_FLAG_NO_BUFFERING = 0x20000000;
    public static final int FILE_FLAG_RANDOM_ACCESS = 0x10000000;
    public static final int FILE_FLAG_SEQUENTIAL_SCAN = 0x8000000;
    public static final int FILE_FLAG_DELETE_ON_CLOSE = 0x4000000;
    public static final int FILE_FLAG_BACKUP_SEMANTICS = 0x2000000;
    public static final int FILE_FLAG_POSIX_SEMANTICS = 0x1000000;
    public static final int FILE_FLAG_OPEN_REPARSE_POINT = 0x200000;
    public static final int FILE_FLAG_OPEN_NO_RECALL = 0x100000;
    public static final int FILE_FLAG_FIRST_PIPE_INSTANCE = 524288;
    public static final int ERROR_OPERATION_ABORTED = 995;
    public static final int ERROR_IO_INCOMPLETE = 996;
    public static final int ERROR_IO_PENDING = 997;
    public static final int ERROR_INVALID_PARAMETER = 87;
    public static final int ERROR_BROKEN_PIPE = 109;
    public static final int ERROR_MORE_DATA = 234;
    public static final int ERROR_FILE_NOT_FOUND = 2;
    public static final byte NOPARITY = 0;
    public static final byte ODDPARITY = 1;
    public static final byte EVENPARITY = 2;
    public static final byte MARKPARITY = 3;
    public static final byte SPACEPARITY = 4;
    public static final byte ONESTOPBIT = 0;
    public static final byte ONE5STOPBITS = 1;
    public static final byte TWOSTOPBITS = 2;
    public static final int CBR_110 = 110;
    public static final int CBR_300 = 300;
    public static final int CBR_600 = 600;
    public static final int CBR_1200 = 1200;
    public static final int CBR_2400 = 2400;
    public static final int CBR_4800 = 4800;
    public static final int CBR_9600 = 9600;
    public static final int CBR_14400 = 14400;
    public static final int CBR_19200 = 19200;
    public static final int CBR_38400 = 38400;
    public static final int CBR_56000 = 56000;
    public static final int CBR_57600 = 57600;
    public static final int CBR_115200 = 115200;
    public static final int CBR_128000 = 128000;
    public static final int CBR_256000 = 256000;
    public static final int CE_RXOVER = 1;
    public static final int CE_OVERRUN = 2;
    public static final int CE_RXPARITY = 4;
    public static final int CE_FRAME = 8;
    public static final int CE_BREAK = 16;
    public static final int CE_TXFULL = 256;
    public static final int CE_PTO = 512;
    public static final int CE_IOE = 1024;
    public static final int CE_DNS = 2048;
    public static final int CE_OOP = 4096;
    public static final int CE_MODE = 32768;
    public static final int IE_BADID = -1;
    public static final int IE_OPEN = -2;
    public static final int IE_NOPEN = -3;
    public static final int IE_MEMORY = -4;
    public static final int IE_DEFAULT = -5;
    public static final int IE_HARDWARE = -10;
    public static final int IE_BYTESIZE = -11;
    public static final int IE_BAUDRATE = -12;
    public static final int EV_RXCHAR = 1;
    public static final int EV_RXFLAG = 2;
    public static final int EV_TXEMPTY = 4;
    public static final int EV_CTS = 8;
    public static final int EV_DSR = 16;
    public static final int EV_RLSD = 32;
    public static final int EV_BREAK = 64;
    public static final int EV_ERR = 128;
    public static final int EV_RING = 256;
    public static final int EV_PERR = 512;
    public static final int EV_RX80FULL = 1024;
    public static final int EV_EVENT1 = 2048;
    public static final int EV_EVENT2 = 4096;
    public static final int FORMAT_MESSAGE_ALLOCATE_BUFFER = 256;
    public static final int FORMAT_MESSAGE_IGNORE_INSERTS = 512;
    public static final int FORMAT_MESSAGE_FROM_STRING = 1024;
    public static final int FORMAT_MESSAGE_FROM_HMODULE = 2048;
    public static final int FORMAT_MESSAGE_FROM_SYSTEM = 4096;
    public static final int FORMAT_MESSAGE_ARGUMENT_ARRAY = 8192;
    public static final int FORMAT_MESSAGE_MAX_WIDTH_MASK = 255;
    public static final int LANG_NEUTRAL = 0;
    public static final int SUBLANG_DEFAULT = 1;

    public static int MAKELANGID(int p, int s) {
        return s << 10 | p;
    }

    public static HANDLE CreateFile(String name, int access, int sharing, SECURITY_ATTRIBUTES security, int create, int attribs, Pointer template) {
        HANDLE h;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> CreateFileA(%s, 0x%08X, 0x%08X, %s, 0x%08X, 0x%08X,%s)\n", name, access, sharing, security, create, attribs, template);
        try {
            h = m_K32lib.CreateFile(name, access, sharing, security, create, attribs, template);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException le) {
            h = INVALID_HANDLE_VALUE;
            WinAPI.LastError.get()[0] = le.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< CreateFileA(%s, 0x%08X, 0x%08X, %s, 0x%08X, 0x%08X,%s) => %s\n", name, access, sharing, security, create, attribs, template, h);
        return h;
    }

    public static boolean WriteFile(HANDLE hFile, byte[] buf, int wrn, int[] nwrtn) {
        boolean res;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> WriteFile(%s, %s, %d, [%d])\n", hFile, JTermios.JTermiosLogging.log(buf, wrn), wrn, nwrtn[0]);
        try {
            res = m_K32lib.WriteFile(hFile, buf, wrn, nwrtn, null);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException le) {
            res = false;
            WinAPI.LastError.get()[0] = le.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< WriteFile(%s, %s, %d, [%d]) => %s\n", hFile, JTermios.JTermiosLogging.log(buf, wrn), wrn, nwrtn[0], res);
        return res;
    }

    public static boolean WriteFile(HANDLE hFile, Pointer buf, int wrn, int[] nwrtn, OVERLAPPED ovrlp) {
        boolean res;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> WriteFile(%s, %s, %d, [%d], %s)\n", hFile, JTermios.JTermiosLogging.log(buf.getByteArray(0L, wrn), 5), wrn, nwrtn[0], JTermios.JTermiosLogging.ref(ovrlp));
        try {
            res = m_K32lib.WriteFile(hFile, buf, wrn, nwrtn, ovrlp.getPointer());
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException le) {
            res = false;
            WinAPI.LastError.get()[0] = le.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< WriteFile(%s, %s, %d, [%d], %s) => %s\n", hFile, JTermios.JTermiosLogging.log(buf.getByteArray(0L, wrn), 5), wrn, nwrtn[0], JTermios.JTermiosLogging.ref(ovrlp), res);
        return res;
    }

    public static boolean ReadFile(HANDLE hFile, byte[] buf, int rdn, int[] nrd) {
        boolean res;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> ReadFile(%s, %s, %d, [%d])\n", hFile, JTermios.JTermiosLogging.log(buf, rdn), rdn, nrd[0]);
        try {
            res = m_K32lib.ReadFile(hFile, buf, rdn, nrd, null);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException le) {
            res = false;
            WinAPI.LastError.get()[0] = le.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< ReadFile(%s, %s, %d, [%d]) => %s\n", hFile, JTermios.JTermiosLogging.log(buf, rdn), rdn, nrd[0], res);
        return res;
    }

    public static boolean ReadFile(HANDLE hFile, Pointer buf, int rdn, int[] nrd, OVERLAPPED ovrlp) {
        boolean res;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> ReadFile(%s, %s, %d, [%d], %s)\n", hFile, JTermios.JTermiosLogging.log(buf.getByteArray(0L, rdn), 5), rdn, nrd[0], JTermios.JTermiosLogging.ref(ovrlp));
        try {
            res = m_K32lib.ReadFile(hFile, buf, rdn, nrd, ovrlp.getPointer());
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException le) {
            res = false;
            WinAPI.LastError.get()[0] = le.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< ReadFile(%s, %s, %d, [%d], %s) => %s\n", hFile, JTermios.JTermiosLogging.log(buf.getByteArray(0L, rdn), 5), rdn, nrd[0], JTermios.JTermiosLogging.ref(ovrlp), res);
        return res;
    }

    public static boolean FlushFileBuffers(HANDLE hFile) {
        boolean res;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> FlushFileBuffers(%s)\n", hFile);
        try {
            res = m_K32lib.FlushFileBuffers(hFile);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException le) {
            res = false;
            WinAPI.LastError.get()[0] = le.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< FlushFileBuffers(%s) => %s\n", hFile, res);
        return res;
    }

    public static boolean PurgeComm(HANDLE hFile, int qmask) {
        boolean res;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> PurgeComm(%s,0x%08X)\n", hFile, qmask);
        try {
            res = m_K32lib.PurgeComm(hFile, qmask);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException le) {
            res = false;
            WinAPI.LastError.get()[0] = le.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< PurgeComm(%s,0x%08X) => %s\n", hFile, qmask, res);
        return res;
    }

    public static boolean CancelIo(HANDLE hFile) {
        boolean res;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> CancelIo(%s)\n", hFile);
        try {
            res = m_K32lib.CancelIo(hFile);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException le) {
            res = false;
            WinAPI.LastError.get()[0] = le.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< CancelIo(%s) => %s\n", hFile, res);
        return res;
    }

    public static boolean CloseHandle(HANDLE hFile) {
        boolean res;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> CloseHandle(%s)\n", hFile);
        try {
            res = m_K32lib.CloseHandle(hFile);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException le) {
            res = false;
            WinAPI.LastError.get()[0] = le.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< CloseHandle(%s) => %s\n", hFile, res);
        return res;
    }

    public static boolean ClearCommError(HANDLE hFile, int[] n, COMSTAT s) {
        boolean res;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> ClearCommError(%s, [%d], %s)\n", hFile, n[0], s);
        try {
            res = m_K32lib.ClearCommError(hFile, n, s);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException le) {
            res = false;
            WinAPI.LastError.get()[0] = le.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< ClearCommError(%s, [%d], %s) => %s\n", hFile, n[0], s, res);
        return res;
    }

    public static boolean SetCommMask(HANDLE hFile, int mask) {
        boolean res;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> SetCommMask(%s, 0x%08X)\n", hFile, mask);
        try {
            res = m_K32lib.SetCommMask(hFile, mask);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException le) {
            res = false;
            WinAPI.LastError.get()[0] = le.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< SetCommMask(%s, 0x%08X) => %s\n", hFile, mask, res);
        return res;
    }

    public static boolean GetCommMask(HANDLE hFile, int[] mask) {
        boolean res;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> GetCommMask(%s, [0x%08X])\n", hFile, mask[0]);
        try {
            res = m_K32lib.GetCommMask(hFile, mask);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException le) {
            res = false;
            WinAPI.LastError.get()[0] = le.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< GetCommMask(%s, [0x%08X]) => %s\n", hFile, mask[0], res);
        return res;
    }

    public static boolean GetCommState(HANDLE hFile, DCB dcb) {
        boolean res;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> GetCommState(%s, %s)\n", hFile, dcb);
        try {
            res = m_K32lib.GetCommState(hFile, dcb);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException le) {
            res = false;
            WinAPI.LastError.get()[0] = le.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< GetCommState(%s, %s) => %s\n", hFile, dcb, res);
        return res;
    }

    public static boolean SetCommState(HANDLE hFile, DCB dcb) {
        boolean res;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> SetCommState(%s, %s)\n", hFile, dcb);
        try {
            res = m_K32lib.SetCommState(hFile, dcb);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException le) {
            res = false;
            WinAPI.LastError.get()[0] = le.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< SetCommState(%s, %s) => %s\n", hFile, dcb, res);
        return res;
    }

    public static boolean SetCommTimeouts(HANDLE hFile, COMMTIMEOUTS touts) {
        boolean res;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> SetCommTimeouts(%s, %s)\n", hFile, touts);
        try {
            res = m_K32lib.SetCommTimeouts(hFile, touts);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException le) {
            res = false;
            WinAPI.LastError.get()[0] = le.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< SetCommTimeouts(%s, %s) => %s\n", hFile, touts, res);
        return res;
    }

    public static boolean SetupComm(HANDLE hFile, int inQueueSz, int outQueueSz) {
        boolean res;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> SetCommTimeouts(%s, %d, %d)\n", hFile, inQueueSz, outQueueSz);
        try {
            res = m_K32lib.SetupComm(hFile, inQueueSz, outQueueSz);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException le) {
            res = false;
            WinAPI.LastError.get()[0] = le.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< SetCommTimeouts(%s, %d, %d) => %s\n", hFile, inQueueSz, outQueueSz, res);
        return res;
    }

    public static boolean SetCommBreak(HANDLE hFile) {
        boolean res;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> SetCommBreak(%s)\n", hFile);
        try {
            res = m_K32lib.SetCommBreak(hFile);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException le) {
            res = false;
            WinAPI.LastError.get()[0] = le.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< SetCommBreak(%s) => %s\n", hFile, res);
        return res;
    }

    public static boolean ClearCommBreak(HANDLE hFile) {
        boolean res;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> ClearCommBreak(%s)\n", hFile);
        try {
            res = m_K32lib.ClearCommBreak(hFile);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException le) {
            res = false;
            WinAPI.LastError.get()[0] = le.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< ClearCommBreak(%s) => %s\n", hFile, res);
        return res;
    }

    public static boolean GetCommModemStatus(HANDLE hFile, int[] stat) {
        boolean res;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> GetCommModemStatus(%s,0x%08X)\n", hFile, stat[0]);
        try {
            res = m_K32lib.GetCommModemStatus(hFile, stat);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException le) {
            res = false;
            WinAPI.LastError.get()[0] = le.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< GetCommModemStatus(%s,0x%08X) => %s\n", hFile, stat[0], res);
        return res;
    }

    public static boolean EscapeCommFunction(HANDLE hFile, int func) {
        boolean res;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> EscapeCommFunction(%s,0x%08X)\n", hFile, func);
        try {
            res = m_K32lib.EscapeCommFunction(hFile, func);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException le) {
            res = false;
            WinAPI.LastError.get()[0] = le.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< EscapeCommFunction(%s,0x%08X) => %s\n", hFile, func, res);
        return res;
    }

    public static HANDLE CreateEvent(SECURITY_ATTRIBUTES security, boolean manual, boolean initial, String name) {
        HANDLE h;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> CreateEventA(%s, %s, %s, %s)\n", JTermios.JTermiosLogging.ref(security), manual, initial, name);
        try {
            h = m_K32lib.CreateEvent(security, manual, initial, name);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException le) {
            h = INVALID_HANDLE_VALUE;
            WinAPI.LastError.get()[0] = le.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< CreateEventA(%s, %s, %s, %s) => %s\n", JTermios.JTermiosLogging.ref(security), manual, initial, name, h);
        return h;
    }

    public static boolean SetEvent(HANDLE hEvent) {
        boolean res;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> SetEvent(%s)\n", hEvent);
        try {
            res = m_K32lib.SetEvent(hEvent);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException le) {
            res = false;
            WinAPI.LastError.get()[0] = le.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< SetEvent(%s) => %s\n", hEvent, res);
        return res;
    }

    public static boolean ResetEvent(HANDLE hEvent) {
        boolean res;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> ResetEvent(%s)\n", hEvent);
        try {
            res = m_K32lib.ResetEvent(hEvent);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException le) {
            res = false;
            WinAPI.LastError.get()[0] = le.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< ResetEvent(%s) => %s\n", hEvent, res);
        return res;
    }

    public static boolean WaitCommEvent(HANDLE hFile, IntByReference lpEvtMask, OVERLAPPED ovl) {
        boolean res;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> WaitCommEvent(%s, [%d], %s)\n", hFile, lpEvtMask.getValue(), JTermios.JTermiosLogging.ref(ovl));
        try {
            res = m_K32lib.WaitCommEvent(hFile, lpEvtMask, ovl.getPointer());
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException le) {
            res = false;
            WinAPI.LastError.get()[0] = le.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< WaitCommEvent(%s, [%d], %s) => %s\n", hFile, lpEvtMask.getValue(), JTermios.JTermiosLogging.ref(ovl), res);
        return res;
    }

    public static boolean WaitCommEvent(HANDLE hFile, int[] lpEvtMask) {
        boolean res;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> WaitCommEvent(%s, [%d], %s) => %s\n", hFile, lpEvtMask[0], null);
        IntByReference brlpEvtMask = new IntByReference(lpEvtMask[0]);
        try {
            res = m_K32lib.WaitCommEvent(hFile, brlpEvtMask, null);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException le) {
            res = false;
            WinAPI.LastError.get()[0] = le.getErrorCode();
        }
        lpEvtMask[0] = brlpEvtMask.getValue();
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< WaitCommEvent(%s, [%d], %s) => %s\n", hFile, lpEvtMask[0], null, res);
        return res;
    }

    public static int WaitForSingleObject(HANDLE hHandle, int dwMilliseconds) {
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> WaitForSingleObject(%s, %d)\n", hHandle, dwMilliseconds);
        int res = m_K32lib.WaitForSingleObject(hHandle, dwMilliseconds);
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< WaitForSingleObject(%s, %d) => %s\n", hHandle, dwMilliseconds, res);
        return res;
    }

    public static int WaitForMultipleObjects(int nCount, HANDLE[] lpHandles, boolean bWaitAll, int dwMilliseconds) {
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> WaitForMultipleObjects(%d, %s, %s, %d)\n", nCount, JTermios.JTermiosLogging.log(lpHandles, 3), bWaitAll, dwMilliseconds);
        int res = m_K32libWM.WaitForMultipleObjects(nCount, lpHandles, bWaitAll, dwMilliseconds);
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< WaitForMultipleObjects(%d, %s, %s, %d) => %s\n", nCount, JTermios.JTermiosLogging.log(lpHandles, 3), bWaitAll, dwMilliseconds, res);
        return res;
    }

    public static boolean GetOverlappedResult(HANDLE hFile, OVERLAPPED ovl, int[] ntfrd, boolean wait) {
        boolean res;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> GetOverlappedResult(%s, %s, [%d], %s)\n", hFile, JTermios.JTermiosLogging.ref(ovl), ntfrd[0], wait);
        try {
            res = m_K32lib.GetOverlappedResult(hFile, ovl.getPointer(), ntfrd, wait);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException le) {
            res = false;
            WinAPI.LastError.get()[0] = le.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< GetOverlappedResult(%s, %s, [%d], %s) => %s\n", hFile, JTermios.JTermiosLogging.ref(ovl), ntfrd[0], wait, res);
        return res;
    }

    public static int GetLastError() {
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> GetLastError()\n", new Object[0]);
        int res = LastError.get()[0];
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< GetLastError() => %d\n", res);
        return res;
    }

    public static int FormatMessageW(int flags, Pointer src, int msgId, int langId, Pointer dst, int sze, Pointer va_list) {
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> FormatMessageW(%08x, %08x, %d, %d, %s, %d, %s)\n", flags, src, msgId, langId, dst, sze, va_list);
        int res = m_K32lib.FormatMessageW(flags, src, msgId, langId, dst, sze, va_list);
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< FormatMessageW(%08x, %08x, %d, %d, %s, %d, %s) => %d\n", flags, src, msgId, langId, dst, sze, va_list, res);
        return res;
    }

    public static int QueryDosDevice(String name, byte[] buffer, int bsize) {
        int res;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> QueryDosDeviceA(%s, %s, %d)\n", name, buffer, bsize);
        try {
            res = m_K32lib.QueryDosDevice(name, buffer, bsize);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException le) {
            res = 0;
            WinAPI.LastError.get()[0] = le.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< QueryDosDeviceA(%s, %s, %d) => %d\n", name, buffer, bsize, res);
        return res;
    }

    static {
        Native.setPreserveLastError(true);
        m_K32libWM = (WaitMultiple)Native.loadLibrary("kernel32", WaitMultiple.class, W32APIOptions.ASCII_OPTIONS);
        Native.register(Windows_kernel32_lib_Direct.class, NativeLibrary.getInstance("kernel32", W32APIOptions.ASCII_OPTIONS));
        m_K32libDM = new Windows_kernel32_lib_Direct();
        m_K32lib = m_K32libDM;
        LastError = new ThreadLocal<int[]>(){

            @Override
            protected int[] initialValue() {
                return new int[1];
            }
        };
        INVALID_HANDLE_VALUE = new HANDLE(Pointer.createConstant(Pointer.SIZE == 8 ? -1L : 0xFFFFFFFFL));
        NULL = new HANDLE(Pointer.createConstant(0));
    }

    public static class COMSTAT
    extends Structure {
        public int fFlags;
        public static final int fCtsHold = 1;
        public static final int fDsrHold = 2;
        public static final int fRlsdHold = 4;
        public static final int fXoffHold = 8;
        public static final int fXoffSent = 16;
        public static final int fEof = 32;
        public static final int fTxim = 64;
        public static final int fReserved = -128;
        public int cbInQue;
        public int cbOutQue;

        @Override
        protected List getFieldOrder() {
            return Arrays.asList("fFlags", "cbInQue", "cbOutQue");
        }

        @Override
        public String toString() {
            return String.format("[fFlags %04X cbInQue %d cbInQue %d]", this.fFlags, this.cbInQue, this.cbOutQue);
        }
    }

    public static class COMMTIMEOUTS
    extends Structure {
        public int ReadIntervalTimeout;
        public int ReadTotalTimeoutMultiplier;
        public int ReadTotalTimeoutConstant;
        public int WriteTotalTimeoutMultiplier;
        public int WriteTotalTimeoutConstant;

        @Override
        protected List getFieldOrder() {
            return Arrays.asList("ReadIntervalTimeout", "ReadTotalTimeoutMultiplier", "ReadTotalTimeoutConstant", "WriteTotalTimeoutMultiplier", "WriteTotalTimeoutConstant");
        }

        @Override
        public String toString() {
            return String.format("[ReadIntervalTimeout %d ReadTotalTimeoutMultiplier %d ReadTotalTimeoutConstant %d WriteTotalTimeoutMultiplier %d WriteTotalTimeoutConstant %d]", this.ReadIntervalTimeout, this.ReadTotalTimeoutMultiplier, this.ReadTotalTimeoutConstant, this.WriteTotalTimeoutMultiplier, this.WriteTotalTimeoutConstant);
        }
    }

    public static class DCB
    extends Structure {
        public int DCBlength;
        public int BaudRate;
        public int fFlags;
        public static final int fBinary = 1;
        public static final int fParity = 2;
        public static final int fOutxCtsFlow = 4;
        public static final int fOutxDsrFlow = 8;
        public static final int fDtrControl = 48;
        public static final int fDsrSensitivity = 64;
        public static final int fTXContinueOnXoff = 128;
        public static final int fOutX = 256;
        public static final int fInX = 512;
        public static final int fErrorChar = 1024;
        public static final int fNull = 2048;
        public static final int fRtsControl = 12288;
        public static final int fAbortOnError = 16384;
        public static final int fDummy2 = Short.MIN_VALUE;
        public short wReserved;
        public short XonLim;
        public short XoffLim;
        public byte ByteSize;
        public byte Parity;
        public byte StopBits;
        public byte XonChar;
        public byte XoffChar;
        public byte ErrorChar;
        public byte EofChar;
        public byte EvtChar;
        public short wReserved1;

        @Override
        protected List getFieldOrder() {
            return Arrays.asList("DCBlength", "BaudRate", "fFlags", "wReserved", "XonLim", "XoffLim", "ByteSize", "Parity", "StopBits", "XonChar", "XoffChar", "ErrorChar", "EofChar", "EvtChar", "wReserved1");
        }

        @Override
        public String toString() {
            return String.format("[BaudRate %d fFlags %04X wReserved %d XonLim %d XoffLim %d ByteSize %d Parity %d StopBits %d XonChar %02X XoffChar %02X ErrorChar %02X EofChar %02X EvtChar %02X wReserved1 %d]", this.BaudRate, this.fFlags, this.wReserved, this.XonLim, this.XoffLim, this.ByteSize, this.Parity, this.StopBits, this.XonChar, this.XoffChar, this.ErrorChar, this.EofChar, this.EvtChar, this.wReserved1);
        }
    }

    public static class SECURITY_ATTRIBUTES
    extends Structure {
        public int nLength;
        public Pointer lpSecurityDescriptor;
        public boolean bInheritHandle;

        @Override
        protected List getFieldOrder() {
            return Arrays.asList("nLength", "lpSecurityDescriptor", "bInheritHandle");
        }
    }

    public static class OVERLAPPED
    extends Structure {
        public ULONG_PTR Internal;
        public ULONG_PTR InternalHigh;
        public int Offset;
        public int OffsetHigh;
        public HANDLE hEvent;

        @Override
        protected List getFieldOrder() {
            return Arrays.asList("Internal", "InternalHigh", "Offset", "OffsetHigh", "hEvent");
        }

        public OVERLAPPED() {
            this.setAutoSynch(false);
        }

        @Override
        public String toString() {
            return String.format("[Offset %d OffsetHigh %d hEvent %s]", this.Offset, this.OffsetHigh, this.hEvent.toString());
        }
    }

    public static class ULONG_PTR
    extends IntegerType {
        public ULONG_PTR() {
            this(0L);
        }

        public ULONG_PTR(long value) {
            super(Pointer.SIZE, value);
        }
    }

    public static interface Windows_kernel32_lib
    extends StdCallLibrary {
        public HANDLE CreateFile(String var1, int var2, int var3, SECURITY_ATTRIBUTES var4, int var5, int var6, Pointer var7);

        public boolean WriteFile(HANDLE var1, byte[] var2, int var3, int[] var4, Pointer var5);

        public boolean WriteFile(HANDLE var1, Pointer var2, int var3, int[] var4, Pointer var5);

        public boolean ReadFile(HANDLE var1, byte[] var2, int var3, int[] var4, Pointer var5);

        public boolean ReadFile(HANDLE var1, Pointer var2, int var3, int[] var4, Pointer var5);

        public boolean FlushFileBuffers(HANDLE var1);

        public boolean PurgeComm(HANDLE var1, int var2);

        public boolean CancelIo(HANDLE var1);

        public boolean CloseHandle(HANDLE var1);

        public boolean ClearCommError(HANDLE var1, int[] var2, COMSTAT var3);

        public boolean SetCommMask(HANDLE var1, int var2);

        public boolean GetCommMask(HANDLE var1, int[] var2);

        public boolean GetCommState(HANDLE var1, DCB var2);

        public boolean SetCommState(HANDLE var1, DCB var2);

        public boolean SetCommTimeouts(HANDLE var1, COMMTIMEOUTS var2);

        public boolean SetupComm(HANDLE var1, int var2, int var3);

        public boolean SetCommBreak(HANDLE var1);

        public boolean ClearCommBreak(HANDLE var1);

        public boolean GetCommModemStatus(HANDLE var1, int[] var2);

        public boolean EscapeCommFunction(HANDLE var1, int var2);

        public HANDLE CreateEvent(SECURITY_ATTRIBUTES var1, boolean var2, boolean var3, String var4);

        public boolean ResetEvent(HANDLE var1);

        public boolean SetEvent(HANDLE var1);

        public boolean WaitCommEvent(HANDLE var1, IntByReference var2, Pointer var3);

        public int WaitForSingleObject(HANDLE var1, int var2);

        public boolean GetOverlappedResult(HANDLE var1, Pointer var2, int[] var3, boolean var4);

        public int FormatMessageW(int var1, Pointer var2, int var3, int var4, Pointer var5, int var6, Pointer var7);

        public int QueryDosDevice(String var1, byte[] var2, int var3);
    }

    public static interface WaitMultiple
    extends StdCallLibrary {
        public int WaitForMultipleObjects(int var1, HANDLE[] var2, boolean var3, int var4);
    }

    public static class Windows_kernel32_lib_Direct
    implements Windows_kernel32_lib {
        @Override
        public native HANDLE CreateFile(String var1, int var2, int var3, SECURITY_ATTRIBUTES var4, int var5, int var6, Pointer var7) throws LastErrorException;

        @Override
        public native boolean WriteFile(HANDLE var1, byte[] var2, int var3, int[] var4, Pointer var5) throws LastErrorException;

        @Override
        public native boolean WriteFile(HANDLE var1, Pointer var2, int var3, int[] var4, Pointer var5) throws LastErrorException;

        @Override
        public native boolean ReadFile(HANDLE var1, byte[] var2, int var3, int[] var4, Pointer var5) throws LastErrorException;

        @Override
        public native boolean ReadFile(HANDLE var1, Pointer var2, int var3, int[] var4, Pointer var5) throws LastErrorException;

        @Override
        public native boolean FlushFileBuffers(HANDLE var1) throws LastErrorException;

        @Override
        public native boolean PurgeComm(HANDLE var1, int var2) throws LastErrorException;

        @Override
        public native boolean CancelIo(HANDLE var1) throws LastErrorException;

        @Override
        public native boolean CloseHandle(HANDLE var1) throws LastErrorException;

        @Override
        public native boolean ClearCommError(HANDLE var1, int[] var2, COMSTAT var3) throws LastErrorException;

        @Override
        public native boolean SetCommMask(HANDLE var1, int var2) throws LastErrorException;

        @Override
        public native boolean GetCommMask(HANDLE var1, int[] var2) throws LastErrorException;

        @Override
        public native boolean GetCommState(HANDLE var1, DCB var2) throws LastErrorException;

        @Override
        public native boolean SetCommState(HANDLE var1, DCB var2) throws LastErrorException;

        @Override
        public native boolean SetCommTimeouts(HANDLE var1, COMMTIMEOUTS var2) throws LastErrorException;

        @Override
        public native boolean SetupComm(HANDLE var1, int var2, int var3) throws LastErrorException;

        @Override
        public native boolean SetCommBreak(HANDLE var1) throws LastErrorException;

        @Override
        public native boolean ClearCommBreak(HANDLE var1) throws LastErrorException;

        @Override
        public native boolean GetCommModemStatus(HANDLE var1, int[] var2) throws LastErrorException;

        @Override
        public native boolean EscapeCommFunction(HANDLE var1, int var2) throws LastErrorException;

        @Override
        public native HANDLE CreateEvent(SECURITY_ATTRIBUTES var1, boolean var2, boolean var3, String var4) throws LastErrorException;

        @Override
        public native boolean ResetEvent(HANDLE var1) throws LastErrorException;

        @Override
        public native boolean SetEvent(HANDLE var1) throws LastErrorException;

        @Override
        public native boolean WaitCommEvent(HANDLE var1, IntByReference var2, Pointer var3) throws LastErrorException;

        @Override
        public native int WaitForSingleObject(HANDLE var1, int var2);

        @Override
        public native boolean GetOverlappedResult(HANDLE var1, Pointer var2, int[] var3, boolean var4) throws LastErrorException;

        @Override
        public native int FormatMessageW(int var1, Pointer var2, int var3, int var4, Pointer var5, int var6, Pointer var7);

        @Override
        public native int QueryDosDevice(String var1, byte[] var2, int var3) throws LastErrorException;
    }

    public static class HANDLE
    extends PointerType {
        private boolean immutable;

        public HANDLE() {
        }

        public HANDLE(Pointer p) {
            this.setPointer(p);
            this.immutable = true;
        }

        @Override
        public Object fromNative(Object nativeValue, FromNativeContext context) {
            Object o = super.fromNative(nativeValue, context);
            if (NULL.equals(o)) {
                return NULL;
            }
            if (INVALID_HANDLE_VALUE.equals(o)) {
                return INVALID_HANDLE_VALUE;
            }
            return o;
        }

        @Override
        public void setPointer(Pointer p) {
            if (this.immutable) {
                throw new UnsupportedOperationException("immutable");
            }
            super.setPointer(p);
        }
    }
}

