/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.ads.discovery;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsDiscovery;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsDiscoveryBlock;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsDiscoveryBlockFingerprint;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsDiscoveryBlockHostName;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsDiscoveryBlockOsData;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsDiscoveryBlockVersion;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsDiscoveryConstants;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsPortNumbers;
import org.apache.plc4x.java.ads.discovery.readwrite.AmsNetId;
import org.apache.plc4x.java.ads.discovery.readwrite.Operation;
import org.apache.plc4x.java.ads.readwrite.AdsConstants;
import org.apache.plc4x.java.api.messages.PlcDiscoveryItem;
import org.apache.plc4x.java.api.messages.PlcDiscoveryItemHandler;
import org.apache.plc4x.java.api.messages.PlcDiscoveryRequest;
import org.apache.plc4x.java.api.messages.PlcDiscoveryResponse;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBufferByteBased;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBufferByteBased;
import org.apache.plc4x.java.spi.messages.DefaultPlcDiscoveryItem;
import org.apache.plc4x.java.spi.messages.DefaultPlcDiscoveryResponse;
import org.apache.plc4x.java.spi.messages.PlcDiscoverer;
import org.apache.plc4x.java.spi.values.PlcSTRING;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdsPlcDiscoverer
implements PlcDiscoverer {
    private final Logger logger = LoggerFactory.getLogger(AdsPlcDiscoverer.class);

    @Override
    public CompletableFuture<PlcDiscoveryResponse> discover(PlcDiscoveryRequest discoveryRequest) {
        return this.discoverWithHandler(discoveryRequest, null);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompletableFuture<PlcDiscoveryResponse> discoverWithHandler(final PlcDiscoveryRequest discoveryRequest, PlcDiscoveryItemHandler handler) {
        future = new CompletableFuture<PlcDiscoveryResponse>();
        values = new ConcurrentLinkedQueue<E>();
        openSockets = new ArrayList<DatagramSocket>();
        try {
            try {
                for (NetworkInterface networkInterface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                    if (networkInterface.isLoopback()) continue;
                    for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
                        if (interfaceAddress.getBroadcast() == null || !(interfaceAddress.getAddress() instanceof Inet4Address)) continue;
                        inet4Address = (Inet4Address)interfaceAddress.getAddress();
                        adsDiscoverySocket = new DatagramSocket(AdsDiscoveryConstants.ADSDISCOVERYUDPDEFAULTPORT, inet4Address);
                        adsDiscoverySocket.setBroadcast(true);
                        openSockets.add(adsDiscoverySocket);
                        thread = new Thread((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$0(java.net.DatagramSocket java.net.Inet4Address org.apache.plc4x.java.api.messages.PlcDiscoveryItemHandler java.util.Queue ), ()V)((AdsPlcDiscoverer)this, (DatagramSocket)adsDiscoverySocket, (Inet4Address)inet4Address, (PlcDiscoveryItemHandler)handler, values));
                        thread.start();
                        try {
                            amsNetId = new AmsNetId(inet4Address.getAddress()[0], inet4Address.getAddress()[1], inet4Address.getAddress()[2], inet4Address.getAddress()[3], 1, 1);
                            discoveryRequestMessage = new AdsDiscovery(0L, Operation.DISCOVERY_REQUEST, amsNetId, AdsPortNumbers.SYSTEM_SERVICE, Collections.emptyList());
                            writeBuffer = new WriteBufferByteBased(discoveryRequestMessage.getLengthInBytes(), ByteOrder.LITTLE_ENDIAN);
                            discoveryRequestMessage.serialize(writeBuffer);
                            broadcastAddress = interfaceAddress.getBroadcast();
                            discoveryRequestPacket = new DatagramPacket(writeBuffer.getBytes(), writeBuffer.getBytes().length, broadcastAddress, AdsDiscoveryConstants.ADSDISCOVERYUDPDEFAULTPORT);
                            adsDiscoverySocket.send(discoveryRequestPacket);
                        }
                        catch (SerializationException e) {
                            this.logger.error("Error serializing ADS discovery request", (Throwable)e);
                        }
                        catch (IOException e) {
                            this.logger.error("Error sending ADS discover request", (Throwable)e);
                        }
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
            catch (SocketException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            ** for (openSocket : openSockets)
        }
lbl-1000:
        // 1 sources

        {
            openSocket.close();
            continue;
        }
lbl44:
        // 1 sources

        timer = new Timer("Discovery Timeout");
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                DefaultPlcDiscoveryResponse response = new DefaultPlcDiscoveryResponse(discoveryRequest, PlcResponseCode.OK, new ArrayList<PlcDiscoveryItem>(values));
                future.complete(response);
            }
        }, 5000L);
        return future;
    }

    public static void main(String[] args) throws Exception {
        AdsPlcDiscoverer discoverer = new AdsPlcDiscoverer();
        CompletableFuture<PlcDiscoveryResponse> discover = discoverer.discover(null);
        PlcDiscoveryResponse plcDiscoveryResponse = discover.get(6000L, TimeUnit.MILLISECONDS);
        System.out.println(plcDiscoveryResponse);
    }

    private /* synthetic */ void lambda$0(DatagramSocket datagramSocket, Inet4Address inet4Address, PlcDiscoveryItemHandler plcDiscoveryItemHandler, Queue queue) {
        try {
            while (true) {
                byte[] buffer = new byte[512];
                DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                datagramSocket.receive(packet);
                InetAddress plcAddress = packet.getAddress();
                ReadBufferByteBased readBuffer = new ReadBufferByteBased(packet.getData(), ByteOrder.LITTLE_ENDIAN);
                AdsDiscovery adsDiscoveryResponse = AdsDiscovery.staticParse(readBuffer);
                if (adsDiscoveryResponse.getRequestId() != 0L || adsDiscoveryResponse.getPortNumber() != AdsPortNumbers.SYSTEM_SERVICE || adsDiscoveryResponse.getOperation() != Operation.DISCOVERY_RESPONSE) continue;
                AmsNetId remoteAmsNetId = adsDiscoveryResponse.getAmsNetId();
                AdsDiscoveryBlockHostName hostNameBlock = null;
                AdsDiscoveryBlockOsData osDataBlock = null;
                AdsDiscoveryBlockVersion versionBlock = null;
                AdsDiscoveryBlockFingerprint fingerprintBlock = null;
                for (AdsDiscoveryBlock block : adsDiscoveryResponse.getBlocks()) {
                    switch (block.getBlockType()) {
                        case HOST_NAME: {
                            hostNameBlock = (AdsDiscoveryBlockHostName)block;
                            break;
                        }
                        case OS_DATA: {
                            osDataBlock = (AdsDiscoveryBlockOsData)block;
                            break;
                        }
                        case VERSION: {
                            versionBlock = (AdsDiscoveryBlockVersion)block;
                            break;
                        }
                        case FINGERPRINT: {
                            fingerprintBlock = (AdsDiscoveryBlockFingerprint)block;
                            break;
                        }
                        default: {
                            this.logger.info(String.format("Unexpected block type: %s", block.getBlockType().toString()));
                        }
                    }
                }
                if (hostNameBlock == null) continue;
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("sourceAmsNetId", String.valueOf(inet4Address.getHostAddress()) + ".1.1");
                options.put("sourceAmsPort", "65534");
                options.put("targetAmsNetId", String.valueOf(remoteAmsNetId.getOctet1()) + "." + remoteAmsNetId.getOctet2() + "." + remoteAmsNetId.getOctet3() + "." + remoteAmsNetId.getOctet4() + "." + remoteAmsNetId.getOctet5() + "." + remoteAmsNetId.getOctet6());
                options.put("targetAmsPort", "851");
                HashMap<String, PlcValue> attributes = new HashMap<String, PlcValue>();
                attributes.put("hostName", new PlcSTRING(hostNameBlock.getHostName().getText()));
                if (versionBlock != null) {
                    byte[] versionData = versionBlock.getVersionData();
                    int patchVersion = (versionData[3] & 0xFF) << 8 | versionData[2] & 0xFF;
                    attributes.put("twinCatVersion", new PlcSTRING(String.format("%d.%d.%d", (short)versionData[0] & 0xFF, (short)versionData[1] & 0xFF, patchVersion)));
                }
                if (fingerprintBlock != null) {
                    attributes.put("fingerprint", new PlcSTRING(new String(fingerprintBlock.getData())));
                }
                DefaultPlcDiscoveryItem plcDiscoveryItem = new DefaultPlcDiscoveryItem("ads", "tcp", String.valueOf(plcAddress.getHostAddress()) + ":" + AdsConstants.ADSTCPDEFAULTPORT, options, hostNameBlock.getHostName().getText(), attributes);
                if (plcDiscoveryItemHandler != null) {
                    plcDiscoveryItemHandler.handle(plcDiscoveryItem);
                }
                queue.add(plcDiscoveryItem);
            }
        }
        catch (SocketException e) {
            if (!"Socket closed".equals(e.getMessage())) {
                this.logger.error("Error receiving ADS discovery response", (Throwable)e);
            }
        }
        catch (IOException e) {
            this.logger.error("Error reading ADS discovery response", (Throwable)e);
        }
        catch (ParseException e) {
            this.logger.error("Error parsing ADS discovery response", (Throwable)e);
        }
    }
}

