/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.ads.discovery.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsDiscoveryBlock;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsPortNumbers;
import org.apache.plc4x.java.ads.discovery.readwrite.AmsNetId;
import org.apache.plc4x.java.ads.discovery.readwrite.Operation;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class AdsDiscovery
implements Message {
    public static final Long HEADER = 1897162243L;
    protected final long requestId;
    protected final Operation operation;
    protected final AmsNetId amsNetId;
    protected final AdsPortNumbers portNumber;
    protected final List<AdsDiscoveryBlock> blocks;

    public AdsDiscovery(long requestId, Operation operation, AmsNetId amsNetId, AdsPortNumbers portNumber, List<AdsDiscoveryBlock> blocks) {
        this.requestId = requestId;
        this.operation = operation;
        this.amsNetId = amsNetId;
        this.portNumber = portNumber;
        this.blocks = blocks;
    }

    public long getRequestId() {
        return this.requestId;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public AmsNetId getAmsNetId() {
        return this.amsNetId;
    }

    public AdsPortNumbers getPortNumber() {
        return this.portNumber;
    }

    public List<AdsDiscoveryBlock> getBlocks() {
        return this.blocks;
    }

    public long getHeader() {
        return HEADER;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("AdsDiscovery", new WithWriterArgs[0]);
        FieldWriterFactory.writeConstField("header", HEADER, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
        FieldWriterFactory.writeSimpleField("requestId", this.requestId, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
        FieldWriterFactory.writeSimpleEnumField("operation", "Operation", this.operation, new DataWriterEnumDefault<Operation, Long>(Operation::getValue, Enum::name, DataWriterFactory.writeUnsignedLong(writeBuffer, 32)), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
        FieldWriterFactory.writeSimpleField("amsNetId", this.amsNetId, new DataWriterComplexDefault(writeBuffer), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
        FieldWriterFactory.writeSimpleEnumField("portNumber", "AdsPortNumbers", this.portNumber, new DataWriterEnumDefault<AdsPortNumbers, Integer>(AdsPortNumbers::getValue, Enum::name, DataWriterFactory.writeUnsignedInt(writeBuffer, 16)), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
        long numBlocks = StaticHelper.COUNT(this.getBlocks());
        FieldWriterFactory.writeImplicitField("numBlocks", numBlocks, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
        FieldWriterFactory.writeComplexTypeArrayField("blocks", this.blocks, writeBuffer, WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
        writeBuffer.popContext("AdsDiscovery", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = 0;
        AdsDiscovery _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        lengthInBits += 32;
        lengthInBits += 32;
        lengthInBits += this.amsNetId.getLengthInBits();
        lengthInBits += 16;
        lengthInBits += 32;
        if (this.blocks != null) {
            int i = 0;
            for (AdsDiscoveryBlock element : this.blocks) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.blocks.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static AdsDiscovery staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return AdsDiscovery.staticParse(readBuffer);
    }

    public static AdsDiscovery staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("AdsDiscovery", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        long header = FieldReaderFactory.readConstField("header", DataReaderFactory.readUnsignedLong(readBuffer, 32), HEADER, WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
        long requestId = FieldReaderFactory.readSimpleField("requestId", DataReaderFactory.readUnsignedLong(readBuffer, 32), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
        Operation operation = (Operation)((Object)FieldReaderFactory.readEnumField("operation", "Operation", new DataReaderEnumDefault<Operation, Long>(Operation::enumForValue, DataReaderFactory.readUnsignedLong(readBuffer, 32)), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN)));
        AmsNetId amsNetId = FieldReaderFactory.readSimpleField("amsNetId", new DataReaderComplexDefault<AmsNetId>(() -> AmsNetId.staticParse(readBuffer), readBuffer), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
        AdsPortNumbers portNumber = (AdsPortNumbers)((Object)FieldReaderFactory.readEnumField("portNumber", "AdsPortNumbers", new DataReaderEnumDefault<AdsPortNumbers, Integer>(AdsPortNumbers::enumForValue, DataReaderFactory.readUnsignedInt(readBuffer, 16)), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN)));
        long numBlocks = FieldReaderFactory.readImplicitField("numBlocks", DataReaderFactory.readUnsignedLong(readBuffer, 32), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
        List<AdsDiscoveryBlock> blocks = FieldReaderFactory.readCountArrayField("blocks", new DataReaderComplexDefault<AdsDiscoveryBlock>(() -> AdsDiscoveryBlock.staticParse(readBuffer), readBuffer), numBlocks, WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
        readBuffer.closeContext("AdsDiscovery", new WithReaderArgs[0]);
        AdsDiscovery _adsDiscovery = new AdsDiscovery(requestId, operation, amsNetId, portNumber, blocks);
        return _adsDiscovery;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AdsDiscovery)) {
            return false;
        }
        AdsDiscovery that = (AdsDiscovery)o;
        return this.getRequestId() == that.getRequestId() && this.getOperation() == that.getOperation() && this.getAmsNetId() == that.getAmsNetId() && this.getPortNumber() == that.getPortNumber() && this.getBlocks() == that.getBlocks();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getRequestId(), this.getOperation(), this.getAmsNetId(), this.getPortNumber(), this.getBlocks()});
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

