/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.ads.discovery.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsDiscoveryBlock;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsDiscoveryBlockType;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class AdsDiscoveryBlockFingerprint
extends AdsDiscoveryBlock
implements Message {
    protected final byte[] data;

    @Override
    public AdsDiscoveryBlockType getBlockType() {
        return AdsDiscoveryBlockType.FINGERPRINT;
    }

    public AdsDiscoveryBlockFingerprint(byte[] data) {
        this.data = data;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    protected void serializeAdsDiscoveryBlockChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("AdsDiscoveryBlockFingerprint", new WithWriterArgs[0]);
        int dataLen = StaticHelper.COUNT(this.getData());
        FieldWriterFactory.writeImplicitField("dataLen", dataLen, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField("data", this.data, DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
        writeBuffer.popContext("AdsDiscoveryBlockFingerprint", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        AdsDiscoveryBlockFingerprint _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 16;
        if (this.data != null) {
            lengthInBits += 8 * this.data.length;
        }
        return lengthInBits;
    }

    public static AdsDiscoveryBlock.AdsDiscoveryBlockBuilder staticParseAdsDiscoveryBlockBuilder(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("AdsDiscoveryBlockFingerprint", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        int dataLen = FieldReaderFactory.readImplicitField("dataLen", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
        byte[] data = readBuffer.readByteArray("data", Math.toIntExact(dataLen), new WithReaderArgs[0]);
        readBuffer.closeContext("AdsDiscoveryBlockFingerprint", new WithReaderArgs[0]);
        return new AdsDiscoveryBlockFingerprintBuilderImpl(data);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AdsDiscoveryBlockFingerprint)) {
            return false;
        }
        AdsDiscoveryBlockFingerprint that = (AdsDiscoveryBlockFingerprint)o;
        return this.getData() == that.getData() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getData());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class AdsDiscoveryBlockFingerprintBuilderImpl
    implements AdsDiscoveryBlock.AdsDiscoveryBlockBuilder {
        private final byte[] data;

        public AdsDiscoveryBlockFingerprintBuilderImpl(byte[] data) {
            this.data = data;
        }

        @Override
        public AdsDiscoveryBlockFingerprint build() {
            AdsDiscoveryBlockFingerprint adsDiscoveryBlockFingerprint = new AdsDiscoveryBlockFingerprint(this.data);
            return adsDiscoveryBlockFingerprint;
        }
    }
}

