/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.ads.discovery.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsDiscoveryBlock;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsDiscoveryBlockType;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class AdsDiscoveryBlockOsData
extends AdsDiscoveryBlock
implements Message {
    protected final byte[] osData;

    @Override
    public AdsDiscoveryBlockType getBlockType() {
        return AdsDiscoveryBlockType.OS_DATA;
    }

    public AdsDiscoveryBlockOsData(byte[] osData) {
        this.osData = osData;
    }

    public byte[] getOsData() {
        return this.osData;
    }

    @Override
    protected void serializeAdsDiscoveryBlockChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("AdsDiscoveryBlockOsData", new WithWriterArgs[0]);
        int osDataLen = StaticHelper.COUNT(this.getOsData());
        FieldWriterFactory.writeImplicitField("osDataLen", osDataLen, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField("osData", this.osData, DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
        writeBuffer.popContext("AdsDiscoveryBlockOsData", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        AdsDiscoveryBlockOsData _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 16;
        if (this.osData != null) {
            lengthInBits += 8 * this.osData.length;
        }
        return lengthInBits;
    }

    public static AdsDiscoveryBlock.AdsDiscoveryBlockBuilder staticParseAdsDiscoveryBlockBuilder(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("AdsDiscoveryBlockOsData", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        int osDataLen = FieldReaderFactory.readImplicitField("osDataLen", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
        byte[] osData = readBuffer.readByteArray("osData", Math.toIntExact(osDataLen), new WithReaderArgs[0]);
        readBuffer.closeContext("AdsDiscoveryBlockOsData", new WithReaderArgs[0]);
        return new AdsDiscoveryBlockOsDataBuilderImpl(osData);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AdsDiscoveryBlockOsData)) {
            return false;
        }
        AdsDiscoveryBlockOsData that = (AdsDiscoveryBlockOsData)o;
        return this.getOsData() == that.getOsData() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getOsData());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class AdsDiscoveryBlockOsDataBuilderImpl
    implements AdsDiscoveryBlock.AdsDiscoveryBlockBuilder {
        private final byte[] osData;

        public AdsDiscoveryBlockOsDataBuilderImpl(byte[] osData) {
            this.osData = osData;
        }

        @Override
        public AdsDiscoveryBlockOsData build() {
            AdsDiscoveryBlockOsData adsDiscoveryBlockOsData = new AdsDiscoveryBlockOsData(this.osData);
            return adsDiscoveryBlockOsData;
        }
    }
}

