/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.ads.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.ads.readwrite.AmsNetId;
import org.apache.plc4x.java.ads.readwrite.AmsPacket;
import org.apache.plc4x.java.ads.readwrite.CommandId;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class AdsWriteControlRequest
extends AmsPacket
implements Message {
    protected final int adsState;
    protected final int deviceState;
    protected final byte[] data;

    @Override
    public CommandId getCommandId() {
        return CommandId.ADS_WRITE_CONTROL;
    }

    @Override
    public Boolean getResponse() {
        return false;
    }

    public AdsWriteControlRequest(AmsNetId targetAmsNetId, int targetAmsPort, AmsNetId sourceAmsNetId, int sourceAmsPort, long errorCode, long invokeId, int adsState, int deviceState, byte[] data) {
        super(targetAmsNetId, targetAmsPort, sourceAmsNetId, sourceAmsPort, errorCode, invokeId);
        this.adsState = adsState;
        this.deviceState = deviceState;
        this.data = data;
    }

    public int getAdsState() {
        return this.adsState;
    }

    public int getDeviceState() {
        return this.deviceState;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    protected void serializeAmsPacketChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("AdsWriteControlRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("adsState", this.adsState, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("deviceState", this.deviceState, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        long length = StaticHelper.COUNT(this.getData());
        FieldWriterFactory.writeImplicitField("length", length, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField("data", this.data, DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
        writeBuffer.popContext("AdsWriteControlRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        AdsWriteControlRequest _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 16;
        lengthInBits += 16;
        lengthInBits += 32;
        if (this.data != null) {
            lengthInBits += 8 * this.data.length;
        }
        return lengthInBits;
    }

    public static AmsPacket.AmsPacketBuilder staticParseAmsPacketBuilder(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("AdsWriteControlRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        int adsState = FieldReaderFactory.readSimpleField("adsState", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
        int deviceState = FieldReaderFactory.readSimpleField("deviceState", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
        long length = FieldReaderFactory.readImplicitField("length", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
        byte[] data = readBuffer.readByteArray("data", Math.toIntExact(length), new WithReaderArgs[0]);
        readBuffer.closeContext("AdsWriteControlRequest", new WithReaderArgs[0]);
        return new AdsWriteControlRequestBuilderImpl(adsState, deviceState, data);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AdsWriteControlRequest)) {
            return false;
        }
        AdsWriteControlRequest that = (AdsWriteControlRequest)o;
        return this.getAdsState() == that.getAdsState() && this.getDeviceState() == that.getDeviceState() && this.getData() == that.getData() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getAdsState(), this.getDeviceState(), this.getData());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class AdsWriteControlRequestBuilderImpl
    implements AmsPacket.AmsPacketBuilder {
        private final int adsState;
        private final int deviceState;
        private final byte[] data;

        public AdsWriteControlRequestBuilderImpl(int adsState, int deviceState, byte[] data) {
            this.adsState = adsState;
            this.deviceState = deviceState;
            this.data = data;
        }

        @Override
        public AdsWriteControlRequest build(AmsNetId targetAmsNetId, int targetAmsPort, AmsNetId sourceAmsNetId, int sourceAmsPort, long errorCode, long invokeId) {
            AdsWriteControlRequest adsWriteControlRequest = new AdsWriteControlRequest(targetAmsNetId, targetAmsPort, sourceAmsNetId, sourceAmsPort, errorCode, invokeId, this.adsState, this.deviceState, this.data);
            return adsWriteControlRequest;
        }
    }
}

