/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.ads.readwrite;

import java.math.BigInteger;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import org.apache.plc4x.java.ads.readwrite.PlcValueType;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcBOOL;
import org.apache.plc4x.java.spi.values.PlcBYTE;
import org.apache.plc4x.java.spi.values.PlcCHAR;
import org.apache.plc4x.java.spi.values.PlcDATE;
import org.apache.plc4x.java.spi.values.PlcDATE_AND_TIME;
import org.apache.plc4x.java.spi.values.PlcDINT;
import org.apache.plc4x.java.spi.values.PlcDWORD;
import org.apache.plc4x.java.spi.values.PlcINT;
import org.apache.plc4x.java.spi.values.PlcLDATE;
import org.apache.plc4x.java.spi.values.PlcLDATE_AND_TIME;
import org.apache.plc4x.java.spi.values.PlcLINT;
import org.apache.plc4x.java.spi.values.PlcLREAL;
import org.apache.plc4x.java.spi.values.PlcLTIME;
import org.apache.plc4x.java.spi.values.PlcLTIME_OF_DAY;
import org.apache.plc4x.java.spi.values.PlcLWORD;
import org.apache.plc4x.java.spi.values.PlcREAL;
import org.apache.plc4x.java.spi.values.PlcSINT;
import org.apache.plc4x.java.spi.values.PlcSTRING;
import org.apache.plc4x.java.spi.values.PlcTIME;
import org.apache.plc4x.java.spi.values.PlcTIME_OF_DAY;
import org.apache.plc4x.java.spi.values.PlcUDINT;
import org.apache.plc4x.java.spi.values.PlcUINT;
import org.apache.plc4x.java.spi.values.PlcULINT;
import org.apache.plc4x.java.spi.values.PlcUSINT;
import org.apache.plc4x.java.spi.values.PlcWCHAR;
import org.apache.plc4x.java.spi.values.PlcWORD;
import org.apache.plc4x.java.spi.values.PlcWSTRING;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataItem.class);

    public static PlcValue staticParse(ReadBuffer readBuffer, PlcValueType plcValueType, Integer stringLength) throws ParseException {
        if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.BOOL)) {
            Byte reservedField0 = FieldReaderFactory.readReservedField("reserved", DataReaderFactory.readUnsignedByte(readBuffer, 7), (byte)0, new WithReaderArgs[0]);
            boolean value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readBoolean(readBuffer), new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.BYTE)) {
            short value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedShort(readBuffer, 8), new WithReaderArgs[0]);
            return new PlcBYTE(value);
        }
        if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.WORD)) {
            int value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
            return new PlcWORD(value);
        }
        if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.DWORD)) {
            long value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
            return new PlcDWORD(value);
        }
        if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.LWORD)) {
            BigInteger value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedBigInteger(readBuffer, 64), new WithReaderArgs[0]);
            return new PlcLWORD(value);
        }
        if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.SINT)) {
            byte value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readSignedByte(readBuffer, 8), new WithReaderArgs[0]);
            return new PlcSINT(value);
        }
        if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.USINT)) {
            short value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedShort(readBuffer, 8), new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.INT)) {
            short value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readSignedShort(readBuffer, 16), new WithReaderArgs[0]);
            return new PlcINT(value);
        }
        if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.UINT)) {
            int value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
            return new PlcUINT(value);
        }
        if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.DINT)) {
            int value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.UDINT)) {
            long value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
            return new PlcUDINT(value);
        }
        if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.LINT)) {
            long value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readSignedLong(readBuffer, 64), new WithReaderArgs[0]);
            return new PlcLINT(value);
        }
        if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.ULINT)) {
            BigInteger value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedBigInteger(readBuffer, 64), new WithReaderArgs[0]);
            return new PlcULINT(value);
        }
        if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.REAL)) {
            float value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readFloat(readBuffer, 32), new WithReaderArgs[0]).floatValue();
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.LREAL)) {
            double value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readDouble(readBuffer, 64), new WithReaderArgs[0]);
            return new PlcLREAL(value);
        }
        if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.CHAR)) {
            String value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readString(readBuffer, 8), WithOption.WithEncoding("Windows-1252"));
            return new PlcCHAR(value);
        }
        if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.WCHAR)) {
            String value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readString(readBuffer, 16), WithOption.WithEncoding("UTF-16LE"));
            return new PlcWCHAR(value);
        }
        if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.STRING)) {
            String value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readString(readBuffer, stringLength * 8), WithOption.WithEncoding("Windows-1252"));
            Short reservedField0 = FieldReaderFactory.readReservedField("reserved", DataReaderFactory.readUnsignedShort(readBuffer, 8), (short)0, new WithReaderArgs[0]);
            return new PlcSTRING(value);
        }
        if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.WSTRING)) {
            String value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readString(readBuffer, stringLength * 8 * 2), WithOption.WithEncoding("UTF-16LE"));
            Integer reservedField0 = FieldReaderFactory.readReservedField("reserved", DataReaderFactory.readUnsignedInt(readBuffer, 16), 0, new WithReaderArgs[0]);
            return new PlcWSTRING(value);
        }
        if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.TIME)) {
            long milliseconds = FieldReaderFactory.readSimpleField("milliseconds", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
            return PlcTIME.ofMilliseconds(milliseconds);
        }
        if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.LTIME)) {
            BigInteger nanoseconds = FieldReaderFactory.readSimpleField("nanoseconds", DataReaderFactory.readUnsignedBigInteger(readBuffer, 64), new WithReaderArgs[0]);
            return PlcLTIME.ofNanoseconds(nanoseconds);
        }
        if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.DATE)) {
            long secondsSinceEpoch = FieldReaderFactory.readSimpleField("secondsSinceEpoch", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
            return PlcDATE.ofSecondsSinceEpoch(secondsSinceEpoch);
        }
        if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.LDATE)) {
            BigInteger nanosecondsSinceEpoch = FieldReaderFactory.readSimpleField("nanosecondsSinceEpoch", DataReaderFactory.readUnsignedBigInteger(readBuffer, 64), new WithReaderArgs[0]);
            return PlcLDATE.ofNanosecondsSinceEpoch(nanosecondsSinceEpoch);
        }
        if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.TIME_OF_DAY)) {
            long millisecondsSinceMidnight = FieldReaderFactory.readSimpleField("millisecondsSinceMidnight", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
            return PlcTIME_OF_DAY.ofMillisecondsSinceMidnight(millisecondsSinceMidnight);
        }
        if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.LTIME_OF_DAY)) {
            BigInteger nanosecondsSinceMidnight = FieldReaderFactory.readSimpleField("nanosecondsSinceMidnight", DataReaderFactory.readUnsignedBigInteger(readBuffer, 64), new WithReaderArgs[0]);
            return PlcLTIME_OF_DAY.ofNanosecondsSinceMidnight(nanosecondsSinceMidnight);
        }
        if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.DATE_AND_TIME)) {
            long secondsSinceEpoch = FieldReaderFactory.readSimpleField("secondsSinceEpoch", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
            return PlcDATE_AND_TIME.ofSecondsSinceEpoch(secondsSinceEpoch);
        }
        if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.LDATE_AND_TIME)) {
            BigInteger nanosecondsSinceEpoch = FieldReaderFactory.readSimpleField("nanosecondsSinceEpoch", DataReaderFactory.readUnsignedBigInteger(readBuffer, 64), new WithReaderArgs[0]);
            return PlcLDATE_AND_TIME.ofNanosecondsSinceEpoch(nanosecondsSinceEpoch);
        }
        return null;
    }

    public static int getLengthInBytes(PlcValue _value, PlcValueType plcValueType, Integer stringLength) {
        return (int)Math.ceil((double)DataItem.getLengthInBits(_value, plcValueType, stringLength) / 8.0);
    }

    public static int getLengthInBits(PlcValue _value, PlcValueType plcValueType, Integer stringLength) {
        int lengthInBits = 0;
        if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.BOOL)) {
            lengthInBits += 7;
            ++lengthInBits;
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.BYTE)) {
            lengthInBits += 8;
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.WORD)) {
            lengthInBits += 16;
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.DWORD)) {
            lengthInBits += 32;
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.LWORD)) {
            lengthInBits += 64;
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.SINT)) {
            lengthInBits += 8;
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.USINT)) {
            lengthInBits += 8;
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.INT)) {
            lengthInBits += 16;
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.UINT)) {
            lengthInBits += 16;
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.DINT)) {
            lengthInBits += 32;
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.UDINT)) {
            lengthInBits += 32;
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.LINT)) {
            lengthInBits += 64;
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.ULINT)) {
            lengthInBits += 64;
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.REAL)) {
            lengthInBits += 32;
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.LREAL)) {
            lengthInBits += 64;
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.CHAR)) {
            lengthInBits += 8;
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.WCHAR)) {
            lengthInBits += 16;
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.STRING)) {
            lengthInBits += stringLength * 8;
            lengthInBits += 8;
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.WSTRING)) {
            lengthInBits += stringLength * 8 * 2;
            lengthInBits += 16;
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.TIME)) {
            lengthInBits += 32;
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.LTIME)) {
            lengthInBits += 64;
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.DATE)) {
            lengthInBits += 32;
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.LDATE)) {
            lengthInBits += 64;
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.TIME_OF_DAY)) {
            lengthInBits += 32;
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.LTIME_OF_DAY)) {
            lengthInBits += 64;
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.DATE_AND_TIME)) {
            lengthInBits += 32;
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.LDATE_AND_TIME)) {
            lengthInBits += 64;
        }
        return lengthInBits;
    }

    public static void staticSerialize(WriteBuffer writeBuffer, PlcValue _value, PlcValueType plcValueType, Integer stringLength) throws SerializationException {
        DataItem.staticSerialize(writeBuffer, _value, plcValueType, stringLength, ByteOrder.BIG_ENDIAN);
    }

    public static void staticSerialize(WriteBuffer writeBuffer, PlcValue _value, PlcValueType plcValueType, Integer stringLength, ByteOrder byteOrder) throws SerializationException {
        if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.BOOL)) {
            FieldWriterFactory.writeReservedField("reserved", (byte)0, DataWriterFactory.writeUnsignedByte(writeBuffer, 7), new WithWriterArgs[0]);
            FieldWriterFactory.writeSimpleField("value", _value.getBoolean(), DataWriterFactory.writeBoolean(writeBuffer), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.BYTE)) {
            FieldWriterFactory.writeSimpleField("value", _value.getShort(), DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.WORD)) {
            FieldWriterFactory.writeSimpleField("value", _value.getInteger(), DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.DWORD)) {
            FieldWriterFactory.writeSimpleField("value", _value.getLong(), DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.LWORD)) {
            FieldWriterFactory.writeSimpleField("value", _value.getBigInteger(), DataWriterFactory.writeUnsignedBigInteger(writeBuffer, 64), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.SINT)) {
            FieldWriterFactory.writeSimpleField("value", _value.getByte(), DataWriterFactory.writeSignedByte(writeBuffer, 8), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.USINT)) {
            FieldWriterFactory.writeSimpleField("value", _value.getShort(), DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.INT)) {
            FieldWriterFactory.writeSimpleField("value", _value.getShort(), DataWriterFactory.writeSignedShort(writeBuffer, 16), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.UINT)) {
            FieldWriterFactory.writeSimpleField("value", _value.getInteger(), DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.DINT)) {
            FieldWriterFactory.writeSimpleField("value", _value.getInteger(), DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.UDINT)) {
            FieldWriterFactory.writeSimpleField("value", _value.getLong(), DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.LINT)) {
            FieldWriterFactory.writeSimpleField("value", _value.getLong(), DataWriterFactory.writeSignedLong(writeBuffer, 64), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.ULINT)) {
            FieldWriterFactory.writeSimpleField("value", _value.getBigInteger(), DataWriterFactory.writeUnsignedBigInteger(writeBuffer, 64), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.REAL)) {
            FieldWriterFactory.writeSimpleField("value", Float.valueOf(_value.getFloat()), DataWriterFactory.writeFloat(writeBuffer, 32), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.LREAL)) {
            FieldWriterFactory.writeSimpleField("value", _value.getDouble(), DataWriterFactory.writeDouble(writeBuffer, 64), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.CHAR)) {
            FieldWriterFactory.writeSimpleField("value", _value.getString(), DataWriterFactory.writeString(writeBuffer, 8), WithOption.WithEncoding("Windows-1252"));
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.WCHAR)) {
            FieldWriterFactory.writeSimpleField("value", _value.getString(), DataWriterFactory.writeString(writeBuffer, 16), WithOption.WithEncoding("UTF-16LE"));
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.STRING)) {
            FieldWriterFactory.writeSimpleField("value", _value.getString(), DataWriterFactory.writeString(writeBuffer, stringLength * 8), WithOption.WithEncoding("Windows-1252"));
            FieldWriterFactory.writeReservedField("reserved", (short)0, DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.WSTRING)) {
            FieldWriterFactory.writeSimpleField("value", _value.getString(), DataWriterFactory.writeString(writeBuffer, stringLength * 8 * 2), WithOption.WithEncoding("UTF-16LE"));
            FieldWriterFactory.writeReservedField("reserved", 0, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.TIME)) {
            FieldWriterFactory.writeSimpleField("milliseconds", _value.getDuration().toMillis(), DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.LTIME)) {
            FieldWriterFactory.writeSimpleField("nanoseconds", BigInteger.valueOf(_value.getDuration().toNanos()), DataWriterFactory.writeUnsignedBigInteger(writeBuffer, 64), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.DATE)) {
            FieldWriterFactory.writeSimpleField("secondsSinceEpoch", _value.getDateTime().toEpochSecond(ZoneOffset.UTC), DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.LDATE)) {
            FieldWriterFactory.writeSimpleField("nanosecondsSinceEpoch", BigInteger.valueOf(_value.getDateTime().toEpochSecond(ZoneOffset.UTC)).multiply(BigInteger.valueOf(1000000000L)).add(BigInteger.valueOf(_value.getDateTime().getNano())), DataWriterFactory.writeUnsignedBigInteger(writeBuffer, 64), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.TIME_OF_DAY)) {
            FieldWriterFactory.writeSimpleField("millisecondsSinceMidnight", _value.getTime().getLong(ChronoField.MILLI_OF_DAY), DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.LTIME_OF_DAY)) {
            FieldWriterFactory.writeSimpleField("nanosecondsSinceMidnight", BigInteger.valueOf(_value.getTime().getLong(ChronoField.NANO_OF_DAY)), DataWriterFactory.writeUnsignedBigInteger(writeBuffer, 64), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.DATE_AND_TIME)) {
            FieldWriterFactory.writeSimpleField("secondsSinceEpoch", _value.getDateTime().toEpochSecond(ZoneOffset.UTC), DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)plcValueType, (Object)PlcValueType.LDATE_AND_TIME)) {
            FieldWriterFactory.writeSimpleField("nanosecondsSinceEpoch", BigInteger.valueOf(_value.getDateTime().toEpochSecond(ZoneOffset.UTC)).multiply(BigInteger.valueOf(1000000000L)).add(BigInteger.valueOf(_value.getDateTime().getNano())), DataWriterFactory.writeUnsignedBigInteger(writeBuffer, 64), new WithWriterArgs[0]);
        }
    }
}

