/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.ads.tag;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.ads.tag.AdsTag;
import org.apache.plc4x.java.api.exceptions.PlcInvalidTagException;
import org.apache.plc4x.java.api.model.ArrayInfo;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.model.DefaultArrayInfo;

public class DirectAdsTag
implements AdsTag {
    private static final Pattern RESOURCE_ADDRESS_PATTERN = Pattern.compile("^((0[xX](?<indexGroupHex>[0-9a-fA-F]+))|(?<indexGroup>\\d+))/((0[xX](?<indexOffsetHex>[0-9a-fA-F]+))|(?<indexOffset>\\d+)):(?<adsDataType>\\w+)(\\[(?<numberOfElements>\\d+)])?");
    private final long indexGroup;
    private final long indexOffset;
    private final String adsDataTypeName;
    private final int numberOfElements;

    public DirectAdsTag(long indexGroup, long indexOffset, String adsDataTypeName, Integer numberOfElements) {
        this.indexGroup = indexGroup;
        this.indexOffset = indexOffset;
        this.adsDataTypeName = Objects.requireNonNull(adsDataTypeName);
        int n = this.numberOfElements = numberOfElements != null ? numberOfElements : 1;
        if (this.numberOfElements <= 0) {
            throw new IllegalArgumentException("numberOfElements must be greater then zero. Was " + this.numberOfElements);
        }
    }

    public static DirectAdsTag of(long indexGroup, long indexOffset, String adsDataTypeName, Integer numberOfElements) {
        return new DirectAdsTag(indexGroup, indexOffset, adsDataTypeName, numberOfElements);
    }

    public static DirectAdsTag of(String address) {
        Matcher matcher = RESOURCE_ADDRESS_PATTERN.matcher(address);
        if (!matcher.matches()) {
            throw new PlcInvalidTagException(address, RESOURCE_ADDRESS_PATTERN, "{indexGroup}/{indexOffset}:{adsDataType}([numberOfElements])?");
        }
        String indexGroupStringHex = matcher.group("indexGroupHex");
        String indexGroupString = matcher.group("indexGroup");
        String indexOffsetStringHex = matcher.group("indexOffsetHex");
        String indexOffsetString = matcher.group("indexOffset");
        long indexGroup = indexGroupStringHex != null ? Long.parseLong(indexGroupStringHex, 16) : Long.parseLong(indexGroupString);
        long indexOffset = indexOffsetStringHex != null ? Long.parseLong(indexOffsetStringHex, 16) : Long.parseLong(indexOffsetString);
        String adsDataTypeString = matcher.group("adsDataType");
        String numberOfElementsString = matcher.group("numberOfElements");
        Integer numberOfElements = numberOfElementsString != null ? Integer.valueOf(numberOfElementsString) : null;
        return new DirectAdsTag(indexGroup, indexOffset, adsDataTypeString, numberOfElements);
    }

    public static boolean matches(String address) {
        return RESOURCE_ADDRESS_PATTERN.matcher(address).matches();
    }

    public long getIndexGroup() {
        return this.indexGroup;
    }

    public long getIndexOffset() {
        return this.indexOffset;
    }

    public String getPlcDataType() {
        return this.adsDataTypeName;
    }

    public int getNumberOfElements() {
        return this.numberOfElements;
    }

    @Override
    public String getAddressString() {
        String address = String.format("0x%d/%d:%s", this.getIndexGroup(), this.getIndexOffset(), this.getPlcDataType());
        if (this.getNumberOfElements() != 1) {
            address = String.valueOf(address) + "[" + this.getNumberOfElements() + "]";
        }
        return address;
    }

    @Override
    public PlcValueType getPlcValueType() {
        try {
            return PlcValueType.valueOf(this.adsDataTypeName);
        }
        catch (Exception e) {
            return PlcValueType.Struct;
        }
    }

    @Override
    public List<ArrayInfo> getArrayInfo() {
        if (this.getNumberOfElements() != 1) {
            return Collections.singletonList(new DefaultArrayInfo(0, this.getNumberOfElements()));
        }
        return Collections.emptyList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DirectAdsTag)) {
            return false;
        }
        DirectAdsTag that = (DirectAdsTag)o;
        return this.indexGroup == that.indexGroup && this.indexOffset == that.indexOffset;
    }

    public int hashCode() {
        return Objects.hash(this.indexGroup, this.indexOffset);
    }

    public String toString() {
        return "DirectAdsTag{indexGroup=" + this.indexGroup + ", indexOffset=" + this.indexOffset + '}';
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.pushContext(this.getClass().getSimpleName(), new WithWriterArgs[0]);
        writeBuffer.writeUnsignedLong("indexGroup", 32, this.getIndexGroup(), new WithWriterArgs[0]);
        writeBuffer.writeUnsignedLong("indexOffset", 32, this.getIndexOffset(), new WithWriterArgs[0]);
        writeBuffer.writeUnsignedLong("numberOfElements", 32, this.getNumberOfElements(), new WithWriterArgs[0]);
        writeBuffer.writeString("dataType", this.getPlcDataType().getBytes(StandardCharsets.UTF_8).length * 8, this.getPlcDataType(), WithOption.WithEncoding(StandardCharsets.UTF_8.name()));
        writeBuffer.popContext(this.getClass().getSimpleName(), new WithWriterArgs[0]);
    }
}

